//
// Created by m007 on 03/04/2020.
//

#ifndef ROBOT_H
#define ROBOT_H
	#include <stdio.h>
	#include <math.h>
	#include "Vector.h"
	#include "Controller.h"
	#include "Sensor.h"
	#define DOF 4 

/*MOVE C*/
enum Links {REVOLUTION, LINEAR};
enum Trajectory_Types {TRAPEZOIDAL, SPLIN5, SPLIN7};

struct Matrix_4N{
    float m[4][4];
};
struct DH{
    enum Links Type;
    float theta;
    float alpha;
    float d;
    float a;
    struct Matrix_4N A0;
};
struct Motor{
    float Degrees_Kinematics;
    struct Vector_3N pcg;
    float Contrains_v;
    float Contrains_a;
};
struct Eslabon{
    float Lenght;
    float Inertia_tensor[3][3];
    float Cent_Gravity [3];
    float Mass;
    float Tau;
    struct  Vector_3N w;
    struct  Vector_3N wd;
    struct  Vector_3N vd;
    struct  Vector_3N a;
    struct  Vector_3N f;
    struct  Vector_3N M;
    struct DH _DH;
};

struct Position{
    float x;
    float y;
    float z;
};
struct Orientation{
    float roll;
    float pitch;
    float yaw;
};
struct End_Effector{
    struct Orientation _Orientation;
    struct Position _Position;
};
struct Trajectory_Path{
    float q [DOF];
    float qd [DOF];
    float qdd [DOF];
};
struct Trajectory{
    struct Trajectory_Path *traj;
    float Tsampling;
    enum Trajectory_Types _TrajectoryType;
    float duration;
};


struct Robot{
    //matriz herramienta
    float ToolMatrix[4][4];
    struct Matrix_4N BaseMatrix;
    struct Trajectory _Trajectory;
    struct Motor _Motor[DOF];
    struct Eslabon _Eslabon[DOF];
};


struct Matrix_3N{
    float m[3][3];
};


void ForwardKinematics(struct Robot* _Robot,float thetaOffset[DOF]);
void InverseKinematics(struct Robot* Robot1,struct End_Effector* EFF_q,float q[3]);
void Jacobian(struct Robot* Robot1,float q[DOF]);
void init(struct Robot* _Robot, float _ToolMatrix[4][4], float _BaseMatrix[4][4]);
void EulerNewton(struct Robot* Robot1,float q[DOF], float qd[DOF],float qdd[DOF]);
void GravityTorque(struct Robot* _Robot,float q[DOF]);

struct Matrix_4N RotX(float thetaX);
struct Matrix_4N RotY(float thetaY);
struct Matrix_4N RotZ(float thetaZ);
struct Matrix_4N Trans(float dx, float dy, float dz);
struct Matrix_3N multiply_3N(float mat1[][3], float mat2[][3]);
struct Matrix_4N multiply_4N(float mat1[][4], float mat2[][4]);
struct Matrix_3N GetRotation(struct Robot* _Robot, int number);
struct Vector_3N GetPosition(float mat1[][4]);
struct Matrix_3N Inv_3N(float mat1[][3]);


int ConvertTime(float time, float stime);
int FindMinOrMax(const float array[], int size, _Bool minormax);

void Trapezoid(struct Robot* _Robot, struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime);
void Spline_5th (struct Robot* _Robot,  struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime,float time);
void Spline_7th (struct Robot* _Robot,  struct End_Effector* EFF_q0, struct End_Effector* EFF_qf,float stime,float time);

#endif //ROBOT_H
