#include "Controller.h"

Controller::Controller(float _KP, float _KV, float _KI, float _SamplingTime){
    KP = _KP;
    KV = _KV;
    KI = _KI;
    SamplingTime = _SamplingTime;
    PrevErr = 0;
}    
float Controller::ComputeP(float qref, float qi){
 return (qref - qi) * KP;   
}     
float Controller::ComputePD(float qref, float qi, float qdotref, float qdoti){
    return (qref - qi) * KP + (qdotref - qdoti) * KV;
}
/*float Controller::ComputePD(float qref, float qi, float qdotref, float qdoti){
    return (qref - qi) * KP  - qdoti * KV;
}*/
float Controller::ComputePID(float qref, float qi, float qdotref, float qdoti){
    
    float IntegralErr = PrevErr + (qref - qi);
    PrevErr = IntegralErr;
    return (qref-qi) * KP + (qdotref - qdoti) * KV + IntegralErr * KI;
 }