#ifndef MOTIONCOMMAND_H
#define MOTIONCOMMAND_H    
    #include "mbed.h"
    #include "Ro/Robot.h"
    #include "Ro/Trajectory.h"
    
class MotionCommand{
    private:
    Robot* _Robot;
    float* Initial_point;
    float* Final_point;
    float SamplingTime;
    Vector<float> PrevPosition;
    Trajectory* _Trajectory;
    int CurrentCycle;
    int TotalCycle;
    bool IsFinalized;
    
    int Zone;
    int index;
    Ticker TimInterrupt;
    
    void Trapezoid(float q0,float q1, float qd, float qdd,float stime,float Constraints_v,float Contrains_a);
    int SCurve(float q0,float q1, float qd0,float qdf, float qdd,float stime,float Constraints_v,float Constraints_a, float Constraints_j);
    void Spline_5th (float q0,float q1, float qd0, float qd1, float qdd,float stime,float tfin,float Constraints_v ,float Constraints_a);
    void Spline_7th(float q0,float q1, float qd0, float qd1, float qdd,float stime,float tfin,float Constraints_v ,float Constraints_a);
    void TimFunctionMoveL1();
    void StartMoveL1();
    void StopMoveL1();
    
    void TimFunctionMoveL2();
    void StartMoveL2();
    void StopMoveL2();
    
    public:
    
    enum Trajectory_Types {TRAPEZOIDAL, SCURVE, SPLINE5, SPLINE7};
    
    MotionCommand(Robot* Robot1);
    ~MotionCommand();
    
    void MoveJ(End_Effector qf,float v0,float v1,float a,float samplingtime,float time,int zone,Trajectory_Types _trajectory);
    void MoveL1(End_Effector qf, float v, float a,float samplingtime);
    void MoveL2(End_Effector qf, float v, float a,float samplingtime);
    

};

template <typename T>
inline T  sign (T  a);


#endif //MOTIONCOMMAND_H