#include "MotionCommand.h"
template <typename T>
inline T  sign (T  a) {
  return (a > 0 ? 1:-1);
}

MotionCommand::MotionCommand(Robot* Robot1):PrevPosition(Robot1->GetDOF()){
    _Robot = Robot1;
    IsFinalized = false;
    index = 0;
}
MotionCommand::~MotionCommand(){
    delete[] _Trajectory;
}
void MotionCommand::MoveJ(End_Effector qf,float v0,float v1,float a,float samplingtime,float time,int zone,Trajectory_Types _trajectory){
    SamplingTime = samplingtime;
    IsFinalized = false;
    PrevPosition = 0;
    float q0[3];
    Vector<float> PositionF(3),PositionInit(3);
    PositionF(0) = qf.x;
    PositionF(1) = qf.y;
    PositionF(2) = qf.z;
    
    _Trajectory = new Trajectory[3];
    
    
    for (int i=0; i<_Robot->GetDOF();i++){
        if(i<=3){
            _Trajectory[i] = Trajectory(_Robot->GetDOF(),samplingtime);
        }
        q0[i] = _Robot->ReadSensor(i);
    }
    _Robot->ForwardKinematics(q0);
    PositionInit = _Robot->GetEndPosition();
    
    for (int i=0; i<3;i++){
        switch(_trajectory){
       case TRAPEZOIDAL:
           Trapezoid(PositionInit(i),PositionF(i), v0, a,samplingtime,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i));
           break;
       case SCURVE:
           SCurve(PositionInit(i),PositionF(i), v0, v1, a,samplingtime,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i), _Robot->ConstraintsJerkMotor(i));
           break;
       case SPLINE5:
           Spline_5th(PositionInit(i),PositionF(i), v0, v1, a,samplingtime,time,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i));
           break;
       case SPLINE7:
           Spline_7th(PositionInit(i),PositionF(i), v0, v1, a,samplingtime,time,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i));
           break;
        }     
    }
    this->StartMoveL1();
    while(!IsFinalized) {
        asm("nop");
    }
    this->StopMoveL1();
    

}
void MotionCommand::MoveL1(End_Effector qf, float v, float a,float samplingtime){
    SamplingTime = samplingtime;
    IsFinalized = false;
    PrevPosition = 0;
    float q0[_Robot->GetDOF()];
    Vector<float> PositionF(3),PositionInit(3);
    PositionF(0) = qf.x;
    PositionF(1) = qf.y;
    PositionF(2) = qf.z;
    _Trajectory = new Trajectory[3];
    
    
    for (int i=0; i<_Robot->GetDOF();i++){
        if(i<=3){
            _Trajectory[i] = Trajectory(_Robot->GetDOF(),samplingtime);
        }
        q0[i] = _Robot->ReadSensor(i);
    }
    _Robot->ForwardKinematics(q0);
    PositionInit = _Robot->GetEndPosition();
    
    for (int i=0; i<3;i++){
        Trapezoid(PositionInit(i),PositionF(i), v, a,samplingtime,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i));     
    }
    this->StartMoveL1();
    while(!IsFinalized) {
        asm("nop");
    }
    this->StopMoveL1();
}

void MotionCommand::MoveL2(End_Effector qf, float v, float a,float samplingtime){
    SamplingTime = samplingtime;
    IsFinalized = false;
    PrevPosition = 0;
    float q0[3];
    Vector<float> PositionF(3),PositionInit(3);
    PositionF(0) = qf.x;
    PositionF(1) = qf.y;
    PositionF(2) = qf.z;
    _Trajectory = new Trajectory[3];
    
    
    for (int i=0; i<_Robot->GetDOF();i++){
        if(i<=3){
            _Trajectory[i] = Trajectory(_Robot->GetDOF(),samplingtime);
        }
        q0[i] = _Robot->ReadSensor(i);
    }
    _Robot->ForwardKinematics(q0);
    PositionInit = _Robot->GetEndPosition();
    
    for (int i=0; i<3;i++){
        Trapezoid(PositionInit(i),PositionF(i), v, a,samplingtime,_Robot->ConstraintsVelocityMotor(i),_Robot->ConstraintsAccelerationMotor(i));     
    }
    this->StartMoveL2();
    while(!IsFinalized) {
        asm("nop");
    }
    this->StopMoveL2();
}


void MotionCommand::Trapezoid(float _q0,float q1, float qd, float qdd,float stime,float Constraints_v,float Constraints_a){
    float s, signo, t1, t2, tfin, q,qprim,acel;
    s = q1 - _q0;
    signo = sign(s);
    CurrentCycle = 0;
        
        if (fabsf(s) > (powf(Constraints_v,2.0F) / Constraints_a)){
            t1 = Constraints_v / Constraints_a;
            t2 = fabsf(s) / Constraints_v;
            tfin = fabsf(s) / Constraints_v + Constraints_v / Constraints_a;
        }
        else{
            t1 = sqrtf(fabsf(s) / Constraints_a);
            tfin = 2.0F*t1;
            t2 = 0.0F;
        }
        q = _q0;
        qprim = 0;
        float t=0;
        TotalCycle = (int)tfin/stime+1;
        for(int tim=0; tim<((int)(tfin/stime)+1);tim++){
                t = tim*stime;
                //Calculation of the velocity and position for phase 1 (acceleration)
                if (t < t1){
                    qdd = signo*Constraints_a;
                    qprim=qprim+acel*stime;
                    q=q+qprim*stime+0.5F*acel*stime*stime;
                }
                //Calculation of the velocity and position for phase 2 (constant velocity)
                else if ((t >= t1) && (t < t2)){
                    qdd = 0.0F;
                    qprim=signo*qd;
                    q=q+qprim*stime;
                }
                //Calculation of the velocity and position for phase 3 (deceleration)
                else if ((t >= t2) && (t < tfin)){
                    acel = -signo*qdd;
                    qprim=qprim + acel*stime;
                    q=q + qprim*stime+0.5F*acel*powf(stime,2.0F);
                }else{
                    qdd = 0.0F;
                    qd = 0.0F;
                    q = q1;
                }
                _Trajectory[index].Insert(q,qd,qdd);
        }
        index++;
}
    

void MotionCommand::StartMoveL1(){
    TimInterrupt.attach(this,&MotionCommand::TimFunctionMoveL1,SamplingTime);
}   
 void MotionCommand::StopMoveL1(){
    TimInterrupt.detach();
}   
void MotionCommand::TimFunctionMoveL1(){
    if(CurrentCycle <=  TotalCycle ){
        Vector<float> x(_Robot->GetDOF()),v(_Robot->GetDOF());
        Vector<float> Kp(_Robot->GetDOF()),Kv(_Robot->GetDOF());
        int isCorrect;
        float q[_Robot->GetDOF()],xref[_Robot->GetDOF()], vref[_Robot->GetDOF()];
        
        
        for (int i=0; i<_Robot->GetDOF();i++){
            q[i] = _Robot->ReadSensor(i);
            xref[i] =  _Trajectory[i].GetXref(CurrentCycle);
            vref[i] =  _Trajectory[i].GetVref(CurrentCycle);
        }
        
        _Robot->ForwardKinematics(q);
        x = _Robot->GetEndPosition();
        
        if(CurrentCycle == 0){
            v(0) = 0;
            v(1) = 0;
            v(2) = 0;
        }else{
            v(0) = (x(0) - PrevPosition(0)) / SamplingTime;
            v(1) = (x(1) - PrevPosition(1)) / SamplingTime;
            v(2) = (x(2) - PrevPosition(2)) / SamplingTime;
        }
        
        Kp = _Robot->GetKP();
        Kv = _Robot->GetKV();
        
        Vector<float> CartesianForce (6);
        Vector<float> G (_Robot->GetDOF());
        Matrix<float> Jacobian(6,_Robot->GetDOF());
        Matrix<float> JacobianTranspose(_Robot->GetDOF(),6);
        
        Vector<float> Control(_Robot->GetDOF());
    
        for (int i=0; i<6;i++){
            if(i>=3){
                CartesianForce(i) = 0;
                continue;
            }
            CartesianForce(i) = Kp(i) * (xref[i] -x(i)) + Kv(i) * (vref[i] -v(i));
        }
    
        _Robot->GravityTorque(q);
        G = _Robot->GetTorque();
        
        _Robot->Jacobian(q);
        Jacobian = _Robot->GetJacobian();
        JacobianTranspose = Jacobian.Transpose();
        
        Control = (JacobianTranspose * CartesianForce) + G;
        
        Vector<float> SaturationControl(_Robot->GetDOF());
        
        SaturationControl = _Robot->ReturnSaturationControl(Control);
        
        isCorrect = _Robot->SendData(SaturationControl);
        
        PrevPosition = x;    
        CurrentCycle++;
    }else{
        IsFinalized = true;   
    }
    
}    
    
    
    
void MotionCommand::StartMoveL2(){
    TimInterrupt.attach(this,&MotionCommand::TimFunctionMoveL2,SamplingTime);
}   
 void MotionCommand::StopMoveL2(){
    TimInterrupt.detach();
}   
void MotionCommand::TimFunctionMoveL2(){
    if(CurrentCycle <=  TotalCycle ){
        float _q[_Robot->GetDOF()],qsec[_Robot->GetDOF()], q_prim[_Robot->GetDOF()];
        Vector<float> Kp(_Robot->GetDOF()),Kv(_Robot->GetDOF()),q(_Robot->GetDOF()),qref(_Robot->GetDOF()), q_prim_ref(_Robot->GetDOF()), q_sec_ref(_Robot->GetDOF()),
        xref(_Robot->GetDOF()), x_prim_ref(_Robot->GetDOF()), x_sec_ref(_Robot->GetDOF()),Tau(_Robot->GetDOF());
        int isCorrect;
        End_Effector Eref;
        
        for (int i=0; i<_Robot->GetDOF();i++){
            q(i) = _q[i] = _Robot->ReadSensor(i);
            xref(i) =  _Trajectory[i].GetXref(CurrentCycle);
            x_prim_ref(i) =  _Trajectory[i].GetVref(CurrentCycle);
            x_sec_ref(i) =  _Trajectory[i].GetAref(CurrentCycle);
            
            if(CurrentCycle == 0){
                q_prim[i] = 0;
            }else{
                q_prim[i] = (q(i) - PrevPosition(0)) / SamplingTime;
            }
            
        }
        
        Kp = _Robot->GetKP();
        Kv = _Robot->GetKV();
        
        Eref.x = q(0);
        Eref.y = q(1);
        Eref.z = q(2);
        Eref.roll = q(3);
        Eref.pitch = q(4);
        Eref.yaw = q(5);
        
        qref = _Robot->InverseKinematics(&Eref,0);
        Matrix<float> PseudoInverse(_Robot->GetDOF(),6);
        Matrix<float> Jacobian(6,_Robot->GetDOF());
        _Robot->Jacobian(_q);
        Jacobian = _Robot->GetJacobian();
        
        if(_Robot->GetDOF() == 6){
            q_prim_ref = Jacobian.Inverse() * x_prim_ref;
        }else{       
            q_prim_ref = Jacobian.PseudoInverse() * x_prim_ref;
        }
        
        
        for (int i=0; i<6;i++){
            qsec[i] = Kp(i) * (qref(i) -q(i)) + Kv(i) * (q_prim_ref(i) -q_prim[i]);
        }
        
        
        _Robot->EulerNewton(_q,q_prim,qsec);
        Tau = _Robot->GetTorque();
        Vector<float> SaturationControl(_Robot->GetDOF());
        
        SaturationControl = _Robot->ReturnSaturationControl(Tau);
        
        isCorrect = _Robot->SendData(SaturationControl);
         
        PrevPosition = _q; 
        CurrentCycle++;
    }else{
        IsFinalized = true;   
    }
    
}        
    
int MotionCommand::SCurve(float q0,float q1, float qd0,float qdf, float qdd,float stime,float Constraints_v,float Constraints_a, float Constraints_j){
        float _q,_qd,_qdd,_q0,_q1,v0,v1,dq,dv,time_set_velocity,time_reach_acc,Tj,sigma,sigm1,sigm2, vmax,vmin,amax,amin,jmax,jmin,Tj1,Tj2,Ta,Td,Tv,T,amax_squared,
                sqrt_delta,alima,alimd,vlim,q,qprim,acel;
        CurrentCycle = 0;
        bool isFeasable;
         if (Constraints_v<abs(qd0)){
                v0 = sign(qd0)*Constraints_v;
         }
            if (Constraints_v<abs(qdf)){
                v1 = sign(qdf)*Constraints_v;
         }
         
         //Check if its feasable
         dq=abs(q1 - q0);
         dv=abs(v1-v0);
         
         time_set_velocity=sqrtf((dv)/Constraints_j);
         time_reach_acc=Constraints_a/Constraints_j;
            Tj = min(time_set_velocity,time_reach_acc);
            if (Tj < time_reach_acc){
                if (dq<Tj*(v0+v1)){
                    isFeasable = false;
                }
                else{
                     isFeasable = true;
                }
            }
            else if (Tj == time_reach_acc){
                 if (dq < (0.5F *(v0+v1)*(Tj+dv/Constraints_a))){
                    isFeasable = false;
                 }
                 else{
                     isFeasable=true;
                 }
            }
            else{
             isFeasable=false;
            }         
    
    if (isFeasable == false){
        printf("Is not feasable this configuration \n");
        return 0;
    }
    //Sign change
        sigma = sign(q1-q0);
        _q0 = sigma*q0;
        _q1 = sigma*q1;
        v0 = sigma*v0;
        v1 = sigma*v1;
        sigm1 = (sigma+1.0F)/2.0F;
        sigm2 = (sigma-1.0F)/2.0F;
        vmax = Constraints_v*sigm1 - Constraints_v*sigm2;
        amax = Constraints_a*sigm1 - Constraints_a*sigm2;
        jmax = Constraints_j*sigm1 - Constraints_j*sigm2;
        
        vmin = -vmax;
        amin = -amax;
        jmin = -jmax;
        
      if ((vmax- v0)* jmax < amax* amax){
             Tj1 = sqrtf((vmax - v0)/ jmax);
             Ta = 2.0F * Tj1; 
      }
      else{ 
             Tj1 = amax/jmax;
             Ta =  Tj1 + (vmax - v0)/amax;
      }
      if ((vmax - v1)* jmax < amax * amax){
            Tj2 = sqrtf((vmax - v1)/ jmax);
            Td = 2.0F* Tj2;       
      }
      else{ 
             Tj2 =  amax / jmax;
             Td = Tj2 + (vmax - v1)/ amax;
      }
         Tv = (_q1 - _q0)/vmax -  Ta*(1.0F + v0 / vmax)/2.0F -  Td *(1.0F + v1 / vmax)/2.0F;
    
     if (Tv<0){
         float it = 0;
         float l = 0.99F;
         float max_iter = 200;
         while ((it < max_iter) && (amax >= 0.01F)){
                //Vmax not reach
                Tj1 = amax / jmax;
                Tj2 = Tj1;
                Tj = Tj2;
                amax_squared = amax * amax;
                sqrt_delta = sqrtf( ((amax_squared*amax_squared)/(jmax * jmax)) + 2.0F*(v0 * v0+  v1 * v1)
                    + amax * (4.0F*(_q1 - _q0) - 2.0F* amax *(v0 + v1)/jmax));
                Ta = (amax_squared/jmax - 2.0F * v0 + sqrt_delta)/(2.0F * amax);
                Td = (amax_squared/jmax - 2.0F * v1 + sqrt_delta)/(2.0F * amax);
                Tv = 0;
                if (Ta < 0.0F){
                    Td = 2.0F*((_q1 - _q0) / (v1 + v0));
                    Tj2 = (jmax *(_q1 - _q0)-sqrtf(jmax *(jmax*(powf((_q1-_q0),2.0F))+(powf((v1+v0),2.0F))*
                    (v1-v0))))/(jmax*(v1+v0));
                    Ta = 0;
                    Tj1 = 0;
                }
                if(Td < 0.0F){
                    Ta = 2.0F*((_q1-_q0)/(v1+v0));
                    Tj1 = (jmax*(_q1-_q0 )-sqrtf(jmax *(jmax *(powf((_q1 -_q0 ),2.0F))-(powf((v1 +v0 ),2.0F))*
                    (v1 -v0 ))))/(jmax *(v1 +v0 ));
                    Td  = 0;
                    Tj2  = 0;
                }
            
                if ((Ta  < 2.0F*Tj1 ) || (Td  < 2.0F*Tj2 )){
                    amax  =amax * l;
                }
                else{
                    break;
                }
        }
     }
     alima  = jmax *Tj1 ;
     alimd  = -jmax  * Tj2 ;
     vmax  = v0  + (Ta  - Tj1 )*alima ;
     vlim  = vmax ;
     T  = Ta +Tv +Td ;
        
     qprim = 0;
     float t=0;
     TotalCycle = (int)T/stime+1;
     for(int tim=0; tim<((int)(T/stime)+1);tim++){
        t = tim*stime;
        if (t<Tj1 ){
            _q  = sigma *(_q0 +v0 *t+jmax *powf(t,0.5F));
            _qd = sigma*(v0+jmax*powf(t,2.0F)/2);
            _qdd = sigma*(jmax*t); 
        }
        else if (t<(Ta -Tj1 )){
            _q  = sigma *(_q0 +v0 *t+(3.0F*powf(t,2.0F)-3.0F*Tj1 *t+powf(Tj1 ,2.0F))*(alima /6.0F));
            _qd = sigma*(v0+alima*(t-(Tj1/2.0F)));
            _qdd = sigma*alima;
        }
        else if (t<Ta ){
            _q  = sigma *(_q0 +(vlim +v0 )*(Ta /2.0F)-vlim *(Ta -t)-jmin *powf((Ta -t),0.5F));
            _qd = sigma*(vlim+jmin*(powf((Ta-t),2.0F)/2.0F));
            _qdd = sigma*(-jmin*(Ta-t));
        }
        else if (t<(Ta +Tv )){
            _q  = sigma *(_q0 +(vlim +v0 )*(Ta /2.0F)+vlim *(t-Ta ));
            _qd = sigma*vlim;
            _qdd = 0;
        }
        else if (t<(T -Td +Tj2 )){
            _q  = sigma *(_q1 -(vlim +v1 )*(Td /2.0F)+vlim *(t-T +Td )-jmax *(powf((t-T +Td ),0.5F)));
            _qd = sigma*(vlim-jmax*(powf((t-T+Td),2.0F)/2.0F));
            _qdd = sigma*(-jmax*(t-T+Td));
        }
        else if (t<(T -Tj2 )){
            _q  = sigma *(_q1 -(vlim +v1 )*(Td /2.0F)+vlim *(t-T +Td )+(alimd /6.0F)*(3.0F*powf((t-T +Td ),2.0F)-3.0F*Tj2 *(t-T +Td )+powf(Tj2 ,2.0F)));
            _qd = sigma*(vlim+alimd*(t-T+Td-(Tj2/2.0F)));
            _qdd = sigma*alimd;
        }
        else if (t<=T ){
            _q  = sigma *(_q1 -v1 *(T -t)-jmax *(powf((T -t),3.0F))/6.0F);
            _qd = sigma*(v1+jmax*(powf((T-t),2.0F))/2.0F);
            _qdd = sigma*(-jmax*(T-t));
        }
        else{
            _q  = sigma *_q0 ;
            _qd = sigma*v1;
            _qdd = 0;
        }
        _Trajectory[index].Insert(_q,_qd,_qdd);
    }
    index++;
    return 1;
}

void MotionCommand::Spline_5th (float q0,float q1, float qd0, float qd1, float qdd,float stime,float tfin,float Constraints_v ,float Constraints_a){
    float a, b, c, d, e, f,_q,_qd,_qdd;

    if(qd0>Constraints_v){
        qd0 = Constraints_v;
    }
    if(qdd>Constraints_a){
        qdd = Constraints_a;
    }
    //Calc the parameters
    f  = (6.0F*q1)/powf(tfin,5.0F) - (6.0F*q0)/powf(tfin,5.0F) - (3.0F*qd0)/powf(tfin,4.0F) 
    - (3.0F*qd1)/powf(tfin,4.0F) - qdd/(2*powf(tfin,3.0F));
    e  = (15.0F*q0)/powf(tfin,4.0F) - (15.0F*q1)/powf(tfin,4.0F)+ (8.0F*qd0)/powf(tfin,3.0F) 
    + (7.0F*qd1)/powf(tfin,3.0F) + (3.0F*qdd)/(2.0F*powf(tfin,2.0F));
    d  = (10.F*q1)/powf(tfin,3.0F) - (10.0F*q0)/powf(tfin,3.0F) - (6.0F*qd0)/powf(tfin,2.0F) 
    - (4.0F*qd1)/powf(tfin,2.0F) - (3.0F*qdd)/(2.0F*tfin);
    c  = qdd/2.0F; 
    b  = qd0;
    a  = q0 ;
    
    TotalCycle = (int) tfin/stime;

    //Sampling in units of st (sampling time)
    for(int t=0;t<(int)((tfin/stime)+1);t++){
        _q  = a  + b *((float)t)*stime + c *powf(((float)t)*stime,2.0F) +
                        d *powf(((float)t)*stime,3.0F) + e *powf(((float)t)*stime,4.0F) + f *powf(((float)t)*stime,5.0F);
        _qd  = b  + 2.0F*c *((float)t)*stime + 3.0F*d *powf(((float)t)*stime,2.0F) +
                        4.0F*e *powf(((float)t)*stime,3.0F) + 5.0F*f *powf(((float)t)*stime,4.0F);
        _qdd  = 2.0F*c  + 6.0F*d *((float)t)*stime + 12.0F*e *powf(((float)t)*stime,2.0F) +
                        20*f *powf(((float)t)*stime,3.0F);
        _Trajectory[index].Insert(_q,_qd,_qdd);
    }
    index++;
}


void MotionCommand::Spline_7th(float q0,float q1, float qd0, float qd1, float qdd,float stime,float tfin,float Constraints_v ,float Constraints_a){
   float a, b, c, d, e, f, g, h,_q,_qd,_qdd;
   if(qd0>Constraints_v){
        qd0 = Constraints_v;
    }
    if(qdd>Constraints_a){
        qdd = Constraints_a;
    }

    //Calc the parameters  
    h = (35.0F*q1)/powf(tfin,4.0F)- (35.0F*q0)/powf(tfin,4.0F) - (20.0F*qd0)/powf(tfin,3.0F) - (15.0F*qd1)/powf(tfin,3.0F) - (5.0F*qdd)/powf(tfin,2.0F);
    g = (84.0F*q0)/powf(tfin,5.0F) - (84.0F*q1)/powf(tfin,5.0F) + (45.0F*qd0)/powf(tfin,4.0F) + (39.0F*qd1)/powf(tfin,4.0F) + (10.0F*qdd)/powf(tfin,3.0F);
    f = (70.0F*q1)/powf(tfin,6.0F) - (70.0F*q0)/powf(tfin,6.0F) - (36.0F*qd0)/powf(tfin,5.0F) - (34.0F*qd1)/powf(tfin,5.0F) - (15.0F*qdd)/(2.0F*powf(tfin,4.0F));
    e = (35.0F*q1)/powf(tfin,4.0F) - (35.0F*q0)/powf(tfin,4.0F) - (20.0F*qd0)/powf(tfin,3.0F) - (15.0F*qd1)/powf(tfin,3.0F) - (5.0F*qdd)/powf(tfin,2.0F);
    d = 0.0F;
    c = Constraints_a/2.0F;
    b = Constraints_v;
    a = q0;
    TotalCycle = (int) tfin/stime;
    //Sampling in units of st (sampling time)
    for(int t=0;t<(int) tfin/stime;t++){
            _q = a + b*((float)t)*stime + c*powf(((float)t)*stime,2.0F) + d*powf(((float)t)*stime,3.0F) +
                                                e*powf(((float)t)*stime,4.0F) + f*powf(((float)t)*stime,5.0F) + g*powf(((float)t)*stime,6.0F)
                                                + h*powf(((float)t)*stime,7.0F);
            _qd = b + 2.0F*c*((float)t)*stime + 3.0F*d*powf(((float)t)*stime,2.0F) +
                                                   4.0F*e*powf(((float)t)*stime,3.0F) + 5.0F*f*powf(((float)t)*stime,4.0F) +
                                                   6.0F*g*powf(((float)t)*stime,5.0F) + 7.0F*h*powf(((float)t)*stime,6.0F);
            _qdd = 2.0F*c + 6.0F*d*((float)t)*stime + 12.0F*e*powf(((float)t)*stime,2.0F) +
                                                    20.0F*f*powf(((float)t)*stime,3.0F) + 30.0F*g*powf(((float)t)*stime,4.0F) +
                                                    42.0F*h*powf(((float)t)*stime,5.0F);
            _Trajectory[index].Insert(_q,_qd,_qdd);
    }
    index++;

}

