#include "Driver.h"

Driver::Driver(PinName adrress){
     communication = D_DAC;
     dac = new AnalogOut(adrress);
}

Driver::Driver(PinName RX,PinName TX){
     communication = D_CAN;
     can = new CAN(RX,TX);

}

Driver::Driver(PinName MOSI,PinName MISO,PinName sclk, int frecuency){
     communication = D_SPI;
     spi = new SPI(MOSI, MISO, sclk);
     spi->format(8,3);
     spi->frequency(frecuency);
}

int Driver::sendmessage(char data[8]){
    int isCorrect;
    char received[8];
    switch(communication){
       case D_CAN:
           isCorrect=can->write(CANMessage(1337, data, 8));
           break;
       case D_SPI:
           isCorrect = spi->write(data,8,received,8);
           break;
       default:
           return 0;
    }
    if(isCorrect){
        return 1;
    }else{
        return 0;
    }
}

int Driver::sendmessage(float data){
    if (communication==D_DAC){
        dac->write(data);
        return 1;
    }
    return 0;
}          
Driver::~Driver(){
    delete can, dac, spi;
    }