
#include "Control.h"

Control::Control(float _KP, float _KV, float _KI,float _KA,float _KM ,float _SamplingTime, float _Scale, float _Offset,float _MaxTorque){
    KP = _KP;
    KV = _KV;
    KI = _KI;
    KA = _KA;
    KM = _KM;
    Scale = _Scale;
    Offset = _Offset;
    MaxTorque = _MaxTorque;
    SamplingTime = _SamplingTime;
    PrevErr = 0;
}   
float Control::GetKP(){
    return KP;    
}
float Control::GetKV(){
    return KV;    
}
float Control::GetKI(){
    return KI;    
}
float Control::SaturationControl(float value){
    float u = (value*KA*KM)/MaxTorque;
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;   
}  
float Control::ComputeP(float qref, float qi){
    float u=(((qref - qi) * KP)*KA*KM)/MaxTorque;
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;   
}     
float Control::ComputePD_FirstVersion(float qref, float qi, float qdotref, float qdoti){
    float u=(((qref - qi) * KP + (qdotref - qdoti) * KV)*KA*KM)/MaxTorque;
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;
}
float Control::ComputePD_SecondVersion(float qref, float qi, float qdoti){
    float u=(((qref - qi) * KP  - qdoti * KV)*KA*KM)/MaxTorque;
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;
}
float Control::ComputePID(float qref, float qi, float qdotref, float qdoti){
    
    float IntegralErr = PrevErr + (qref - qi);
    PrevErr = IntegralErr;

    float u=(((qref-qi) * KP + (qdotref - qdoti) * KV + IntegralErr * KI)*KA*KM)/MaxTorque;
    
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;
}
float Control::ComputePDG(float qref, float qi, float qdotref, float qdoti, float Tau){
    float u = (((qref-qi) * KP + (qdotref - qdoti) * KV)*KA*KM + Tau)/MaxTorque;
    if (u>1){
        u=1;
    }
    if (u<0){
        u=0;
    }
    u = u* Scale + Offset;
    return u;
}