#ifndef CONTROL_H
#define CONTROL_H    
    #include "mbed.h"
    using namespace std;
    class Control{
        private:
            float KP;
            float KV;
            float KI;
            float KA;
            float KM;
            float Scale;
            float Offset;
            float MaxTorque;
            float SamplingTime;
            float PrevErr;
        public:
            Control(float _KP, float _KV, float _KI,float _KA,float _KM ,float _SamplingTime, float _Scale, float _Offset,float _MaxTorque);
            float GetKP();
            float GetKV();
            float GetKI();
            float SaturationControl(float value);
            float ComputeP(float qref, float qi);
            float ComputePD_FirstVersion(float qref, float qi, float qdotref, float qdoti);
            float ComputePD_SecondVersion(float qref, float qi, float qdoti);
            float ComputePID(float qref, float qi, float qdotref, float qdoti);
            float ComputePDG(float qref, float qi, float qdotref, float qdoti, float Tau);
    }; 
#endif //CONTROL_H