//
// Created by m007 on 26/06/2020.
//

#ifndef UNTITLED_ROBOT_H
#define UNTITLED_ROBOT_H
#include "mbed.h"

#include "Vector.h"
#include "Matrix.h"

#include "Link.h"
#include "Motor.h"

#include "Trajectory.h"
#include "End_Effector.h"
#include <cmath>

class Robot {

public:
    Robot(float _ToolMatrix[][4],float _BaseMatrix[][4],const float DH_Table[], const float lenght[],float dyn_mat [][10],const float MotorParam[],const float ControlGain[],int RobotDOF,const Link::Links_Type link [], const float MotorConstraints[],PinName PinSensorA[], PinName PinSensorB[],const float SensorProperties[], PinName PinDriver[]);
    Robot(Matrix<float>& _ToolMatrix,Matrix<float>& _BaseMatrix,const float DH_Table[], const float lenght[],float dyn_mat [][10],const float MotorParam[],const float ControlGain[],int RobotDOF,const Link::Links_Type link [], const float MotorConstraints[],PinName PinSensorA[], PinName PinSensorB[],const float SensorProperties[], PinName PinDriver[]);
    ~Robot();

    Vector<float> GetTorque();
    int GetDOF();
    
    float ReadSensor(int num);
    float ReadVelocity(float prevValue,float sampling,int num);
    
    Vector<float> ReturnSaturationControl(Vector<float> value);
    Vector<float> ReturnComputeP(Vector<float> qref, Vector<float> qi);
    Vector<float> ReturnComputePD_FirstVersion(Vector<float> qref, Vector<float> qi, Vector<float> qdotref, Vector<float> qdoti);
    Vector<float> ReturnComputePD_SecondVersion(Vector<float> qref, Vector<float> qi, Vector<float> qdoti);
    Vector<float> ReturnComputePID(Vector<float> qref, Vector<float> qi, Vector<float> qdotref, Vector<float> qdoti);
    Vector<float> ReturnComputePDG(Vector<float> qref, Vector<float> qi, Vector<float> qdotref, Vector<float> qdoti, Vector<float> Tau);
    
    int SendData(Vector<float> data);
    
    Matrix <float> GetRotation(int num);
    Matrix <float> GetRotation(Matrix<float> mat);
    Vector <float> GetPosition(Matrix<float> vect);
    
    Link GetLink(int num);
    
    float ConstraintsVelocityMotor(int num);
    float ConstraintsAccelerationMotor(int num);
    float ConstraintsJerkMotor(int num);
    
    Vector<float> GetKP();
    Vector<float> GetKV();
    Vector<float> GetKI();
    Vector<float> GetEndPosition();
    Matrix<float> GetJacobian();


    void ForwardKinematics(const float thetaOffset[]);
    Vector<float> InverseKinematics(End_Effector* EFF_q0, int conf);
    void Jacobian(float q[]);
    void EulerNewton(const float q[],const float qd[],const float qdd[]);
    void GravityTorque(float q[]);


private:
    Matrix <float> ToolMatrix;
    Matrix <float> BaseMatrix;
    Matrix <float> _Jacobian;

    Link *_Linker;
    Motor *_Motor;
    
    int _RobotDOF;
};


#endif //UNTITLED_ROBOT_H
