#include "mbed.h"



DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


//motor a
PwmOut motFront(p5);
DigitalOut frontIN1(p21); 
DigitalOut frontIN2(p22);

//motor b
PwmOut motLeft(p6);
DigitalOut leftIN2(p23);
DigitalOut leftIN1(p24);

//motor c
PwmOut motRight(p34);
DigitalOut rightIN1(p25);
DigitalOut rightIN2(p26);

//motor standby
DigitalOut motRLstby(p36);
DigitalOut motFstby(p35);


//xBee

 
Serial xbee(p9, p10); //tx, rx
DigitalOut rstXbee(p8);

Serial pc(USBTX, USBRX); // tx, rx

int main() {
    rstXbee = 0;
    wait_ms(1); 
    rstXbee=1;
    wait_ms(1);
   
    
    myled1 = 1;
    wait(0.1);
    myled2 = 1;
    myled1 = 0;
    wait(0.1);
    myled2=0;
    
    motRLstby=1;
    motFstby=1;
    
    
    motFront = motLeft = motRight=0;
    frontIN1 = 0;
    frontIN2 = 0;
    leftIN1 = 0;
    leftIN2 = 0;
    rightIN1 = 0;
    rightIN2 = 0;
    
    /* //some command stuff
    xbee.printf("+++"); //enter command mode
    xbee.printf("ATCH11"); //change channel
    //xbee.printf("ATSH000F0000");
    xbee.printf("ATDH000F0000");
    //xbee.printf("ATSL0000F000");
    xbee.printf("ATDL0000F000");
    xbee.printf("ATWR"); //write the changes to non-volitle memory
    xbee.printf("ATCN"); //exit command mode
    */
    char xRead = 'a';
    float xDiv = 0.00;

    while(1) {
        //pc.printf("READY!!... ");
        if(xbee.readable()){
            // pc.printf("READABLE... ");
            xRead = xbee.getc();
            //pc.printf("  %d", xRead);  
            xDiv=(float)xRead;
            pc.printf("  %f", xDiv); 
        }
        
    //testing the values read in
    /*
    if(xDiv>=1.0 && xDiv<64.0)
    {
        pc.printf("forward march");
    }
    else if(xDiv>64.0 && xDiv<128.0)
    {
        pc.printf("back it up");
    }
    else if(xDiv>128.0 && xDiv < 191.0)
    {
        pc.printf("to the left");
    }
    else if(xDiv>191.0 && xDiv <=255)
    {
        pc.printf("right we go");
    }
    else
    {
        pc.printf("do nothing");
    } */  
                
                //forward
                if(xDiv>=1.0 && xDiv<=64.0){
                    //myled3=1;
                    // pc.printf("%d... ", xRead); 
                    //pc.printf("forward... ");
                    motLeft = motRight=(xDiv/63.0);
                    motRLstby=1;
                    leftIN1=0;
                    leftIN2=1;
                    rightIN1=1;
                    rightIN2=0;
                }
               /* else{
                     myled3=0;
                }*/
                
                //back
                else if(xDiv>64.0 && xDiv <=128.0){
                 //   myled4=1;
                    //pc.printf("%d... ", xRead);
                     pc.printf("back... ");
                    motLeft = motRight=((xDiv-64.0)/63.0);
                    motRLstby=1;
                    leftIN1=1;
                    leftIN2=0;
                    rightIN1=0;
                    rightIN2=1;
                }
              /*  else{
                     myled4=0;
                }*/
                
                //left rotate
                else if(xDiv>128.0 && xDiv <= 191.0){
                   //  myled1=1;
                      //pc.printf("%d... ", xRead);
                       pc.printf("left... ");
                      motFstby=1;
                      motRLstby=1;
                      motFront=((xDiv-128.0)/63.0);
                      motRight=motLeft=((xDiv-128.0)/63.0);
                      frontIN1=1;
                      frontIN2=0;
                      rightIN1=1;
                      rightIN2=0;
                      leftIN1=1;
                      leftIN2=0;
                }
              /*  else{
                     myled1=0;
                }*/
                
                //right rotate
                else if(xDiv>191.0 && xDiv <=255){
                 //   myled2=1;
                   // pc.printf("%d... ", xRead);
                   pc.printf("right... ");
                     motFstby=1;
                      motRLstby=1;
                      motFront=((xDiv-192.0)/63.0);
                      motRight=motLeft=((xDiv-192.0)/63.0);
                      frontIN1=0;
                      frontIN2=1;
                      rightIN1=0;
                      rightIN2=1;
                      leftIN1=0;
                      leftIN2=1;
                }
               /* else{
                    myled2=0;
                }*/
                
                
                //standby
                else{
                     pc.printf("STOP... "); 
                    //myled1=myled2=myled3=myled4=0;
                    motLeft=motRight=motFront=0.0;
                    motFstby=motRLstby=0;
                    //pc.printf("%d... ", xRead); 
                  }
                    
                
                
       
        
        pc.printf("\r\n");
    
 /*       mot = mot + 0.01;
        wait(0.2);
        if(mot == 2.0) {
            mot = 0;
        }*/
    }
}

/* Robot Functionality Notes

Modules to Processs movement

We will take in a digital input from the xBee module and act upon it by
    varying the PWM signals of the motors
    
Our motor will be omni-directional, so we will take in the analog input in
    terms of a 360degree spectrum, and based upon the values transmitted from the controller,
    the motors will be programmed to mve themselves on the two-dimentional plane to appear
    omni-directional
*/
