/*
 * Project:     Seeed Arch GPRS V2 Send SMS Hello World
 * Author:      Joseph Radford
 * Date:        25/10/2015
 * Target:      Arch GPRS V2
 * Peripherals: SIM Card
 */

#include "mbed.h"
 
 // declare pins for comms with the SIM900
#define TX_GSM P1_27
#define RX_GSM P1_26

// PINPWR to low on Q10 drives 3V3 to Q7, which drives Q5 to ground, which powers VBAT_900, with either VCC_BUCK or VCC_BAT
#define PINPWR                  P1_2

// PINONOFF controls PWRKEY on the SIM900, see manual for more info
#define PINONOFF                P1_7

// declare LEDs
DigitalOut myled1(LED2); //left most LED if board is held as shown in Pinout diagram above
DigitalOut myled2(LED3); //2nd from left
DigitalOut myled3(LED4); //3rd from left
DigitalOut myled4(LED1); //4th from left (right most)

// create pins for controlling power to SIM900
DigitalOut m_sim900_pwr(PINPWR);      
DigitalOut m_sim900_on (PINONOFF);

// create object for UART comms to SIM900
Serial m_sim900_serial (TX_GSM, RX_GSM);      


// flash each LED one at a time, and then leave all off
void flashSequence()
{
    myled1 = 1;    myled2 = 0;    myled3 = 0;    myled4 = 0;
    wait(0.5);
    myled1 = 0;    myled2 = 1;
    wait(0.5);
                   myled2 = 0;    myled3 = 1;
    wait(0.5);
                                  myled3 = 0;    myled4 = 1;
    wait(0.5);
                                                 myled4 = 0;
}

int main()
{
    /* start up sequence, so we know we reached main */
    flashSequence();
    
    // set up baud rate. Borrowed from http://tronixstuff.com/2014/01/08/tutorial-arduino-and-sim900-gsm-modules/
    m_sim900_serial.baud(19200);
    
    
    /* POWER ON SIM900 */
    
    // power on sequence borrowed from http://gronlier.fr/blog/2014/11/seeeduino-arch-gprs-v2/
    // order of events specified by the SIM900 manual
    m_sim900_pwr.write(1);     // turn power supply off
    m_sim900_on.write(1);
    wait(0.5);                 // wait to settle
    
    m_sim900_pwr.write(0);     // turn power supply on
    m_sim900_on.write(0);      // from the ref: "drive the PWRKEY to a low level for 1 second then release."
    wait(1);                   // wait for one second
    
    m_sim900_on.write(1);      // release power key
    wait(20 /*0.5*/);          // wait to settle
    
    
    
    /* SEND A MESSAGE */
        
    // the following sequence and messages are borrowed from http://tronixstuff.com/2014/01/08/tutorial-arduino-and-sim900-gsm-modules/
    // Set SMS mode 
    m_sim900_serial.printf("AT+CMGF=1\r\n");                           // AT command to send SMS message
    myled1 = 1;
    wait(0.1);
    
    // Send phone number
    m_sim900_serial.printf("AT + CMGS = \"+61123456789\"\r\n");        // recipient's mobile number, in international format
    myled2 = 1;
    wait(0.1);
        
    // Send text   
    m_sim900_serial.printf("Hello, world. This is a text message from an Arch GPRS V2.\r\n");        // message to send
    myled3 = 1;
    wait(0.1);    
    
    // End message  
    m_sim900_serial.putc((char)26);                       // End AT command with a ^Z, ASCII code 26
    m_sim900_serial.printf("\r\n");          
    myled4 = 1;
    wait(0.1);
    
    // do nothing for a bit     
    wait(5);
        
    // flash to signifty we are done
    flashSequence();
    
    // hang forever
    while(1);    
}


