#include "mbed.h"
#include "SDFileSystem.h"

//Reads input through the ADC, compares previous sample for change of 0.001V
//Continues sampling for 5 seconds
//Write 1 seconds pre change from circular buffer with 5 seconds post change to Micro SD card
//ADC uses 3.3V reference VOUT (PIN 40) of mbed

AnalogIn Ain(p20);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed to SD card reader

DigitalOut LED_1(LED1);
DigitalOut LED_2(LED2);
DigitalOut LED_3(LED3);
DigitalOut LED_4(LED4);
unsigned short int ADCdata;
unsigned short int Volts;
int i;
int j;
int k;
unsigned short int difference;
bool DifferenceDetected;
unsigned short int ArrayLoc;
unsigned short int buffer [1000]; //Array to store 500 samples for circular buffer
unsigned short int time_buffer[1000];
unsigned short int OnesecMem [1000]; //Array to store 1 sec of samples prior to change detected
unsigned short int time_OnesecMem[1000];
unsigned short int FivesecMem [5000]; //Array to store 10 sec of samples post change detection
unsigned short int time_FivesecMem[5000];
int shift;
int seconds;
Timer t;

int main()
{

    t.start(); //Start timer

    buffer[999] = 0;
    DifferenceDetected = false;

    LED_1 = 1;
    LED_2 = 1;
    LED_3 = 1;
    LED_4 = 1;

    for(int i = 0; i <= 1000; i++ ) {

// --------------------------------------------------------------------------------
//Rewrite over buffer array elements if no detected change (Restart circular buffer)

        if ((i == 1000) && (DifferenceDetected == false)) {

            i = 0;

        }

// --------------------------------------------------------------------------------
//Sample input data

        ADCdata = Ain*10000;

// --------------------------------------------------------------------------------
//Storing voltage values into buffer of 1000 samples (1 second when sampled at 1kHz)

        buffer[i] = ADCdata; //Input Voltage value to "i" sample position in buffer
        time_buffer[i] = t.read_ms();

        if((i==0) && ( buffer[999] == 0) ) { // First time programme run j is same as i

            j = buffer[0];

        } else if ((i==0) && ( buffer[999] != 0)) { //When looped circular buffer again j is last term of previous loop (Previous term)

            j = buffer[999];

        } else {

            j = buffer[i-1]; //Majority of time j is previous term in circular buffer array

        }


        difference = (abs(ADCdata - j));


// --------------------------------------------------------------------------------
//Determine if change in sampled input detected

        if(difference > 12) {

            DifferenceDetected = true;
            ArrayLoc = i;
            LED_1 = 1;
            LED_2 = 0;
            LED_3 = 0;
            LED_4 = 1;
            wait (0.00097383);

            break;
        }

// --------------------------------------------------------------------------------

        if(DifferenceDetected == false) {

            wait (0.000974); //samples at 1kHz

        }

    } //Close Circular Buffer 'for loop'

// --------------------------------------------------------------------------------
//*********************************************************************************
// --------------------------------------------------------------------------------

//Write 5 seconds of data post change to new array

    for(int k = 0; k < 5000; k++ ) {

        ADCdata = Ain*10000;
        Volts = (ADCdata*3.3);

        time_FivesecMem[k] = t.read_ms();

        FivesecMem [k] = Volts;

        wait (0.0009727); //samples at 1kHz

    }

    LED_1 = 0;
    LED_2 = 1;
    LED_3 = 1;
    LED_4 = 0;

// --------------------------------------------------------------------------------
//Re-Organise circular buffer so when break triggered i = 1000 element

    for(int p = 0; p < 1000; p++ ) {

        shift = (ArrayLoc + p + 1 );

        if(shift < 1000) {

            OnesecMem [p] = buffer[shift]; //OnesecMem array populated starting from where buffer array was last filled (Array position after break will be oldest sample 1 second previous / 1st element in OnesecMem array
            time_OnesecMem [p] = (time_buffer[shift]);

        } else if (shift >= 1000) {

            OnesecMem[p] = buffer[(shift - 1000)];
            time_OnesecMem[p] = time_buffer[(shift-1000)];

        }
    }

// --------------------------------------------------------------------------------
//Convert ADCdata elements in circular buffer into Voltage values for printitng to card

    for(int q = 0; q < 1000; q++ ) {

        OnesecMem[q] = (OnesecMem[q]*3.3);

    }

// --------------------------------------------------------------------------------
//*********************************************************************************
// --------------------------------------------------------------------------------

//Write Voltage output to SD card

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/Sampled_Voltage.csv", "w");

    if(fp == NULL) {
        error("Could not open file for write\n");
    }

// --------------------------------------------------------------------------------
//Write circular buffer to card

    for(int r = 0; r < 1000; r++ ) {

        fprintf(fp, "%d", (OnesecMem[r]/10000));  //Write out 1 sec held in buffer pre change               "\r\n" Takes new line
        fprintf(fp, "." );

        if((OnesecMem[r]%10000) < 10) {

            fprintf(fp,"000");
            fprintf(fp, "%d",(OnesecMem[r]%10000));

        } else if(((OnesecMem[r]%10000) >= 10) && ((OnesecMem[r]%10000) < 100)) {

            fprintf(fp,"00");
            fprintf(fp, "%d",(OnesecMem[r]%10000));

        } else if(((OnesecMem[r]%10000) >= 100) && ((OnesecMem[r]%10000) < 1000 )) {

            fprintf(fp,"0");
            fprintf(fp, "%d",(OnesecMem[r]%10000));


        } else {

            fprintf(fp, "%d",(OnesecMem[r]%10000));
        }

        fprintf(fp, ",%d\r\n", (time_OnesecMem[r] - time_OnesecMem[0] + 1));
    }

    fprintf(fp, " \r\n"); // Space gap indcicates change detected in csv file

// --------------------------------------------------------------------------------
//Write 4.5 seconds of data post change detected to card

    for(int s = 0; s < 5000; s++ ) {
        fprintf(fp, "%d", (FivesecMem[s]/10000));  //Write out 5 sec of data after change detected              "\r\n" Takes new line
        fprintf(fp, "." );

        if((FivesecMem[s]%10000) < 10) {

            fprintf(fp,"000");
            fprintf(fp, "%d",(FivesecMem[s]%10000));

        } else if(((FivesecMem[s]%10000) >= 10) && ((FivesecMem[s]%10000) < 100 )) {

            fprintf(fp,"00");
            fprintf(fp, "%d",(FivesecMem[s]%10000));

        }  else if(((FivesecMem[s]%10000) >= 100) && ((FivesecMem[s]%10000) < 1000 )) {

            fprintf(fp,"0");
            fprintf(fp, "%d",(FivesecMem[s]%10000));

        } else {

            fprintf(fp, "%d",(FivesecMem[s]%10000));
        }

        fprintf(fp, ",%d\r\n", (time_FivesecMem[s] + 1 - time_OnesecMem[0]));
    }

    fprintf(fp, " \r\n");

    fclose(fp);

    LED_1 = 1;
    LED_2 = 1;
    LED_3 = 1;
    LED_4 = 1;

    wait(0.3);

    LED_1 = 1;
    LED_2 = 0;
    LED_3 = 0;
    LED_4 = 1;

    wait(0.3);

    LED_1 = 0;
    LED_2 = 1;
    LED_3 = 1;
    LED_4 = 0;

    wait(0.3);

    LED_1 = 0;
    LED_2 = 0;
    LED_3 = 0;
    LED_4 = 0;

}//Finish main programme