#include "mbed.h"

/////////////////global variables/////////////////////////
//create frame buffer in peripheral SRAM bank 0 and bank 1
//unsigned char *framebuffer = (unsigned char *)(0x2007C000);

//volatile unsigned char *pointer = framebuffer;

//static unsigned line_counter;
/////////////////end global variables/////////////////////

//assert PLL0CFG and PLL0CON regs
void main_pll_feed() {
    __disable_irq();
    LPC_SC -> PLL0FEED = 0x000000aa;
    LPC_SC -> PLL0FEED = 0x00000055;
    __enable_irq();    
}

//set 100MHz chip pll
void init_main_pll() {
    // the MBED crystal oscillator is 12 MHz
    // main oscillator frequency 300 MHz: M = (300 x N) / (2 x 12)
    int n = 2;
    int m = 25;
    // processor clock 100 MHz = 300 MHz / D
    int d = 3;
    // disconnect
    LPC_SC -> PLL0CON = 0x00000001; main_pll_feed();
    // disable
    LPC_SC -> PLL0CON = 0x00000000; main_pll_feed();
    // set new PLL values
    LPC_SC -> PLL0CFG = ((n-1)<<16)|(m-1); main_pll_feed();
    // enable
    LPC_SC -> PLL0CON = 0x00000001; main_pll_feed();
    // set cpu clock divider
    LPC_SC -> CCLKCFG = (d-1);
    // wait for lock
    while (LPC_SC -> PLL0STAT&0x04000000==0);
    // connect
    LPC_SC -> PLL0CON = 0x00000003; main_pll_feed();
}


void init_hsync() {
    //LPC_SC -> PCONP = 0;
    //power on pwm
    LPC_SC -> PCONP |= (1<<6);
    //set pwm periph clock
    LPC_SC -> PCLKSEL0 |= (1<<12);
    //pin select (PWM1.2 on P2.1 -> DIP25)
    //LPC_PINCON -> PINMODE_OD2 |= (1<<1); 
    LPC_PINCON -> PINSEL4 |= (1<<2);
    //disable internal pull down and pull up resistors
    LPC_PINCON -> PINMODE4 |= (1<<3);
    //set prescale to make 25Mhz timer count (TC)
    LPC_PWM1 -> PR = 3;
    //set trig for PWM TC to reset after each line
    LPC_PWM1 -> MR0 = 800;
    //enable TC reset on MR0 match (end of line)
    LPC_PWM1 -> MCR = 1<<1;
    //set trig for HSYNC to go low after 656 pixels
    LPC_PWM1 -> MR2 = 656;
    //set trig for HSYNC to go high after 752 pixels
    LPC_PWM1 -> MR1 |= 752;
    //enable double edged control on MR2/MR1 trigs
    LPC_PWM1 -> PCR = 1<<2;
    //enable output
    LPC_PWM1 -> PCR |= 1<<10;
}

void hsync_enable() {
    //enable TC
    LPC_PWM1 -> TCR |= 1;
    //enable PWM
    LPC_PWM1 -> TCR |= 8;
}

void init_vysnc() {
    ///////////////////////////
    //power timer 3 (0/1 used by DMA)
    //LPC_SC -> PCONP |= (1<<23);
    //set timer periph clock - CCLK/4 = 25MHz by default
    //LPC_SC -> PCLKSEL1 |= (0<<12);
    //pin select (MAT3.1 on 0.11 -> DIP 27)
    //LPC_PINCON -> PINSEL0 |= (3<<22);
    //pin mode
    //LPC_PINCON -> PINMODE0 |= (1<<23);
    //set TC reset time
    //LPC_TIM3 -> MR0 = 359200;
    //set reset on MR0
    //LPC_TIM3 -> MCR |= (1<<1);
    //toggle at 331200
    //LPC_TIM3 -> MR1 = 331200;
    //set toggle on match
    //LPC_TIM3 -> EMR |= (1<<1);
    //enable toggle on match
    //LPC_TIM3 -> EMR |= (3<<6);
    //timer enable
    //LPC_TIM3 -> TCR |= 1;
    /////////////////////////////
    
}
DigitalOut vsync(p27);
//void init_i2s() {
DigitalOut pixel(p21);

int main() {
    init_main_pll();
    main_pll_feed();
    
    init_hsync();
    hsync_enable();
    
    init_vysnc();
    
    pixel = 1;
    //char s[] = "I2S CCLK/4 Verification Test";
    
    //turn on i2s periph
    //LPC_SC -> PCONP |= (1 << 27);
    //set PCLK_peripheral = CCLK/2 so that serial tx CCLK/4
    //LPC_SC -> PCLKSEL1 |= (2 << 22);
    //assign clock pin and probe
    
    //LPC_I2S -> I2STXRATE |= (4 | (1 << 8));
    
    
    //monaural format; master mode
    //LPC_I2S -> I2SDAO |= (0x8);
    
    //connect i2s channel 0 tx to dma
    //LPC_I2S -> I2SDMA1 |= (0x70002);
    
    //select p5 pin for i2s tx
    //LPC_PINCON -> PINSEL0 |= (1 << 18);
    //LPC_PINCON -> PINSEL0 |= (1 << 14); 

    
    //MODDMA_Config *config = new MODDMA_Config;
    //config
    // ->channelNum    ( MODDMA::Channel_0 )
    // ->srcMemAddr    ( (uint32_t) &s )
    // ->dstMemAddr    ( LPC_I2S -> I2STXFIFO )
    // ->transferSize  ( sizeof(s) )
    // ->transferType  ( MODDMA::m2p )
    // ->transferWidth ( 8 )
    // ->srcConn       ( 0 )
    // ->dstConn       ( MODDMA::I2S_Channel_0 )
    // ->dmaLLI        ( 0 )
    // ->attach_tc     ( &TC0_callback )
    //;
    
    //dma.Setup(config);
    //dma.Enable(config);
    while(1) {
        //if (LPC_TIM3 -> TC > 331200) {
        //    LPC_TIM3 -> MR1 = 329600;
        //} else {
        //    LPC_TIM3 -> MR1 = 331200;
        //}
        //printf("%x/n/r", LPC_PWM1 -> TC);
        vsync = 1;
        wait_us(13400);
        vsync = 0;
        wait_us(80);
        vsync = 1;
        wait_us(1300);
    }
}

