#include "mbed.h"
#include "TextLCD.h"
#include "WiflyInterface.h"

TextLCD lcd(p26, p25, p24, p23, p22, p21); // rs, e, d4-d7
Serial pc(USBTX, USBRX);

/* wifly object where:
*     - p28 and p27 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*/
WiflyInterface wifly(p28, p27, p10, p10,"ADHOC","",Adhoc);
float temp;
float humid;
int bound = 0;

int main() {

    lcd.cls();
    lcd.printf("Hello!\n");

    while(!bound){
        lcd.cls();
        lcd.printf("Initiating WiFly...");
        printf("wifly.init() returned:%d\n",wifly.init("169.254.1.2","255.255.0.0","10.0.0.1"));
        printf("wifly.connect returned:%d\n",wifly.connect());
        printf("IP Address is %s\n\r", wifly.getIPAddress());
        lcd.cls();
        lcd.printf("WiFly Initiated...");
    

        TCPSocketServer server;
        int n = 8042;
        if(server.bind(n) == 0){
            bound = 1;
            printf("Bind to port %d succeeded\n",n);
            lcd.cls();
            lcd.printf("Listening on port %d...",n);
            server.listen();
            TCPSocketConnection client;
            printf("\nWait for new connection...\n");
            printf("server.accept() returned:%d\n", server.accept(client));
            char buffer[256];
            int i = 0;
            int j = 0;
            int tempFound = 0;
            int humidFound = 0;
            while (true) {   
                int n = client.receive(buffer, sizeof(buffer));
                j += n;
                if (j > 15){
                    for(i=5;i<j;i++){
                        if(buffer[i] == '^'){
                             //is Temp
                            printf("Temp: %c%c%c%c%c\n",buffer[i-5],buffer[i-4],buffer[i-3],buffer[i-2],buffer[i-1]);
                            if(buffer[i-6] - '0' <= 9 && buffer[i-6] - '0' >= 0){
                                 temp = ((buffer[i-6] - '0') * 100) + ((buffer[i-5] - '0') * 10) + (buffer[i-4] - '0') + ((buffer[i-2] - '0') * .1) + ((buffer[i-1] - '0') * .01);
                            }else{
                                temp =  ((buffer[i-5] - '0') * 10) + (buffer[i-4] - '0') + ((buffer[i-2] - '0') * .1) + ((buffer[i-1] - '0') * .01);
                            }                         
                            printf("TEMP: %f\n\n",temp);
                            tempFound = 1;
                        }else if(buffer[i] == '$'){
                            printf("Humid: %c%c%c%c%c\n",buffer[i-5],buffer[i-4],buffer[i-3],buffer[i-2],buffer[i-1]);
                            if(buffer[i-6] - '0' <= 9 && buffer[i-6] - '0' >= 0){
                                humid = ((buffer[i-6] - '0') * 100) + ((buffer[i-5] - '0') * 10) + (buffer[i-4] - '0') + ((buffer[i-2] - '0') * .1) + ((buffer[i-1] - '0') * .01);
                            }else{
                                humid =  ((buffer[i-5] - '0') * 10) + (buffer[i-4] - '0') + ((buffer[i-2] - '0') * .1) + ((buffer[i-1] - '0') * .01);
                            }                     
                            printf("HUMID: %f\n\n",humid);
                            humidFound = 1;
                        }
                    if((humidFound && tempFound) || j > 250){
                        humidFound = 0;
                        tempFound = 0;
                        buffer[j] = 0;
                        j = 0;
                        lcd.cls();
                        lcd.printf("Temp:%.2f\nHumid:%.2f%%",temp,humid);
                    }
                   }
                }
            }
        }else{
           printf("Bind to port %d failed\n",n);
           lcd.cls();
           lcd.printf("Bind to port %d failed\n",n);
           bound = 0;
           server.close();
        }
    }
}
