/* mbed analog Accelerometer Library
 * Copyright (c) 2010 Justin Solarski
 * justinsolarski@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef ACCELOROMETER_H
#define ACCELOROMETER_H
/** Class Accelorometer
 * Used for the analog accelorometer form sparkfun
 * model - MMA736 analog Accelorometer with 1.5g and 6g selections
 * also included is free fall detection and low power modes
 */
#include "mbed.h"
struct xyz {
    float x;
    float y;
    float z;
};
class Accel  {
public:
    /** create a accelerometer Object
     *
     * @param xpin analogin pin to connect to for x axis
     * @param ypin analogin pin to connect to for y axis
     * @param zpin analogin pin to connect to for z axis
     * @param g_select GPIO pin to connect to
     * @param sleep GPIO pin to connect to
     * @param selftest GPIO pin to connect to
     * @param zero_g detect GPIO pin to connect to detect zero g or free
     *        fall conditions
     */
    Accel(PinName xpin, PinName ypin, PinName zpin, PinName g_select,
          PinName zero_g, PinName selftest, PinName sleep);


    /** read analog value from pin x axis
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    float readx();
    /** read analog value from pin y axis
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    float ready();
    /** read analog value from pin z axis
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    float readz();
    /** read analog value from all pins xy&z
     *
     * @param Percent voltage/ref voltage- full range (0.0 - 1.0)
     */
    xyz readall();
    /** turns device off / low power mode
     *
     */
    void sleep();
    /** turns device on  5ms startup
     *
     */
    void wakeup();
    /** detects zero g or free fall conditions
     *
     */
    int fall_detect();
    /** selects sensitivity
     *  6g or 1.5g selection
     *  0 = 1.5g selection
     *  1 = 6g selection
     */
    int select_g(int g_sel);
    /** uses built in self test returns if OK
     * not implemented just returns 0
     */
    int selftest();


private :
    AnalogIn _zpin;
    AnalogIn _ypin;
    AnalogIn _xpin;
    DigitalOut _g_select;
    DigitalIn _zero_g;
    DigitalOut _selftest;
    DigitalOut _sleep;
}; //end of class accel

#endif