/* mbed analog Accelerometer Library
 * Copyright (c) 2010 Justin Solarski
 * justinsolarski@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "accelorometer.h"

xyz data;

Accel::Accel(PinName xpin, PinName ypin, PinName zpin, PinName g_select,
             PinName zero_g, PinName selftest, PinName sleep) : _zpin(zpin) , _ypin(ypin),
        _xpin(xpin), _g_select(g_select), _selftest(selftest), _sleep(sleep), _zero_g(zero_g) {
    _sleep.write(1);
    _zero_g.mode(PullDown);
    _g_select.write(0);

}

xyz Accel::readall() {
    xyz data;
    data.x = _xpin;
    data.y = _ypin;
    data.z = _zpin;
    return data;
}

float Accel::readx() {
    xyz data;
    data.x = _xpin;
    return data.x;
}
float Accel::ready() {
    xyz data;
    data.y = _ypin;
    return data.y;
}
float Accel::readz() {
    xyz data;
    data.z = _zpin;
    return data.z;
}

void Accel::sleep() {
    _sleep.write(0);
}
void Accel::wakeup() {
    _sleep.write(1);
}
int Accel::fall_detect() {
    int fall =_zero_g.read();
    return fall;
}
int Accel::select_g(int g_sel) {
    _g_select.write(g_sel);
    return g_sel;
}
int Accel::selftest() {
    return 0;
}