/* mbed analog gyro Library
 * Copyright (c) 2010 Justin Solarski
 * justinsolarski@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef GYRO_H
#define GYRO_H

#include "mbed.h"
/** Class: Gyro
 *
 * Used for reading from an analog Gyro Tested with LISY300Al spark fun breakout board
 * http://www.sparkfun.com/products/8955
 * 300o/S
 * specs - 3.3mV per o/S +-300 0/S max
 *       - 5% temp variance 
 *       - 
 *
 * Example:
 *
 * > #include "mbed.h"
 * > #include "gyro.h"
 * > Gyro mygyro(p20, p19, p18);
 */
class Gyro  {
public:
/** constructor Gyro - create Gyro object
 * 
 * @param g_pin = analog in pin
 * @param st = self test pin
 * @param pd = powerdown
 */
    Gyro (PinName g_pin, PinName st, PinName pd);

/** read gyros analog pin 
 *
 * outputs 0.0-1.0 
 *
 */
    float read();
/** Use the self test mode to test if the gyro is working
 *
 * Returns 0 for test passed 1 for test failed 
 * Incomplete
 */
    int test();
/** put gyro into sleep mode
 * 
 */
    void sleep();
/** wake gyro up from sleep mode (default)
 *
 */
    void wakeup();
/** give you rate or turning degrees per second Fo/S
 *  - uses the map funciton defined in the cpp file
 *  - this function works, but no real world data yet
 *  - I might be missing some critical math for conversion 
 */
    int rate();
        
private :

    AnalogIn _g_pin;
    DigitalInOut _st;
    DigitalInOut _pd;

}; //end of class sensor

#endif