/* mbed analog Gyro Library
 * Copyright (c) 2010 Justin Solarski
 * justinsolarski@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "gyro.h"

long map(long x, long in_min, long in_max, long out_min, long out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


Gyro::Gyro(PinName g_pin, PinName st, PinName pd) : _g_pin(g_pin), _st(st), _pd(pd) {
    _st.write(0);
    _pd.write(0);
}


float Gyro::read() {
    return _g_pin.read();
}
int Gyro::test() {
return 0;
}
void Gyro::sleep() {
    _pd.write(1);
}
void Gyro::wakeup() {
    _pd.write(0);
}
int Gyro::rate() {
    unsigned int speed;
    int mapped;
    speed = _g_pin.read_u16();
    mapped = map(speed, 0, 65535, -300, 300);
    return mapped;
}
