#if !FEATURE_LWIP
#error [NOT_SUPPORTED] LWIP not supported for this target
#endif


#include "mbed.h"
#include "EthernetInterface.h"

#define IP          "10.12.3.26"
#define NETMASK     "255.255.255.0"
#define GATEWAY     "192.168.137.1"

#define serv_IP     "10.12.3.25"

#define TMR3_COUNT  54000000      // loop 5k

#include <cstdlib>
#include <iostream>

using namespace std;

float calc_time = 0.0f;
    
Timer t;

extern "C" void TIM3_IRQHandler(void)
{
    if ( TIM3->SR & TIM_SR_UIF ) {



    }
    TIM3->SR = 0x0;
}

void Init_TMR3()
{


    RCC->APB1ENR |= RCC_APB1ENR_TIM3EN;                         // enable TIM3 clock

    //ISR Setup

    NVIC_EnableIRQ(TIM3_IRQn);                         //Enable TIM3 IRQ

    TIM3->DIER |= TIM_DIER_UIE;                                 // enable update interrupt
    TIM3->CR1 = 0x40;                                           // CMS = 10, interrupt only when counting up // Center-aligned mode
    TIM3->CR1 |= TIM_CR1_UDIS;
    TIM3->CR1 |= TIM_CR1_ARPE;                                  // autoreload on,
    TIM3->RCR |= 0x001;                                         // update event once per up/down count of TIM3
    TIM3->EGR |= TIM_EGR_UG;

    TIM3->PSC = 0x4;                                            // no prescaler, timer counts up in sync with the peripheral clock
    TIM3->ARR = TMR3_COUNT;                                          // set auto reload, 5 khz
    TIM3->CCER |= ~(TIM_CCER_CC1NP);                            // Interupt when low side is on.
    TIM3->CR1 |= TIM_CR1_CEN;                                   // enable TIM4
}


int main()
{
    Init_TMR3();
    TIM3->CR1 ^= TIM_CR1_UDIS;
    NVIC_SetPriority(TIM3_IRQn, 2);

    t.reset();
    t.start();
//
//    wait(1.0);
//    printf("Basic HTTP client example\n");
//
//    EthernetInterface eth;
//    eth.set_network(IP, NETMASK, GATEWAY);
//    eth.connect();
////
////    int eth_state = eth.connect();
////
//    printf("The target IP address is '%s'\n", eth.get_ip_address());
//
//    TCPSocket clt_sock;
//    clt_sock.open(&eth);
//    clt_sock.connect(serv_IP,80);
//
//    // UDPSocket clt_sock;
////        clt_sock.open(&eth);
//////    clt_sock.connect("192.168.137.25",80);
//
////    SocketAddress serv_IP;
//
//    char tbuffer[] = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
//    char rbuffer[128];

    while (true) {

        cout << "t : " << calc_time << endl;
        wait(0.2f);



//        t.reset();
//        t.start();
//        clt_sock.send(tbuffer, strlen(tbuffer));
//        t.stop();
//        printf("send time: %f\n",t.read()*1000.0f);
//
//        t.reset();
//        t.start();
//        clt_sock.recv(rbuffer,50);
//        t.stop();
//        printf("recv time: %f\n",t.read()*1000.0f);

    }
}
