//#if !FEATURE_LWIP
//#error [NOT_SUPPORTED] LWIP not supported for this target
//#endif


#include "mbed.h"
//#include "EthernetInterface.h"

#define IP          "10.12.3.26"
#define NETMASK     "255.255.255.0"
#define GATEWAY     "192.168.137.1"

#define serv_IP     "10.12.3.25"

#define TMR3_COUNT  21800      // loop 5k ,   for stm32f767zi
#define TMR3_COUNT  10900      // loop 10k ,   for stm32f767zi
//#define TMR3_COUNT  18000      // loop 5k   ,   for stm32f446re
//#define TMR3_COUNT  9000      // loop 10k   ,   for stm32f446re

#include <cstdlib>
#include <iostream>

using namespace std;

float calc_time = 0.0f;

Timer t;

//DigitalOut tpin(PC_8);



void Init_TMR3()
{


    RCC->APB1ENR |= RCC_APB1ENR_TIM3EN;                         // enable TIM3 clock

    //ISR Setup

    NVIC_EnableIRQ(TIM3_IRQn);                         //Enable TIM3 IRQ

    TIM3->DIER |= TIM_DIER_UIE;                                 // enable update interrupt
    TIM3->CR1 = 0x40;                                           // CMS = 10, interrupt only when counting up // Center-aligned mode
    TIM3->CR1 |= TIM_CR1_UDIS;
    TIM3->CR1 |= TIM_CR1_ARPE;                                  // autoreload on,
    TIM3->RCR |= 0x001;                                         // update event once per up/down count of TIM3
    TIM3->EGR |= TIM_EGR_UG;

    TIM3->PSC = 0x0;                                            // no prescaler, timer counts up in sync with the peripheral clock
    TIM3->ARR = TMR3_COUNT;                                          // set auto reload, 5 khz
    TIM3->CCER |= ~(TIM_CCER_CC1NP);                            // Interupt when low side is on.
    TIM3->CR1 |= TIM_CR1_CEN;                                   // enable TIM4
}

//CAN can(PB_8, PB_9);           //for stm32f446re

CAN          can(PD_0, PD_1);      // CAN Rx pin name, CAN Tx pin name, for stm32f767zi
CANMessage   rxMsg;
CANMessage   txMsg;

void onMsgReceived()
{
    //msgAvailable = true;
//    printf("%df\n\r", rxMsg.id);
    can.read(rxMsg);
    if((rxMsg.id == 20)) {



        can.write(txMsg);


//        controller.timeout = 0;
//        if(((rxMsg.data[0]==0xFF) & (rxMsg.data[1]==0xFF) & (rxMsg.data[2]==0xFF) & (rxMsg.data[3]==0xFF) & (rxMsg.data[4]==0xFF) & (rxMsg.data[5]==0xFF) & (rxMsg.data[6]==0xFF) & (rxMsg.data[7]==0xFC))){
//            state = MOTOR_MODE;
//            state_change = 1;
//            }
//        else if(((rxMsg.data[0]==0xFF) & (rxMsg.data[1]==0xFF) & (rxMsg.data[2]==0xFF) & (rxMsg.data[3]==0xFF) * (rxMsg.data[4]==0xFF) & (rxMsg.data[5]==0xFF) & (rxMsg.data[6]==0xFF) & (rxMsg.data[7]==0xFD))){
//            state = REST_MODE;
//            state_change = 1;
//            gpio.led->write(0);;
//            }
//        else if(((rxMsg.data[0]==0xFF) & (rxMsg.data[1]==0xFF) & (rxMsg.data[2]==0xFF) & (rxMsg.data[3]==0xFF) * (rxMsg.data[4]==0xFF) & (rxMsg.data[5]==0xFF) & (rxMsg.data[6]==0xFF) & (rxMsg.data[7]==0xFE))){
//            spi.ZeroPosition();
//            }
//        else if(state == MOTOR_MODE){
//            unpack_cmd(rxMsg, &controller);
//            }
//        pack_reply(&txMsg, controller.theta_mech, controller.dtheta_mech, controller.i_q_filt*KT_OUT);
//        can.write(txMsg);
    }

}

extern "C" void TIM3_IRQHandler(void)
{
    if ( TIM3->SR & TIM_SR_UIF ) {

        can.write(txMsg);
        
//        if(tpin == 1)
//            tpin = 0;
//        else
//            tpin = 1;

    }
    TIM3->SR = 0x0;
}
int main()
{

//    NVIC_SetPriority(CAN1_RX0_IRQn, 3);
//    can.filter(20, 0xFFE00004, CANStandard, 0);

//    txMsg.id = CAN_MASTER;
//    txMsg.len = 6;
    rxMsg.len = 4;
    txMsg.len = 4;
    txMsg.id = 10;
    txMsg.data[0] = 'a';
    txMsg.data[1] = 'b';
    txMsg.data[2] = 'c';
    txMsg.data[3] = 'd';
    can.attach(&onMsgReceived);                                     // attach 'CAN receive-complete' interrupt handler
    NVIC_SetPriority(CAN1_RX0_IRQn, 3);
    can.filter(20,0xFFF00,CANStandard,0);
   
    if(!can.frequency(1000000))
        cout << "CAN freq setting fail !" << endl;
    else
        cout << "CAN 1Mbps setting OK !" << endl;
    
    Init_TMR3();
    TIM3->CR1 ^= TIM_CR1_UDIS;
    NVIC_SetPriority(TIM3_IRQn, 2);
    
    
//
//    t.reset();
//    t.start();
//
//    wait(1.0);
//    printf("Basic HTTP client example\n");
//
//    EthernetInterface eth;
//    eth.set_network(IP, NETMASK, GATEWAY);
//    eth.connect();
////
////    int eth_state = eth.connect();
////
//    printf("The target IP address is '%s'\n", eth.get_ip_address());
//
//    TCPSocket clt_sock;
//    clt_sock.open(&eth);
//    clt_sock.connect(serv_IP,80);
//
//    // UDPSocket clt_sock;
////        clt_sock.open(&eth);
//////    clt_sock.connect("192.168.137.25",80);
//
////    SocketAddress serv_IP;
//
//    char tbuffer[] = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
//    char rbuffer[128];

    while (true) {
        
//        cout << "result : " << result << endl;
//        wait(1.0f);
//
//        cout << "t : " << calc_time << endl;
//        wait(0.2f);



//        t.reset();
//        t.start();
//        clt_sock.send(tbuffer, strlen(tbuffer));
//        t.stop();
//        printf("send time: %f\n",t.read()*1000.0f);
//
//        t.reset();
//        t.start();
//        clt_sock.recv(rbuffer,50);
//        t.stop();
//        printf("recv time: %f\n",t.read()*1000.0f);

    }
}
