
//JS MODI
#include "quadprog.h"
#include <cstdlib>
#include "Eigen/Dense.h"

using namespace std;
using namespace Eigen;

class JS_QP
{
private:
    int NUMCOLS;//length of X
    int NUMEQ;
    int NUMINEQ;

    MatrixXd A_ineq,B_ineq;
    MatrixXd A_eq,B_eq;

public:
    MatrixXd H,F;
    MatrixXd X;

public:
    void setNums(int _xlength, int numEqConstraints, int numIneqConstraints)
    {
        NUMCOLS = _xlength;//should be 18+12+3*contact
        NUMEQ = numEqConstraints;//NUMCOLS(dynamics) + NUMCOLS(contactconstraints + swingleg)
        //contact to be weight?
        NUMINEQ = numIneqConstraints;//friction cone approximation -ufz<fx<ufz, -ufz<fy<ufz ->4

        //maybe matrix assignment here
        X = MatrixXd::Zero(NUMCOLS,1);
        A_eq = MatrixXd::Zero(NUMEQ, NUMCOLS);
        B_eq = MatrixXd::Zero(NUMEQ, 1);

        A_ineq = MatrixXd::Zero(NUMINEQ, NUMCOLS);
        B_ineq = MatrixXd::Zero(NUMINEQ, 1);


        H = MatrixXd::Zero(NUMCOLS,NUMCOLS);
        F = MatrixXd::Zero(NUMCOLS,1);
    }

    void make_EQ(MatrixXd A, MatrixXd b)
    {
        //Aeq*X = Beq
        A_eq = A;
        B_eq = b;
    }

    void make_IEQ(MatrixXd A, MatrixXd b)
    {
        // Aineq*X < Bineq
        A_ineq = A;
        B_ineq = b;
    }

    void make_HF(MatrixXd A, MatrixXd b, int mode=-1)
    {
        //min (0.5* x H x + F x)
        if(mode == -1) {
            H = A.transpose() * A + MatrixXd::Identity(NUMCOLS,NUMCOLS)*1e-3;
            F = -A.transpose() * b;

        } else {
            H = A;
            F = b;

        }

    }

    MatrixXd solve_QP()
    {
        quadprogpp::Vector<double> outX;
        quadprogpp::Matrix<double> G;
        quadprogpp::Vector<double> g0;
        quadprogpp::Matrix<double> CE;
        quadprogpp::Vector<double> ce0;
        quadprogpp::Matrix<double> CI;
        quadprogpp::Vector<double> ci0;
        //min 0.5 * x G x + g0 x
        //CE^T x + ce0 = 0
        //CI^T x + ci0 >= 0

        G.resize(NUMCOLS,NUMCOLS);
        g0.resize(NUMCOLS);
        for(int i=0; i<NUMCOLS; i++) {
            for(int j=0; j<NUMCOLS; j++) {
                G[i][j] = H(i,j);
            }
            g0[i] = F(i,0);
        }
        CE.resize(NUMCOLS,NUMEQ);
        ce0.resize(NUMEQ);
        for(int i=0; i<NUMCOLS; i++) {
            for(int j=0; j<NUMEQ; j++) {
                CE[i][j] = -A_eq(j,i);
            }
        }
        for(int j=0; j<NUMEQ; j++) {
            ce0[j] = B_eq(j,0);
        }
        CI.resize(NUMCOLS,NUMINEQ);
        ci0.resize(NUMINEQ);
        for(int i=0; i<NUMCOLS; i++) {
            for(int j=0; j<NUMINEQ; j++) {
                CI[i][j] = -A_ineq(j,i);
            }
        }
        for(int j=0; j<NUMINEQ; j++) {
            ci0[j] = B_ineq(j,0);
        }
        outX.resize(NUMCOLS);

        solve_quadprog(G, g0, CE, ce0, CI, ci0, outX);
        for(int i=0; i<NUMCOLS; i++) {
            X(i,0) = outX[i];
        }

        return X;

    }

public:

};

JS_QP js_qp;


MatrixXd Aa = MatrixXd::Zero(20,2);
MatrixXd Ba = MatrixXd::Zero(20,10);
MatrixXd Ga = MatrixXd::Zero(20,20);

MatrixXd ref_a = MatrixXd::Zero(20,1);
MatrixXd w0_a = MatrixXd::Zero(20,1);

MatrixXd At;
MatrixXd Bt;

MatrixXd X_state = MatrixXd::Zero(2,1);

MatrixXd Q = MatrixXd::Identity(20,20);
MatrixXd R = MatrixXd::Identity(10,10);

MatrixXd H;
MatrixXd F;

MatrixXd out;

MatrixXd Aieq = MatrixXd::Zero(20,10);
MatrixXd bieq = MatrixXd::Zero(20,1);

float iq_err_sum = 0.0;
MatrixXd i_ref = MatrixXd::Zero(10,1);
float iq = 0.0;

//original
#include "mbed.h"
#include "FastPWM.h"
#include "INIT_HW.h"
#include "function_CAN.h"
#include "SPI_EEP_ENC.h"
#include "I2C_AS5510.h"
#include "setting.h"
#include "function_utilities.h"
#include "stm32f4xx_flash.h"
#include "FlashWriter.h"

Timer t;

// dac & check ///////////////////////////////////////////
DigitalOut check(PC_2);
DigitalOut check_2(PC_3);
AnalogOut dac_1(PA_4);
AnalogOut dac_2(PA_5);
AnalogIn adc1(PC_4); //pressure_1
AnalogIn adc2(PB_0); //pressure_2
AnalogIn adc3(PC_1); //current


// PWM ///////////////////////////////////////////
double dtc_v=0.0;
double dtc_w=0.0;

// I2C ///////////////////////////////////////////
I2C i2c(PC_9,PA_8); // SDA, SCL (for K22F)
const int i2c_slave_addr1 =  0x56;
unsigned int value; // 10bit output of reading sensor AS5510

// SPI ///////////////////////////////////////////
//SPI eeprom(PB_15, PB_14, PB_13); // EEPROM //(SPI_MOSI, SPI_MISO, SPI_SCK);
//DigitalOut eeprom_cs(PB_12);
//FlashWriter writer(6);//2부터 7까지 되는듯 아마 sector
SPI enc(PC_12,PC_11,PC_10);
DigitalOut enc_cs(PD_2);
DigitalOut LED(PA_15);

// UART ///////////////////////////////////////////
Serial pc(PA_9,PA_10); //  _ UART

// CAN ///////////////////////////////////////////
CAN can(PB_8, PB_9, 1000000);
CANMessage msg;
void onMsgReceived()
{
    CAN_RX_HANDLER();
}

// Variables ///////////////////////////////////////////
State pos;
State vel;
State Vout;
State torq;
State pres_A;
State pres_B;
State cur;
State valve_pos;

State INIT_Vout;
State INIT_Valve_Pos;
State INIT_Pos;
State INIT_torq;

double V_out=0.0;
double V_rem=0.0; // for anti-windup
double V_MAX = 12000.0; // Maximum Voltage : 12V = 12000mV

double PWM_out=0.0;

int timer_while = 0;
int while_index = 0;


extern int CID_RX_CMD;
extern int CID_RX_REF_POSITION;
extern int CID_RX_REF_TORQUE;
extern int CID_RX_REF_PRES_DIFF;
extern int CID_RX_REF_VOUT;
extern int CID_RX_REF_VALVE_POSITION;
extern int CID_RX_REF_CURRENT;

extern int CID_TX_INFO;
extern int CID_TX_POSITION;
extern int CID_TX_TORQUE;
extern int CID_TX_PRES;
extern int CID_TX_VOUT;
extern int CID_TX_VALVE_POSITION;

// =============================================================================
// =============================================================================
// =============================================================================

/*******************************************************************************
 *  REFERENCE MODE
 ******************************************************************************/
enum _REFERENCE_MODE {
    MODE_REF_NO_ACT = 0,                                //0
    MODE_REF_DIRECT,                                //1
    MODE_REF_COS_INC,                                  //2
    MODE_REF_LINE_INC,                                 //3
    MODE_REF_SIN_WAVE,                                  //4
    MODE_REF_SQUARE_WAVE,                                  //5
};

/*******************************************************************************
 *  CONTROL MODE
 ******************************************************************************/
enum _CONTROL_MODE {
    //control mode
    MODE_NO_ACT = 0,                                    //0
    MODE_VALVE_OPEN_LOOP,                               //1
    MODE_VALVE_POSITION_CONTROL,                        //2

    MODE_JOINT_POSITION_TORQUE_CONTROL_PWM,             //3
    MODE_JOINT_POSITION_TORQUE_CONTROL_VALVE_POSITION,  //4
    MODE_VALVE_POSITION_TORQUE_CONTROL_LEARNING,        //5

    MODE_JOINT_POSITION_PRES_CONTROL_PWM,               //6
    MODE_JOINT_POSITION_PRES_CONTROL_VALVE_POSITION,    //7
    MODE_VALVE_POSITION_PRES_CONTROL_LEARNING,          //8

    MODE_TEST_CURRENT_CONTROL,                          //9
    MODE_TEST_PWM_CONTROL,                              //10

    MODE_CURRENT_CONTROL,                               //11
    MODE_JOINT_POSITION_TORQUE_CONTROL_CURRENT,         //12
    MODE_JOINT_POSITION_PRES_CONTROL_CURRENT,           //13

    //utility
    MODE_TORQUE_SENSOR_NULLING = 20,                    //20
    MODE_VALVE_NULLING_AND_DEADZONE_SETTING,            //21
    MODE_FIND_HOME,                                     //22
    MODE_VALVE_GAIN_SETTING,                        //23
    MODE_PRESSURE_SENSOR_NULLING,                       //24
    MODE_PRESSURE_SENSOR_CALIB,                         //25
    MODE_ROTARY_FRICTION_TUNING,                        //26

    MODE_DDV_POS_VS_PWM_ID = 30,                           //30
    MODE_DDV_DEADZONE_AND_CENTER,                       //31
    MODE_DDV_POS_VS_FLOWRATE,                           //32
};

int main()
{
    /*********************************
    ***     Initialization
    *********************************/
    //LED = 1;
    //pc.baud(9600);

    // i2c init
    i2c.frequency(400 * 1000);          // 0.4 mHz
    wait_ms(2);                         // Power Up wait
    look_for_hardware_i2c();            // Hardware present
    init_as5510(i2c_slave_addr1);
    make_delay();

//    // spi init
    //eeprom.format(8,3);
    //eeprom.frequency(5000000); //5M
    enc.format(8,0);
    enc.frequency(5000000); //5M
    make_delay();

    //rom
    ROM_CALL_DATA();
    make_delay();

    // ADC init
    Init_ADC();
    make_delay();

    // Pwm init
    Init_PWM();
    TIM4->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // TMR3 init
    Init_TMR3();
    TIM3->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // TMR5 init
    Init_TMR2();
    TIM2->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // CAN
    can.attach(&CAN_RX_HANDLER);
    CAN_ID_INIT();
    make_delay();

    //Timer priority
    NVIC_SetPriority(TIM3_IRQn, 2);
    NVIC_SetPriority(TIM2_IRQn, 3);
    NVIC_SetPriority(TIM4_IRQn, 4);

    //can.reset();
    can.filter(msg.id, 0xFFFFF000, CANStandard);

    // spi _ enc
    spi_enc_set_init();
    make_delay();

    //DAC init
    dac_1 = PRES_A_VREF / 3.3;
    dac_2 = PRES_B_VREF / 3.3;
    make_delay();

    for (int i=0; i<50; i++) {
        if(i%2==0)
            ID_index_array[i] = - i * 0.5;
        else
            ID_index_array[i] =  (i+1) * 0.5;
    }



//JS MODI


    Aa <<
       1.000000,-1.000000
       ,0.000000,-0.666667
       ,1.000000,-0.333333
       ,0.000000,0.444444
       ,1.000000,-0.777778
       ,0.000000,-0.296296
       ,1.000000,-0.481481
       ,0.000000,0.197531
       ,1.000000,-0.679012
       ,0.000000,-0.131687
       ,1.000000,-0.547325
       ,0.000000,0.087791
       ,1.000000,-0.635117
       ,0.000000,-0.058528
       ,1.000000,-0.576589
       ,0.000000,0.039018
       ,1.000000,-0.615607
       ,0.000000,-0.026012
       ,1.000000,-0.589595
       ,0.000000,0.017342;


    Ba <<
       0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.044444,0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.022222,-0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.029630,-0.044444,0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.051852,-0.022222,-0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.019753,0.029630,-0.044444,0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.032099,-0.051852,-0.022222,-0.066667,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.013169,-0.019753,0.029630,-0.044444,0.066667,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.045267,-0.032099,-0.051852,-0.022222,-0.066667,0.000000,0.000000,0.000000,0.000000,0.000000
       ,-0.008779,0.013169,-0.019753,0.029630,-0.044444,0.066667,0.000000,0.000000,0.000000,0.000000
       ,-0.036488,-0.045267,-0.032099,-0.051852,-0.022222,-0.066667,0.000000,0.000000,0.000000,0.000000
       ,0.005853,-0.008779,0.013169,-0.019753,0.029630,-0.044444,0.066667,0.000000,0.000000,0.000000
       ,-0.042341,-0.036488,-0.045267,-0.032099,-0.051852,-0.022222,-0.066667,0.000000,0.000000,0.000000
       ,-0.003902,0.005853,-0.008779,0.013169,-0.019753,0.029630,-0.044444,0.066667,0.000000,0.000000
       ,-0.038439,-0.042341,-0.036488,-0.045267,-0.032099,-0.051852,-0.022222,-0.066667,0.000000,0.000000
       ,0.002601,-0.003902,0.005853,-0.008779,0.013169,-0.019753,0.029630,-0.044444,0.066667,0.000000
       ,-0.041040,-0.038439,-0.042341,-0.036488,-0.045267,-0.032099,-0.051852,-0.022222,-0.066667,0.000000
       ,-0.001734,0.002601,-0.003902,0.005853,-0.008779,0.013169,-0.019753,0.029630,-0.044444,0.066667;



    Ga <<
       1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,0.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000,0.000000,0.000000
       ,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000,1.000000,0.000000
       ,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000000;



    Aieq.block(0,0,10,10) = MatrixXd::Identity(10,10);
    Aieq.block(10,0,10,10) = -MatrixXd::Identity(10,10);

    for(int i=0; i<10; i++) {
        bieq(i,0) = 5.0;
        bieq(i+10,0) = 5.0;
    }

    for(int i=0; i<10; i++) {
        i_ref(i,0) = 10e-3;
    }

    /************************************
    ***     Program is operating!
    *************************************/
    while(1) {
        if(timer_while==1000) {
            //i2c
            //read_field(i2c_slave_addr1);
            //if(DIR_VALVE_ENC < 0) value = 1023 - value;

//            if(LED==1) {
//                LED=0;
//            } else
//                LED = 1;
            timer_while = 0;

        }
        timer_while ++;
    }
}

int DDV_JOINT_POS_FF(double REF_JOINT_VEL)
{

    int i = 0;
    int Ref_Valve_Pos_FF = DDV_CENTER;
    for(i=0; i<VALVE_POS_NUM; i++) {
        if(REF_JOINT_VEL >= min(JOINT_VEL[i],JOINT_VEL[i+1]) && REF_JOINT_VEL <=  max(JOINT_VEL[i],JOINT_VEL[i+1])) {
            if(i==0) {
                Ref_Valve_Pos_FF = ((int) 10.0/(JOINT_VEL[i+1] - JOINT_VEL[i]) * (REF_JOINT_VEL - JOINT_VEL[i])) + DDV_CENTER;
            } else {
                Ref_Valve_Pos_FF = ((int) 10.0*(ID_index_array[i+1] - ID_index_array[i-1])/(JOINT_VEL[i+1] - JOINT_VEL[i-1]) * (REF_JOINT_VEL - JOINT_VEL[i-1])) + DDV_CENTER + 10*ID_index_array[i-1];
            }
            break;
        }
    }
    if(REF_JOINT_VEL > max(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = VALVE_MAX_POS;
    } else if(REF_JOINT_VEL < min(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = VALVE_MIN_POS;
    }
    Ref_Valve_Pos_FF_CAN = Ref_Valve_Pos_FF;
    return Ref_Valve_Pos_FF;
}


void VALVE_POS_CONTROL(double REF_VALVE_POS)
{
    int i = 0;

    valve_pos_err = REF_VALVE_POS - value;
    valve_pos_err_diff = valve_pos_err - valve_pos_err_old;
    valve_pos_err_old = valve_pos_err;
    valve_pos_err_sum += valve_pos_err;
    if (valve_pos_err_sum > 1000) valve_pos_err_sum = 1000;
    if (valve_pos_err_sum<-1000) valve_pos_err_sum = -1000;

    VALVE_PWM_RAW_FB = P_GAIN_VALVE_POSITION * valve_pos_err + I_GAIN_VALVE_POSITION * valve_pos_err_sum + D_GAIN_VALVE_POSITION * valve_pos_err_diff;

    if(REF_VALVE_POS > VALVE_MAX_POS) {
        REF_VALVE_POS = VALVE_MAX_POS;
    } else if(REF_VALVE_POS < VALVE_MIN_POS) {
        REF_VALVE_POS = VALVE_MIN_POS;
    }


//    if(REF_VALVE_POS >= VALVE_POS_VS_PWM[0])
//    {
//        if(REF_VALVE_POS <=  VALVE_POS_VS_PWM[1]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[1] - VALVE_POS_VS_PWM[0]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[0]);
//        }else if(REF_VALVE_POS <=  VALVE_POS_VS_PWM[3]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[3] - VALVE_POS_VS_PWM[1]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[1]) + 3000.0* (double) ID_index_array[1];
//        }else if(REF_VALVE_POS <=  VALVE_POS_VS_PWM[5]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[5] - VALVE_POS_VS_PWM[3]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[3]) + 3000.0* (double) ID_index_array[3];
//        }else if(REF_VALVE_POS <=  VALVE_POS_VS_PWM[7]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[7] - VALVE_POS_VS_PWM[5]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[5]) + 3000.0* (double) ID_index_array[5];
//        }else
//            VALVE_PWM_RAW_FF = 12000.0;
//    }
//    else
//    {
//        if(REF_VALVE_POS >= VALVE_POS_VS_PWM[2]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[0] - VALVE_POS_VS_PWM[2]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[2]) + 3000.0* (double) ID_index_array[2];
//        }else if(REF_VALVE_POS >= VALVE_POS_VS_PWM[4]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[2] - VALVE_POS_VS_PWM[4]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[4]) + 3000.0* (double) ID_index_array[4];
//        }else if(REF_VALVE_POS >= VALVE_POS_VS_PWM[6]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[4] - VALVE_POS_VS_PWM[6]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[6]) + 3000.0* (double) ID_index_array[6];
//        }else if(REF_VALVE_POS >= VALVE_POS_VS_PWM[8]) {
//            VALVE_PWM_RAW_FF = (double) 3000.0 / (double) (VALVE_POS_VS_PWM[6] - VALVE_POS_VS_PWM[8]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[8]) + 3000.0* (double) ID_index_array[8];
//        }else
//            VALVE_PWM_RAW_FF = -12000.0;
//    }

    for(i=0; i<24; i++) {
        if(REF_VALVE_POS >= min(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1]) && REF_VALVE_POS <=  max(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1])) {
            if(i==0) {
                VALVE_PWM_RAW_FF = (double) 1000.0 / (double) (VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[i]);
            } else {
                VALVE_PWM_RAW_FF = (double) 1000.0* (double) (ID_index_array[i+1] - ID_index_array[i-1])/(VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i-1]) * ((double) REF_VALVE_POS - VALVE_POS_VS_PWM[i-1]) + 1000.0* (double) ID_index_array[i-1];
            }
            break;
        }
    }

    V_out = VALVE_PWM_RAW_FF + VALVE_PWM_RAW_FB;
}

#define LT_MAX_IDX  57
double LT_PWM_duty[LT_MAX_IDX] = {-100.0, -80.0, -60.0, -50.0, -40.0, -35.0, -30.0, -25.0, -20.0,
                                  -19.0, -18.0, -17.0, -16.0, -15.0, -14.0, -13.0, -12.0, -11.0, -10.0,
                                  -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0,
                                  1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0,
                                  11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0,
                                  25.0, 30.0, 35.0, 40.0, 50.0, 60.0, 80.0, 100.0
                                 };  // duty
double LT_Voltage_Output[LT_MAX_IDX] = {-321.4, -291.3, -261.5, -246.8, -231.7, -223.9, -216.1, -207.9, -198.8,
                                        -196.9, -195.0, -192.5, -188.8, -184.5, -180.2, -175.9, -171.5, -166.3, -161.0,
                                        -156.0, -149.5, -139.0, -126.0, -107.0, -87.5, -64.0, -38.5, -9.4, 0.0,
                                        12.0, 43.5, 69.0, 94.0, 114.0, 132.0, 146.0, 155.5, 162.3, 168.2,
                                        173.1, 178.2, 182.8, 187.4, 191.8, 196.0, 199.7, 201.9, 203.8, 205.6,
                                        214.6, 222.5, 230.4, 238.2, 253.3, 268.0, 297.6, 327.7
                                       }; // mV

double PWM_duty_byLT(double Ref_V)
{
    double PWM_duty = 0.0;
    if(Ref_V<LT_Voltage_Output[0]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[0])/1.5+LT_PWM_duty[0];
    } else if (Ref_V>=LT_Voltage_Output[LT_MAX_IDX-1]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[LT_MAX_IDX-1])/1.5+LT_PWM_duty[LT_MAX_IDX-1];
    } else {
        int idx = 0;
        for(idx=0; idx<LT_MAX_IDX-1; idx++) {
            double ini_x = LT_Voltage_Output[idx];
            double fin_x = LT_Voltage_Output[idx+1];
            double ini_y = LT_PWM_duty[idx];
            double fin_y = LT_PWM_duty[idx+1];
            if(Ref_V>=ini_x && Ref_V<fin_x) {
                PWM_duty = (fin_y-ini_y)/(fin_x-ini_x)*(Ref_V-ini_x) + ini_y;
                break;
            }
        }
    }

    return PWM_duty;
}

/*******************************************************************************
                            TIMER INTERRUPT
*******************************************************************************/

//unsigned long CNT_TMR4 = 0;
double FREQ_TMR4 = (double)FREQ_10k;
double DT_TMR4 = (double)DT_10k;
extern "C" void TIM4_IRQHandler(void)
{

    if (TIM4->SR & TIM_SR_UIF ) {

        /*******************************************************
        ***     Sensor Read & Data Handling
        ********************************************************/


        //Using LoadCell
//            ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
//            //while((ADC1->SR & 0b10));
//            double alpha_update_torque = 1.0/(1.0+(FREQ_TMR4/2.0)/(2.0*3.14*1000.0));
//            double torque_new = ((double)ADC1->DR - PRES_A_NULL)  / TORQUE_SENSOR_PULSE_PER_TORQUE + 1.0;
//            torq.sen = torq.sen*(1.0-alpha_update_torque)+torque_new*(alpha_update_torque);



        //Pressure sensor A
        ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
        //while((ADC1->SR & 0b10));
        double alpha_update_pres_A = 1.0/(1.0+(FREQ_TMR4/2.0)/(2.0*3.14*1000.0));
        double pres_A_new = ((double)ADC1->DR - PRES_A_NULL)  / PRES_SENSOR_A_PULSE_PER_BAR;
        pres_A.sen = pres_A.sen*(1.0-alpha_update_pres_A)+pres_A_new*(alpha_update_pres_A);

        //Pressure sensor 1B
        //ADC2->CR2  |= 0x40000000;                        // adc _ 12bit
        //while((ADC2->SR & 0b10));
        double alpha_update_pres_B = 1.0/(1.0+(FREQ_TMR4/2.0)/(2.0*3.14*1000.0));
        double pres_B_new = ((double)ADC2->DR - PRES_B_NULL)  / PRES_SENSOR_B_PULSE_PER_BAR;
        pres_B.sen = pres_B.sen*(1.0-alpha_update_pres_B)+pres_B_new*(alpha_update_pres_B);
        torq.sen = pres_A.sen * (double) PISTON_AREA_A - pres_B.sen * (double) PISTON_AREA_B;



        //Current
        //ADC3->CR2  |= 0x40000000;                        // adc _ 12bit
//          a1=ADC2->DR;
        int raw_cur = ADC3->DR;
        //while((ADC3->SR & 0b10));
        double alpha_update_cur = 1.0/(1.0+(FREQ_TMR4/2.0)/(2.0*3.14*1000.0)); // f_cutoff : 500Hz
        double cur_new = ((double)ADC3->DR-2048.0)*20.0/4096.0; // unit : mA
        cur.sen=cur.sen*(1.0-alpha_update_cur)+cur_new*(alpha_update_cur);
//        cur.sen = raw_cur;

        /*******************************************************
        ***     Timer Counting & etc.
        ********************************************************/
        //CNT_TMR4++;
    }
    TIM4->SR = 0x0;  // reset the status register
}


int j =0;
//unsigned long CNT_TMR3 = 0;
//double FREQ_TMR3 = (double)FREQ_5k;
double FREQ_TMR3 = (double)FREQ_1k;
//double DT_TMR3 = (double)DT_5k;
double DT_TMR3 = (double)DT_1k;
extern "C" void TIM3_IRQHandler(void)
{
    if (TIM3->SR & TIM_SR_UIF ) {
        ENC_UPDATE();








        // CONTROL LOOP ------------------------------------------------------------

        switch (CONTROL_MODE) {
            case MODE_NO_ACT: {
                V_out = 0;
                break;
            }

            case MODE_VALVE_OPEN_LOOP: {
                V_out = (double) Vout.ref;
                break;
            }

            case MODE_VALVE_POSITION_CONTROL: {
                VALVE_POS_CONTROL(valve_pos.ref);
                break;
            }

            case MODE_JOINT_POSITION_TORQUE_CONTROL_PWM: {
                double PWM_RAW_POS_FB = 0.0; // PWM by Position Feedback
                double PWM_RAW_POS_FF = 0.0; // PWM by Position Feedforward
                double PWM_RAW_FORCE_FB = 0.0; // PWM by Force Feedback

                // feedback input for position control
                pos.err = pos.ref - (double) pos.sen;
                pos.err_diff = pos.err - pos.err_old;
                pos.err_old = pos.err;
                pos.err_sum += pos.err;
                if (pos.err_sum > 1000) pos.err_sum = 1000;
                if (pos.err_sum<-1000) pos.err_sum = -1000;
                //            PWM_RAW_POS_FB = (double) P_GAIN_JOINT_POSITION * pos.err + (double) I_GAIN_JOINT_POSITION * pos.err_sum + (double) D_GAIN_JOINT_POSITION * pos.err_diff;
                PWM_RAW_POS_FB = (double) P_GAIN_JOINT_POSITION * pos.err;
                PWM_RAW_POS_FB = PWM_RAW_POS_FB * 0.01;

                // feedforward input for position control
                double Ref_Vel_Act = vel.ref/(double)ENC_PULSE_PER_POSITION; // [pulse/s] >> [deg/s]
                double K_ff = 0.9;
                if(Ref_Vel_Act > 0) K_ff = 0.90; // open
                if(Ref_Vel_Act > 0) K_ff = 0.75; // close
                PWM_RAW_POS_FF = K_ff*Ref_Vel_Act/0.50;

                // torque feedback
                //            torq.err = torq.ref - torq.sen;
                //            torq.err_diff = torq.err - torq.err_old;
                //            torq.err_old = torq.err;
                //            torq.err_sum += torq.err;
                //            if (torq.err_sum > 1000) torq.err_sum = 1000;
                //            if (torq.err_sum<-1000) torq.err_sum = -1000;
                //            VALVE_PWM_RAW_TORQ = (double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum + (double) D_GAIN_JOINT_TORQUE * torq.err_diff;
                //            VALVE_PWM_RAW_TORQ = VALVE_PWM_RAW_TORQ * 0.01;

                PWM_RAW_FORCE_FB = 0.0;

                V_out = PWM_RAW_POS_FF + PWM_RAW_POS_FB + PWM_RAW_FORCE_FB;

                break;
            }

            case MODE_JOINT_POSITION_TORQUE_CONTROL_VALVE_POSITION: {


                double VALVE_POS_RAW_POS_FB = 0.0; // Valve Position by Position Feedback
                //double VALVE_POS_RAW_POS_FF = 0.0; // Valve Position by Position Feedforward
                double VALVE_POS_RAW_FORCE_FB = 0.0; // Valve Position by Force Feedback
                //int DDV_JOINT_CAN = 0;
                // feedback input for position control
                pos.err = pos.ref - (double) pos.sen;
                pos.err_diff = pos.err - pos.err_old;
                pos.err_old = pos.err;
                pos.err_sum += pos.err;
                if (pos.err_sum > 1000) pos.err_sum = 1000;
                if (pos.err_sum<-1000) pos.err_sum = -1000;
                VALVE_POS_RAW_POS_FB = (double) P_GAIN_JOINT_POSITION * 0.01 * pos.err + (double) I_GAIN_JOINT_POSITION * pos.err_sum + (double) D_GAIN_JOINT_POSITION * pos.err_diff;
                VALVE_POS_RAW_POS_FB = VALVE_POS_RAW_POS_FB * 0.01;


                //Ref_Joint_Vel =  Ref_Vel_Test;
                // feedforward input for position control
                //            double Ref_Joint_Vel_Act = Ref_Joint_Vel/(double)ENC_PULSE_PER_POSITION; // [pulse/s] >> [deg/s]
                //            double K_ff = 0.9;
                //            if(Ref_Joint_Vel_Act > 0) K_ff = 0.90; // open
                //            if(Ref_Joint_Vel_Act > 0) K_ff = 0.75; // close
                //            VALVE_POS_RAW_POS_FF = K_ff*Ref_Joint_Vel_Act/0.50;

                // torque feedback
                //            torq.err = torq.ref - torq.sen;
                //            torq.err_diff = torq.err - torq.err_old;
                //            torq.err_old = torq.err;
                //            torq.err_sum += torq.err;
                //            if (torq.err_sum > 1000) torq.err_sum = 1000;
                //            if (torq.err_sum<-1000) torq.err_sum = -1000;
                //            VALVE_PWM_RAW_TORQ = (double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum + (double) D_GAIN_JOINT_TORQUE * torq.err_diff;
                //            VALVE_PWM_RAW_TORQ = VALVE_PWM_RAW_TORQ * 0.01;
                VALVE_POS_RAW_FORCE_FB = 0.0;

                valve_pos.ref = VALVE_POS_RAW_POS_FB + DDV_JOINT_POS_FF(vel.ref) + VALVE_POS_RAW_FORCE_FB;
                //valve_pos.ref = VALVE_POS_RAW_POS_FB + DDV_CENTER;
                VALVE_POS_CONTROL(valve_pos.ref);


                break;
            }

            case MODE_VALVE_POSITION_TORQUE_CONTROL_LEARNING: {

                break;
            }

            case MODE_JOINT_POSITION_PRES_CONTROL_PWM: {
                pos.err = pos.ref - (double) pos.sen;
                pos.err_diff = pos.err - pos.err_old;
                pos.err_old = pos.err;
                pos.err_sum += pos.err;
                if (pos.err_sum > 1000) pos.err_sum = 1000;
                if (pos.err_sum<-1000) pos.err_sum = -1000;
                VALVE_PWM_RAW_POS = ((double) P_GAIN_JOINT_POSITION * pos.err + (double) I_GAIN_JOINT_POSITION * pos.err_sum + (double) D_GAIN_JOINT_POSITION * pos.err_diff) * 0.01;

                torq.err = torq.ref - torq.sen;
                torq.err_diff = torq.err - torq.err_old;
                torq.err_old = torq.err;
                torq.err_sum += torq.err;
                if (torq.err_sum > 1000) torq.err_sum = 1000;
                if (torq.err_sum<-1000) torq.err_sum = -1000;
                VALVE_PWM_RAW_TORQ = (double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum + (double) D_GAIN_JOINT_TORQUE * torq.err_diff;

                VALVE_PWM_RAW_TORQ = VALVE_PWM_RAW_TORQ * 0.01;

                V_out = VALVE_PWM_RAW_POS + (double) COMPLIANCE_GAIN * 0.01 * VALVE_PWM_RAW_TORQ;

                CUR_FLOWRATE = (double) CUR_VELOCITY * 0.00009587;
                CUR_FLOWRATE = CUR_FLOWRATE * 0.5757; // 0.4791=2*pi/65536*5000(pulse/tic to rad/s) 0.5757=0.02525*0.02*0.0095*2*60*1000 (radius * area * 2 * 60(sec --> min) * 1000(m^3 --> L))
                if (DIR_VALVE > 0) {
                    if (CUR_FLOWRATE >= 0 && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[0]*1.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - 0.0) / (VALVE_GAIN_LPM_PER_V[0]*1.0 - 0.0) + 0.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[0]*1.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[2]*2.)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[0]*1.0) / (VALVE_GAIN_LPM_PER_V[2]*2.0 - VALVE_GAIN_LPM_PER_V[0]*1.) + 1.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[2]*2.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[4]*3.)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[2]*2.0) / (VALVE_GAIN_LPM_PER_V[4]*3.0 - VALVE_GAIN_LPM_PER_V[2]*2.) + 2.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[4]*3.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[6]*4.)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[4]*3.0) / (VALVE_GAIN_LPM_PER_V[6]*4.0 - VALVE_GAIN_LPM_PER_V[4]*3.) + 3.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[6]*4.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[8]*5.)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[6]*4.0) / (VALVE_GAIN_LPM_PER_V[8]*5.0 - VALVE_GAIN_LPM_PER_V[6]*4.) + 4.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[8]*5.0)) VALVE_FF_VOLTAGE = 5.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[1]*(-1.0)) && CUR_FLOWRATE < 0.0) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[1]*(-1.0)) / (0.0 - VALVE_GAIN_LPM_PER_V[1]*(-1.)) - 1.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[3]*(-2.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[1]*(-1.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[3]*(-2.0)) / ((VALVE_GAIN_LPM_PER_V[1]*(-1.0)) - VALVE_GAIN_LPM_PER_V[3]*(-2.)) - 2.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[5]*(-3.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[3]*(-2.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[5]*(-3.0)) / ((VALVE_GAIN_LPM_PER_V[3]*(-2.0)) - VALVE_GAIN_LPM_PER_V[5]*(-3.)) - 3.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[7]*(-4.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[5]*(-3.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[7]*(-4.0)) / ((VALVE_GAIN_LPM_PER_V[5]*(-3.0)) - VALVE_GAIN_LPM_PER_V[7]*(-4.)) - 4.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[9]*(-5.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[7]*(-4.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[9]*(-5.0)) / ((VALVE_GAIN_LPM_PER_V[7]*(-4.0)) - VALVE_GAIN_LPM_PER_V[9]*(-5.)) - 5.0;
                    else if (CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[9]*(-5.0))) VALVE_FF_VOLTAGE = -5;
                    else VALVE_FF_VOLTAGE = 0;
                } else {
                    if (CUR_FLOWRATE >= 0 && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[0]*1.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - 0.0) / (VALVE_GAIN_LPM_PER_V[0]*1.0 - 0.0) + 0.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[1]*1.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[2]*2.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[0]*1.0) / (VALVE_GAIN_LPM_PER_V[2]*2.0 - VALVE_GAIN_LPM_PER_V[0]*1.) + 1.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[3]*2.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[4]*3.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[2]*2.0) / (VALVE_GAIN_LPM_PER_V[4]*3.0 - VALVE_GAIN_LPM_PER_V[2]*2.) + 2.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[5]*3.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[6]*4.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[4]*3.0) / (VALVE_GAIN_LPM_PER_V[6]*4.0 - VALVE_GAIN_LPM_PER_V[4]*3.) + 3.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[7]*4.0) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[8]*5.0)) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[6]*4.0) / (VALVE_GAIN_LPM_PER_V[8]*5.0 - VALVE_GAIN_LPM_PER_V[6]*4.) + 4.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[9]*5.0)) VALVE_FF_VOLTAGE = 5.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[0]*(-1.0)) && CUR_FLOWRATE < 0.0) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[1]*(-1.0)) / (0.0 - VALVE_GAIN_LPM_PER_V[1]*(-1.0)) - 1.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[2]*(-2.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[1]*(-1.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[3]*(-2.0)) / ((VALVE_GAIN_LPM_PER_V[1]*(-1.0)) - VALVE_GAIN_LPM_PER_V[3]*(-2.0)) - 2.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[4]*(-3.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[3]*(-2.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[5]*(-3.0)) / ((VALVE_GAIN_LPM_PER_V[3]*(-2.0)) - VALVE_GAIN_LPM_PER_V[5]*(-3.0)) - 3.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[6]*(-4.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[5]*(-3.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[7]*(-4.0)) / ((VALVE_GAIN_LPM_PER_V[5]*(-3.0)) - VALVE_GAIN_LPM_PER_V[7]*(-4.0)) - 4.0;
                    else if (CUR_FLOWRATE >= (VALVE_GAIN_LPM_PER_V[8]*(-5.0)) && CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[7]*(-4.0))) VALVE_FF_VOLTAGE = (CUR_FLOWRATE - VALVE_GAIN_LPM_PER_V[9]*(-5.0)) / ((VALVE_GAIN_LPM_PER_V[7]*(-4.0)) - VALVE_GAIN_LPM_PER_V[9]*(-5.0)) - 5.0;
                    else if (CUR_FLOWRATE < (VALVE_GAIN_LPM_PER_V[8]*(-5.0))) VALVE_FF_VOLTAGE = -5;
                    else VALVE_FF_VOLTAGE = 0;
                }
                //            VALVE_FF_VOLTAGE = CUR_FLOWRATE * 0.5;

                if (CUR_FLOWRATE >= 0) VALVE_FF_VOLTAGE = (double) VELOCITY_COMP_GAIN * 0.001 * VALVE_FF_VOLTAGE * sqrt((double) PRES_SUPPLY - CUR_PRES_A_BAR) * 0.0707; // 0.0707 = 1/sqrt(200.))
                else if (CUR_FLOWRATE < 0) VALVE_FF_VOLTAGE = (double) VELOCITY_COMP_GAIN * 0.001 * VALVE_FF_VOLTAGE * sqrt((double) PRES_SUPPLY - CUR_PRES_B_BAR) * 0.0707;

                V_out = V_out + VALVE_FF_VOLTAGE;
                break;
            }

            case MODE_JOINT_POSITION_PRES_CONTROL_VALVE_POSITION: {
                pos.err = pos.ref - (double) pos.sen;
                pos.err_diff = pos.err - pos.err_old;
                pos.err_old = pos.err;
                pos.err_sum += pos.err;
                if (pos.err_sum > 1000) pos.err_sum = 1000;
                if (pos.err_sum<-1000) pos.err_sum = -1000;
                VALVE_PWM_RAW_POS = ((double) P_GAIN_JOINT_POSITION * pos.err + (double) I_GAIN_JOINT_POSITION * pos.err_sum + (double) D_GAIN_JOINT_POSITION * pos.err_diff) * 0.01;

                torq.err = torq.ref - torq.sen;
                torq.err_diff = torq.err - torq.err_old;
                torq.err_old = torq.err;
                torq.err_sum += torq.err;
                if (torq.err_sum > 1000) torq.err_sum = 1000;
                if (torq.err_sum<-1000) torq.err_sum = -1000;
                VALVE_PWM_RAW_TORQ = (double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum + (double) D_GAIN_JOINT_TORQUE * torq.err_diff;

                valve_pos.ref = VALVE_PWM_RAW_POS + VALVE_PWM_RAW_TORQ;
                VALVE_POS_CONTROL(valve_pos.ref);

                break;
            }

            case MODE_VALVE_POSITION_PRES_CONTROL_LEARNING: {

                break;
            }


            case MODE_TEST_CURRENT_CONTROL: {
                if (TMR3_COUNT_IREF == TMR_FREQ_5k) {
                    TMR3_COUNT_IREF = 0;
                }
                TMR3_COUNT_IREF++;

                // Set Current Reference
                double TMR3_CNT_MAX = (double)TMR_FREQ_5k/2.0;
                double I_REF_MID = 0.0;
                if (TMR3_COUNT_IREF < TMR3_CNT_MAX) {
                    I_REF = I_REF_MID + 1.0;
                } else {
                    I_REF = I_REF_MID - 1.0;
                }
//              double T = 1.0; // wave period
//              I_REF = (5. * sin(2. * 3.1415 * (double) TMR3_COUNT_IREF / (double)TMR_FREQ_5k/ T));
//              I_REF = (2.0 * sin(2. * 2. * 3.14 * (double) TMR3_COUNT_IREF / 5000.)+(2.0 * sin(2. * 1. * 3.14 * (double)TMR3_COUNT_IREF/ 5000.))+(2.0 * sin(2. * 5. * 3.14 * (double)TMR3_COUNT_IREF/ 5000.))+(2.0 * sin(2. * 10. * 3.14 * (double)TMR3_COUNT_IREF/ 5000.)));

                if (TMR3_COUNT_IREF % (int) (TMR_FREQ_5k / CAN_FREQ) == 0) {
                    //CAN_TX_PRES((int16_t)(I_REF*1000.0), (int16_t) (CUR_CURRENT*1000.0)); // to check the datas
                }
                break;
            }

            case MODE_TEST_PWM_CONTROL: {
                if (TMR3_COUNT_IREF == TMR_FREQ_5k) {
                    TMR3_COUNT_IREF = 0;
                }
                TMR3_COUNT_IREF++;

                // Set PWM reference
                double TMR3_CNT_MAX = (double)TMR_FREQ_5k/2.0;
                //double I_REF_MID = 0.0;
                if (TMR3_COUNT_IREF < TMR3_CNT_MAX) {
                    CUR_PWM = 1000;
                } else {
                    CUR_PWM = -1000;
                }

                if (TMR3_COUNT_IREF % (int) (TMR_FREQ_5k / CAN_FREQ) == 0) {
                    //CAN_TX_PRES((int16_t)(u_CUR[0]*1000.0), (int16_t) (CUR_CURRENT*1000.0)); // to check the datas
                }
                break;
            }


            case MODE_CURRENT_CONTROL: {

                cur.ref = cur.ref; // Unit : mA
                CurrentControl();
                break;
            }

            case MODE_JOINT_POSITION_TORQUE_CONTROL_CURRENT: {
                double I_REF_POS_FB = 0.0; // I_REF by Position Feedback
                double I_REF_POS_FF = 0.0; // I_REF by Position Feedforward
                double I_REF_FORCE_FB = 0.0; // I_REF by Force Feedback
                double I_REF_FORCE_FF = 0.0; // I_REF by Force Feedforward

                // feedback input for position control
                pos.err = pos.ref - pos.sen;
                double alpha_update_vel = 1.0/(1.0+(double)FREQ_TMR4/(2.0*3.1415*50.0)); // f_cutoff : 50Hz
                double err_diff = (pos.err - pos.err_old)*(double)FREQ_5k;
                pos.err_diff = (1.0-alpha_update_vel)*pos.err_diff + alpha_update_vel*err_diff;
                pos.err_old = pos.err;
                I_REF_POS_FB = 0.001*((double)P_GAIN_JOINT_POSITION * pos.err + (double)D_GAIN_JOINT_POSITION * pos.err_diff * 0.1);

                // feedforward input for position control
                double Vel_Act_Ref = vel.ref; // [pulse/s] >> [deg/s]
                double K_ff = 1.3;
                double K_v = 0.0;
                if(Vel_Act_Ref > 0) K_v = 1.0/100.0; // open, tuning. (deg/s >> mA)
                if(Vel_Act_Ref < 0) K_v = 1.0/100.0; // close, tuning. (deg/s >> mA)
                I_REF_POS_FF = K_ff*K_v*Vel_Act_Ref;

                // feedback input for position control
                I_REF_FORCE_FB = 0.0;

                // feedforward input for position control
                I_REF_FORCE_FF = 0.0;

                cur.ref = I_REF_POS_FF + I_REF_POS_FB + I_REF_FORCE_FB + I_REF_FORCE_FF;

                CurrentControl();

                break;
            }

            case MODE_JOINT_POSITION_PRES_CONTROL_CURRENT: {
                //double T_REF = 0.0; // Torque Reference
                double I_REF_FORCE_FB = 0.; // I_REF by Force Feedback
                double I_REF_VC = 0.; // I_REF for velocity compensation

                // feedback input for position control
                //double Joint_Pos_Err = 34.0-(double) pos.sen/(double)ENC_PULSE_PER_POSITION; // [pulse/s] >> [deg/s]
                //double Joint_Vel_Err = 0.0-(double) vel.sen/(double)ENC_PULSE_PER_POSITION; // [pulse/s] >> [deg/s]
                //double K_spring = 0.7;
                //double D_damper = 0.02;
//              T_REF = K_spring * pos.err + D_damper * Joint_Vel_Err; // unit : Nm

                // torque feedback
                torq.err = torq.ref - torq.sen;
                //            torq.err_diff = torq.err - torq.err_old;
                //            torq.err_old = torq.err;
                torq.err_sum = torq.err_sum + torq.err/(double)TMR_FREQ_5k;
                I_REF_FORCE_FB = 0.001*((double)P_GAIN_JOINT_TORQUE * torq.err + (double)I_GAIN_JOINT_TORQUE * torq.err_sum);

                // velocity compensation for torque control
                double Joint_Vel_Act = vel.sen/(double)ENC_PULSE_PER_POSITION; // [pulse/s] >> [deg/s]
                double K_vc = 1.5; // Velocity comp. gain
                double K_v = 0.0; // Valve gain
                if(Joint_Vel_Act > 0) K_v = 1.0/100.0; // open, tuning
                if(Joint_Vel_Act < 0) K_v = 1.0/100.0; // close, tuning
                I_REF_VC = K_vc*K_v*Joint_Vel_Act;

                cur.ref = I_REF_VC + I_REF_FORCE_FB;
                //            cur.ref = I_REF_FORCE_FB;

                double I_MAX = 10.00; // Maximum Current : 10mV
                double Ka = 1.0/I_GAIN_JOINT_TORQUE;
                if(cur.ref > I_MAX) {
                    double I_rem = cur.ref-I_MAX;
                    I_rem = Ka*I_rem;
                    cur.ref = I_MAX;
                    torq.err_sum = torq.err_sum - I_rem/(double)TMR_FREQ_5k;
                } else if(cur.ref < -I_MAX) {
                    double I_rem = cur.ref-(-I_MAX);
                    I_rem = Ka*I_rem;
                    cur.ref = -I_MAX;
                    torq.err_sum = torq.err_sum - I_rem/(double)TMR_FREQ_5k;
                }

                CurrentControl();


                /*
                double I_REF_POS_FB = 0.0; // I_REF by Position Feedback
                double I_REF_POS_FF = 0.0; // I_REF by Position Feedforward
                double I_REF_FORCE_FB = 0.0; // I_REF by Force Feedback
                double I_REF_FORCE_FF = 0.0; // I_REF by Force Feedforward

                // feedback input for position control
                pos.err = pos.ref - pos.sen;
                double alpha_update_vel = 1.0/(1.0+(double)FREQ_TMR4/(2.0*3.1415*50.0)); // f_cutoff : 50Hz
                double err_diff = (pos.err - pos.err_old)*(double)FREQ_5k;
                pos.err_diff = (1.0-alpha_update_vel)*pos.err_diff + alpha_update_vel*err_diff;
                pos.err_old = pos.err;
                I_REF_POS_FB = 0.001*((double)P_GAIN_JOINT_POSITION * pos.err + (double)D_GAIN_JOINT_POSITION * pos.err_diff * 0.1);

                // feedforward input for position control
                double Vel_Act_Ref = vel.ref; // [pulse/s] >> [deg/s]
                double K_ff = 1.3;
                double K_v = 0.0;
                if(Vel_Act_Ref > 0) K_v = 1.0/100.0; // open, tuning. (deg/s >> mA)
                if(Vel_Act_Ref < 0) K_v = 1.0/100.0; // close, tuning. (deg/s >> mA)
                I_REF_POS_FF = K_ff*K_v*Vel_Act_Ref;

                // feedback input for position control
                I_REF_FORCE_FB = 0.0;

                // feedforward input for position control
                I_REF_FORCE_FF = 0.0;

                cur.ref = I_REF_POS_FF + I_REF_POS_FB + I_REF_FORCE_FB + I_REF_FORCE_FF;

                CurrentControl();
                */

                break;
            }

            case MODE_TORQUE_SENSOR_NULLING: {
                // DAC Voltage reference set
                if (TMR3_COUNT_TORQUE_NULL < TMR_FREQ_5k * 2) {
                    CUR_TORQUE_sum += torq.sen;

                    if (TMR3_COUNT_TORQUE_NULL % 10 == 0) {
                        CUR_TORQUE_mean = CUR_TORQUE_sum / 10.0;
                        CUR_TORQUE_sum = 0;

                        TORQUE_VREF += 0.0001 * (TORQUE_NULL - CUR_TORQUE_mean);

                        if (TORQUE_VREF > 3.3) TORQUE_VREF = 3.3;
                        if (TORQUE_VREF < 0) TORQUE_VREF = 0;

                        ROM_RESET_DATA();

                        //spi_eeprom_write(RID_TORQUE_SENSOR_VREF, (int16_t) (TORQUE_VREF * 1000.0));
                        dac_1 = TORQUE_VREF / 3.3;
                    }
                } else {
                    CONTROL_MODE = MODE_NO_ACT;
                    TMR3_COUNT_TORQUE_NULL = 0;
                    CUR_TORQUE_sum = 0;
                    CUR_TORQUE_mean = 0;

                    ROM_RESET_DATA();

                    //spi_eeprom_write(RID_TORQUE_SENSOR_VREF, (int16_t) (TORQUE_VREF * 1000.0));

                    //pc.printf("%f\n", TORQUE_VREF);
                    dac_1 = TORQUE_VREF / 3.3;

                }
                TMR3_COUNT_TORQUE_NULL++;
                break;
            }

            case MODE_VALVE_NULLING_AND_DEADZONE_SETTING: {
                if (TMR3_COUNT_DEADZONE == 0) {
                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
                    else temp_time = 0;
                }
                if (need_enc_init) {
                    if (TMR3_COUNT_DEADZONE < (int) (0.5 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                        pos_plus_end = pos.sen;
                    } else if (TMR3_COUNT_DEADZONE < TMR_FREQ_5k) {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                        pos_minus_end = pos.sen;
                    } else if (TMR3_COUNT_DEADZONE == TMR_FREQ_5k) need_enc_init = false;
                    temp_time = TMR_FREQ_5k;
                }

                if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + TMR_FREQ_5k)) {
                    V_out = (double) P_GAIN_JOINT_POSITION * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                    VALVE_CENTER = VALVE_DEADZONE_PLUS = VALVE_DEADZONE_MINUS = 0;

                } else if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + (int) (1.9 * (double) TMR_FREQ_5k))) {
                    V_out = 0;
                    CUR_VELOCITY_sum += CUR_VELOCITY;
                } else if (TMR3_COUNT_DEADZONE == (temp_time + 2 * TMR_FREQ_5k)) {
                    if (CUR_VELOCITY_sum == 0) DZ_dir = 1;
                    else if (CUR_VELOCITY_sum > 0) DZ_dir = 1;
                    else if (CUR_VELOCITY_sum < 0) DZ_dir = -1;
                    else DZ_temp_cnt2 = DZ_end;
                    CUR_VELOCITY_sum = 0;
                } else if (TMR3_COUNT_DEADZONE > (temp_time + 2 * TMR_FREQ_5k)) {
                    if (TMR3_COUNT_DEADZONE > (temp_time + 10 * TMR_FREQ_5k)) DZ_temp_cnt2 = DZ_end;

                    // Position of Dead Zone
                    //  (CUR_VELOCITY < 0)  (CUR_VELOCITY == 0)  (CUR_VELOCITY > 0)
                    //     |        /                 |    /                      |/
                    //     | ______/               ___|___/                ______/|
                    //     |/                     /   |                   /       |
                    //    /|                     /    |                  /        |
                    //     0V                         0V                          0V

                    if (DZ_temp_cnt2 < DZ_end) {
                        if (TMR3_COUNT_DEADZONE % 20 != 0) {
                            CUR_VELOCITY_sum += CUR_VELOCITY;
                        } else {
                            V_out -= DZ_dir;
                            if (CUR_VELOCITY_sum * DZ_dir < 0) DZ_temp_cnt++;
                            CUR_VELOCITY_sum = 0;
                        }
                        if (DZ_temp_cnt == 5) {
                            if (DZ_dir >= 0) VALVE_DEADZONE_MINUS = (int16_t) V_out;
                            else VALVE_DEADZONE_PLUS = (int16_t) V_out;
                            DZ_dir = -DZ_dir;
                            DZ_temp_cnt = 0;
                            DZ_temp_cnt2++;
                        }
                    } else {
                        TMR3_COUNT_DEADZONE = -1;
                        VALVE_CENTER = VALVE_DEADZONE_PLUS / 2 + VALVE_DEADZONE_MINUS / 2;
                        if (VALVE_DEADZONE_PLUS < VALVE_DEADZONE_MINUS) {
                            VALVE_DEADZONE_PLUS = VALVE_CENTER;
                            VALVE_DEADZONE_MINUS = VALVE_CENTER;
                        }
                        V_out = 0;

                        ROM_RESET_DATA();

                        //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, VALVE_DEADZONE_PLUS);
                        //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, VALVE_DEADZONE_MINUS);

                        CONTROL_MODE = MODE_NO_ACT;
                        DZ_temp_cnt2 = 0;
                    }
                }
                TMR3_COUNT_DEADZONE++;
                break;
            }

            case MODE_FIND_HOME: {


                ////////////////////////////////////////////FIND_HOME_PWM/////////////////////////////////////////////////////
                if (FLAG_FIND_HOME == true) {
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                    //REFERENCE_MODE = MODE_REF_NO_ACT; // Stop taking reference data from PODO
                    pos.ref = pos.sen;
                    FLAG_FIND_HOME = false;
                }

                int check_enc = (TMR_FREQ_5k/10);
                if(cnt_findhome%check_enc == 0) {
                    FINDHOME_POSITION = pos.sen;
                    FINDHOME_VELOCITY = FINDHOME_POSITION - FINDHOME_POSITION_OLD;
                    FINDHOME_POSITION_OLD = FINDHOME_POSITION;
                }
                cnt_findhome++;
                if(cnt_findhome == 10000) cnt_findhome = 0;

                if (abs(FINDHOME_VELOCITY) <= 1) {
                    cnt_vel_findhome = cnt_vel_findhome + 1;
                } else {
                    cnt_vel_findhome = 0;
                }

                if (cnt_vel_findhome < 2*TMR_FREQ_5k) {
                    //REFERENCE_MODE = MODE_REF_NO_ACT;
                    if (HOMEPOS_OFFSET > 0) pos.ref = pos.ref + 1.0;
                    else pos.ref = pos.ref - 1.0;
                    pos.err = pos.ref - (double) pos.sen;
                    V_out = ((double) P_GAIN_JOINT_POSITION * pos.err) * 0.01;
                    //                if (HOMEPOS_OFFSET > 0) V_out = 100;
                    //                else V_out = -100;
                } else {
                    ENC_SET(HOMEPOS_OFFSET);
                    FLAG_REFERENCE_JOINT_POSITION = 1;
                    INIT_REF_POS = HOMEPOS_OFFSET;
                    REF_MOVE_TIME_5k = 2 * TMR_FREQ_5k;
                    TMR3_COUNT_REFERENCE = 0;
                    vel.ref = 0.0;
                    //REFERENCE_MODE = MODE_REF_COS_INC;
                    CONTROL_MODE = MODE_JOINT_POSITION_TORQUE_CONTROL_PWM;

                    FINDHOME_POSITION = 0;
                    FINDHOME_POSITION_OLD = 0;
                    FINDHOME_VELOCITY = 0;
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                }

                /*
                ////////////////////////////////////////////FIND_HOME_CURRENT/////////////////////////////////////////////////////
                if (FLAG_FIND_HOME == true) {
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                    REFERENCE_MODE = MODE_REF_NO_ACT; // Stop taking reference data from PODO
                    Ref_Joint_Pos = pos.sen;
                    FLAG_FIND_HOME = false;
                }

                int cnt_check_enc = (TMR_FREQ_5k/500);
                if(cnt_findhome%cnt_check_enc == 0){
                    FINDHOME_POSITION = pos.sen;
                    FINDHOME_VELOCITY = FINDHOME_POSITION - FINDHOME_POSITION_OLD;
                    FINDHOME_POSITION_OLD = FINDHOME_POSITION;
                } cnt_findhome++;
                if(cnt_findhome == 10000) cnt_findhome = 0;

                if (abs(FINDHOME_VELOCITY) <= 1) {
                    cnt_vel_findhome = cnt_vel_findhome + 1;
                } else {
                    cnt_vel_findhome = 0;
                }

                if (cnt_vel_findhome < 3*TMR_FREQ_5k) { // wait for 3sec
                    REFERENCE_MODE = MODE_REF_NO_ACT;
                    if (HOMEPOS_OFFSET > 0) Ref_Joint_Pos = Ref_Joint_Pos + 1.0;
                    else Ref_Joint_Pos = Ref_Joint_Pos - 1.0;
                    pos.err = Ref_Joint_Pos - pos.sen;
                    I_REF = 0.001*((double)pos.err);
                    if(I_REF>5.0) I_REF = 5.0;
                    if(I_REF<-5.0) I_REF = -5.0;
                    cur.ref = I_REF;
                    CurrentControl();
                } else {
                    ENC_SET(HOMEPOS_OFFSET);
                    FLAG_REFERENCE_JOINT_POSITION = 1;
                    INIT_REF_POS = HOMEPOS_OFFSET;
                    REF_MOVE_TIME_5k = 2 * TMR_FREQ_5k;
                    TMR3_COUNT_REFERENCE = 0;
                    Ref_Joint_Vel = 0.0;
                    REFERENCE_MODE = MODE_REF_COS_INC;
                    CONTROL_MODE = MODE_JOINT_POSITION_TORQUE_CONTROL_VALVE_POSITION;

                    FINDHOME_POSITION = 0;
                    FINDHOME_POSITION_OLD = 0;
                    FINDHOME_VELOCITY = 0;
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                }
                */

                break;
            }

            case MODE_VALVE_GAIN_SETTING: {
                if (TMR3_COUNT_FLOWRATE == 0) {
                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
                    else {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                        temp_time = (int) (0.5 * (double) TMR_FREQ_5k);
                    }
                }
                if (need_enc_init) {
                    if (TMR3_COUNT_FLOWRATE < (int) (0.5 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                        pos_plus_end = pos.sen;
                    } else if (TMR3_COUNT_FLOWRATE < TMR_FREQ_5k) {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                        pos_minus_end = pos.sen;
                    } else if (TMR3_COUNT_FLOWRATE == TMR_FREQ_5k) {
                        need_enc_init = false;
                        check_vel_pos_init = (int) (0.9 * (double) (pos_plus_end - pos_minus_end));
                        check_vel_pos_fin = (int) (0.95 * (double) (pos_plus_end - pos_minus_end));
                        check_vel_pos_interv = check_vel_pos_fin - check_vel_pos_init;
                    }
                    temp_time = TMR_FREQ_5k;
                }
                TMR3_COUNT_FLOWRATE++;
                if (TMR3_COUNT_FLOWRATE > temp_time) {
                    if (flag_flowrate % 2 == 0) { // (+)
                        VALVE_VOLTAGE = 1000.0 * (double) (flag_flowrate / 2 + 1);
                        V_out = VALVE_VOLTAGE;
                        if (pos.sen > (pos_minus_end + check_vel_pos_init) && pos.sen < (pos_minus_end + check_vel_pos_fin)) {
                            fl_temp_cnt++;
                        } else if (pos.sen >= (pos_minus_end + check_vel_pos_fin) && CUR_VELOCITY == 0) {
                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873 * 0.5757 * (double) TMR_FREQ_5k / 10000.0 * (double) check_vel_pos_interv / (double) fl_temp_cnt / VALVE_VOLTAGE; // 0.9587=6*pi/65536*10000 0.5757=0.02525*0.02*0.0095*2*60*1000
                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (double) TMR_FREQ_10k * (double) check_vel_pos_interv / (double) fl_temp_cnt / VALVE_VOLTAGE; // PULSE/sec
                            fl_temp_cnt2++;
                        }
                    } else if (flag_flowrate % 2 == 1) { // (-)
                        VALVE_VOLTAGE = -1. * (double) (flag_flowrate / 2 + 1);
                        V_out = VALVE_VOLTAGE;
                        if (pos.sen < (pos_plus_end - check_vel_pos_init) && pos.sen > (pos_plus_end - check_vel_pos_fin)) {
                            fl_temp_cnt++;
                        } else if (pos.sen <= (pos_plus_end - check_vel_pos_fin) && CUR_VELOCITY == 0) {
                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873 * 0.5757 * (double) TMR_FREQ_5k / 10000.0 * (double) check_vel_pos_interv / (double) fl_temp_cnt / (-VALVE_VOLTAGE);
                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (double) TMR_FREQ_10k * (double) check_vel_pos_interv / (double) fl_temp_cnt / (-VALVE_VOLTAGE); // PULSE/sec
                            fl_temp_cnt2++;
                        }
                    }
                    if (fl_temp_cnt2 == 100) {

                        ROM_RESET_DATA();

                        //spi_eeprom_write(RID_VALVE_GAIN_PLUS_1 + flag_flowrate, (int16_t) (VALVE_GAIN_LPM_PER_V[flag_flowrate] * 100.0));
                        cur_vel_sum = 0;
                        fl_temp_cnt = 0;
                        fl_temp_cnt2 = 0;
                        flag_flowrate++;
                    }
                    if (flag_flowrate == 10) {
                        V_out = 0;
                        flag_flowrate = 0;
                        TMR3_COUNT_FLOWRATE = 0;
                        valve_gain_repeat_cnt++;
                        if (valve_gain_repeat_cnt >= 1) {
                            CONTROL_MODE = MODE_NO_ACT;
                            valve_gain_repeat_cnt = 0;
                        }

                    }
                    break;
                }

            }

            case MODE_PRESSURE_SENSOR_NULLING: {
                // DAC Voltage reference set
                if (TMR3_COUNT_PRES_NULL < TMR_FREQ_5k * 2) {
                    CUR_PRES_A_sum += pres_A.sen;
                    CUR_PRES_B_sum += pres_B.sen;

                    if (TMR3_COUNT_PRES_NULL % 10 == 0) {
                        CUR_PRES_A_mean = CUR_PRES_A_sum / 10.0;
                        CUR_PRES_B_mean = CUR_PRES_B_sum / 10.0;
                        CUR_PRES_A_sum = 0;
                        CUR_PRES_B_sum = 0;

                        double VREF_NullingGain = 0.003;
                        PRES_A_VREF -= VREF_NullingGain * (PRES_A_NULL - CUR_PRES_A_mean);
                        PRES_B_VREF -= VREF_NullingGain * (PRES_B_NULL - CUR_PRES_B_mean);

                        if (PRES_A_VREF > 3.3) PRES_A_VREF = 3.3;
                        if (PRES_A_VREF < 0) PRES_A_VREF = 0;
                        if (PRES_B_VREF > 3.3) PRES_B_VREF = 3.3;
                        if (PRES_B_VREF < 0) PRES_B_VREF = 0;

                        dac_1 = PRES_A_VREF / 3.3;
                        dac_2 = PRES_B_VREF / 3.3;
                    }
                } else {
                    CONTROL_MODE = MODE_NO_ACT;
                    TMR3_COUNT_PRES_NULL = 0;
                    CUR_PRES_A_sum = 0;
                    CUR_PRES_B_sum = 0;
                    CUR_PRES_A_mean = 0;
                    CUR_PRES_B_mean = 0;

                    ROM_RESET_DATA();

                    dac_1 = PRES_A_VREF / 3.3;
                    dac_2 = PRES_B_VREF / 3.3;
                    //pc.printf("nulling end");
                }
                TMR3_COUNT_PRES_NULL++;
                break;
            }

            case MODE_PRESSURE_SENSOR_CALIB: {
                if (TMR3_COUNT_PRES_CALIB < 2 * TMR_FREQ_5k) {
                    V_out = -VALVE_VOLTAGE_LIMIT;
                    if (TMR3_COUNT_PRES_CALIB >= TMR_FREQ_5k) {
                        CUR_PRES_A_sum += CUR_PRES_A;
                    }
                } else if (TMR3_COUNT_PRES_CALIB < 4 * TMR_FREQ_5k) {
                    V_out = VALVE_VOLTAGE_LIMIT;
                    if (TMR3_COUNT_PRES_CALIB >= 3 * TMR_FREQ_5k) {
                        CUR_PRES_B_sum += CUR_PRES_B;
                    }
                } else {
                    CONTROL_MODE = MODE_NO_ACT;
                    TMR3_COUNT_PRES_CALIB = 0;
                    V_out = 0;
                    PRES_SENSOR_A_PULSE_PER_BAR = CUR_PRES_A_sum / ((double) TMR_FREQ_5k - 1.0) - PRES_A_NULL;
                    PRES_SENSOR_A_PULSE_PER_BAR = PRES_SENSOR_A_PULSE_PER_BAR / ((double) PRES_SUPPLY - 1.0);
                    PRES_SENSOR_B_PULSE_PER_BAR = CUR_PRES_B_sum / ((double) TMR_FREQ_5k - 1.0) - PRES_B_NULL;
                    PRES_SENSOR_B_PULSE_PER_BAR = PRES_SENSOR_B_PULSE_PER_BAR / ((double) PRES_SUPPLY - 1.0);
                    CUR_PRES_A_sum = 0;
                    CUR_PRES_B_sum = 0;
                    CUR_PRES_A_mean = 0;
                    CUR_PRES_B_mean = 0;

                    ROM_RESET_DATA();

                    //spi_eeprom_write(RID_PRES_SENSOR_A_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_A_PULSE_PER_BAR * 100.0));
                    //spi_eeprom_write(RID_PRES_SENSOR_B_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_B_PULSE_PER_BAR * 100.0));
                }
                TMR3_COUNT_PRES_CALIB++;
                break;
            }

            case MODE_ROTARY_FRICTION_TUNING: {
                if (TMR3_COUNT_ROTARY_FRIC_TUNE % (5 * TMR_FREQ_5k) == 0) freq_fric_tune = 4 + 3. * sin(2 * 3.14159 * 0.5 * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001 * 0.05);
                V_out = PWM_out * sin(2 * 3.14159 * freq_fric_tune * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001);
                if (V_out > 0) V_out = VALVE_VOLTAGE_LIMIT;
                else V_out = -VALVE_VOLTAGE_LIMIT;
                TMR3_COUNT_ROTARY_FRIC_TUNE++;
                if (TMR3_COUNT_ROTARY_FRIC_TUNE > TUNING_TIME * TMR_FREQ_5k) {
                    TMR3_COUNT_ROTARY_FRIC_TUNE = 0;
                    V_out = 0;
                    CONTROL_MODE = MODE_NO_ACT;
                }
                break;
            }

            case MODE_DDV_POS_VS_PWM_ID: {
                VALVE_ID_timer = VALVE_ID_timer + 1;

                if(VALVE_ID_timer < TMR_FREQ_5k*1) {
                    V_out = 3000.0 * sin(2*3.14*VALVE_ID_timer/TMR_FREQ_5k * 100.0);
                } else if(VALVE_ID_timer < TMR_FREQ_5k*2) {
                    V_out = 1000.0*(ID_index_array[ID_index]);
                } else if(VALVE_ID_timer == TMR_FREQ_5k*2) {
                    VALVE_POS_TMP = 0;
                    data_num = 0;
                } else if(VALVE_ID_timer < TMR_FREQ_5k*3) {
                    data_num = data_num + 1;
                    VALVE_POS_TMP = VALVE_POS_TMP + value;
                } else if(VALVE_ID_timer == TMR_FREQ_5k*3) {
                    VALVE_POS_AVG[ID_index] = VALVE_POS_TMP / data_num;
                    VALVE_ID_timer = 0;
                    ID_index= ID_index +1;
                }

                if(ID_index>=25) {
                    int i;
                    VALVE_POS_AVG_OLD = VALVE_POS_AVG[0];
                    for(i=0; i<25; i++) {
                        VALVE_POS_VS_PWM[i] = (int16_t) (VALVE_POS_AVG[i]);
                        if(VALVE_POS_AVG[i] > VALVE_POS_AVG_OLD) {
                            VALVE_MAX_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MAX_POS;
                        } else if(VALVE_POS_AVG[i] < VALVE_POS_AVG_OLD) {
                            VALVE_MIN_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MIN_POS;
                        }
                    }
                    ROM_RESET_DATA();
                    ID_index = 0;
                    CONTROL_MODE = MODE_NO_ACT;
                }


                break;
            }

            case MODE_DDV_DEADZONE_AND_CENTER: {

                VALVE_DZ_timer = VALVE_DZ_timer + 1;
                if(first_check == 0) {
                    if(VALVE_DZ_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                    } else if(VALVE_DZ_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                        pos_plus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                    } else if(VALVE_DZ_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                        pos_minus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (3.0 * (double) TMR_FREQ_5k)) {
                        V_out = (double) P_GAIN_JOINT_POSITION * 0.01 * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                    } else if(VALVE_DZ_timer < (int) (4.0 * (double) TMR_FREQ_5k)) {
                        V_out = (double) P_GAIN_JOINT_POSITION * 0.01 * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        data_num = data_num + 1;
                        VALVE_POS_TMP = VALVE_POS_TMP + value;
                    } else if(VALVE_DZ_timer == (int) (4.0 * (double) TMR_FREQ_5k)) {
                        V_out = (double) P_GAIN_JOINT_POSITION * 0.01 * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        DDV_POS_AVG = VALVE_POS_TMP / data_num;
                        START_POS = pos.sen;
                        //CAN_TX_PRES((int16_t) (DDV_POS_AVG), (int16_t) (data_num));
                        VALVE_POS_TMP = 0;
                        data_num = 0;

                    } else if(VALVE_DZ_timer < (int) (5.0 * (double) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        //CAN_TX_PRES((int16_t) (VALVE_MAX_POS), (int16_t) (VALVE_MIN_POS));

                    } else if(VALVE_DZ_timer < (int) (6.0 * (double) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        if(CUR_VELOCITY >= 0)
                            VEL_POINT = VEL_POINT + 1;
                        else
                            VEL_POINT = VEL_POINT - 1;
                    } else if(VALVE_DZ_timer == (int) (6.0 * (double) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        FINAL_POS = pos.sen;
                        //                    if(VEL_POINT >= 0)
                        //                    {
                        //                        DZ_case = 1;
                        //                    }
                        //                    else
                        //                    {
                        //                        DZ_case = -1;
                        //                    }
                        //                    if(abs(FINAL_POS - START_POS) < 100)
                        //                    {
                        //                        DZ_case = 0;
                        //                    }

                        if((FINAL_POS - START_POS)>100) {
                            DZ_case = 1;
                        } else if((FINAL_POS - START_POS)<-100) {
                            DZ_case = -1;
                        } else {
                            DZ_case = 0;
                        }

                        VEL_POINT = 0;
                        first_check = 1;
                        DZ_DIRECTION = 1;
                        VALVE_DZ_timer = 0;
                        Ref_Valve_Pos_Old = DDV_POS_AVG;
                        DZ_NUM = 1;
                        DZ_index = 1;
                        //CAN_TX_PRES((int16_t) (DZ_case), (int16_t) (DZ_NUM));

                    }
                } else {
                    if((DZ_case == -1 && DZ_NUM == 1) | (DZ_case == 1 && DZ_NUM == 1)) {
                        if(VALVE_DZ_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                            V_out = (double) P_GAIN_JOINT_POSITION * 0.01 * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        } else if(VALVE_DZ_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_case * DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);
                            if(CUR_VELOCITY >= 0)
                                VEL_POINT = VEL_POINT + 1;
                            else
                                VEL_POINT = VEL_POINT - 1;
                        } else if(VALVE_DZ_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;
                            //                        if(VEL_POINT >= 0)
                            //                            DZ_DIRECTION = 1 * DZ_case;
                            //                        else
                            //                            DZ_DIRECTION = -1 * DZ_case;
                            //                        if(abs(FINAL_POS - START_POS) < 100)
                            //                            DZ_DIRECTION = 1 * DZ_case;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1 * DZ_case;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1 * DZ_case;
                            } else {
                                DZ_DIRECTION = 1 * DZ_case;
                            }

                            VEL_POINT = 0;

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }

                            //CAN_TX_PRES((int16_t) (1), (int16_t) (DZ_index));
                        }
                    } else if((DZ_case == -1 && DZ_NUM == 2) | (DZ_case == 1 && DZ_NUM == 2)) {
                        if(VALVE_DZ_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                            V_out = (double) P_GAIN_JOINT_POSITION * 0.01 * (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        } else if(VALVE_DZ_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  + DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);
                            if(CUR_VELOCITY >= 0)
                                VEL_POINT = VEL_POINT + 1;
                            else
                                VEL_POINT = VEL_POINT - 1;
                        } else if(VALVE_DZ_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;
                            //                        if(VEL_POINT >= 0)
                            //                            DZ_DIRECTION = 1 * DZ_case;
                            //                        else
                            //                            DZ_DIRECTION = -1 * DZ_case;
                            //                        if(abs(FINAL_POS - START_POS) < 100)
                            //                            DZ_DIRECTION = -1 * DZ_case;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = -1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = 1;
                            } else {
                                DZ_DIRECTION = 1;
                            }

                            VEL_POINT = 0;


                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                DDV_CENTER = (int) (0.5 * (double) (FIRST_DZ) + 0.5 * (double) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = FIRST_DZ;
                                VALVE_DEADZONE_PLUS = SECOND_DZ;

                                ROM_RESET_DATA();

                                //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, FIRST_DZ);
                                //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, SECOND_DZ);
                                //spi_eeprom_write(RID_DDV_CENTER, DDV_CENTER);
                                //CAN_TX_PRES((int16_t) FIRST_DZ, (int16_t) SECOND_DZ);
                                CONTROL_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }

                            //CAN_TX_PRES((int16_t) (2), (int16_t) (DZ_index));
                        }
                    } else if(DZ_case == 0 && DZ_NUM ==1) {
                        if(VALVE_DZ_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                            V_out = (double) P_GAIN_JOINT_POSITION * 0.01* (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        } else if(VALVE_DZ_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);
                            if(CUR_VELOCITY >= 0)
                                VEL_POINT = VEL_POINT + 1;
                            else
                                VEL_POINT = VEL_POINT - 1;
                        } else if(VALVE_DZ_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;
                            //                        if(VEL_POINT >= 0)
                            //                            DZ_DIRECTION = 1;
                            //                        else
                            //                            DZ_DIRECTION = -1;
                            //                        if(abs(FINAL_POS - START_POS) < 100)
                            //                            DZ_DIRECTION = 1;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1;
                            } else {
                                DZ_DIRECTION = 1;
                            }

                            VEL_POINT = 0;
                            //CAN_TX_PRES((int16_t) (7), (int16_t) (DZ_DIRECTION));
                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }
                        }
                    } else {
                        if(VALVE_DZ_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                            V_out = (double) P_GAIN_JOINT_POSITION * 0.01* (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                        } else if(VALVE_DZ_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  + DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref > VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS - 1;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);
                            if(CUR_VELOCITY >= 0)
                                VEL_POINT = VEL_POINT + 1;
                            else
                                VEL_POINT = VEL_POINT - 1;
                        } else if(VALVE_DZ_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;
                            if(VEL_POINT >= 0)
                                DZ_DIRECTION = -1;
                            else
                                DZ_DIRECTION = 1;
                            if(abs(FINAL_POS - START_POS) < 100)
                                DZ_DIRECTION = 1;

                            VEL_POINT = 0;


                            VALVE_DZ_timer = 0;
                            //CAN_TX_PRES((int16_t) (3), (int16_t) (DZ_index));
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                DDV_CENTER = (int) (0.5 * (double) (FIRST_DZ) + 0.5 * (double) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = FIRST_DZ;
                                //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, FIRST_DZ);
                                VALVE_DEADZONE_PLUS = SECOND_DZ;
                                ROM_RESET_DATA();

                                //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, SECOND_DZ);
                                //spi_eeprom_write(RID_DDV_CENTER, DDV_CENTER);
                                //CAN_TX_PRES((int16_t) FIRST_DZ, (int16_t) SECOND_DZ);
                                CONTROL_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }

                            //CAN_TX_PRES((int16_t) (4), (int16_t) (DZ_index));
                        }
                    }
                }
                break;
            }

            case MODE_DDV_POS_VS_FLOWRATE: {
                VALVE_FR_timer = VALVE_FR_timer + 1;
                if(first_check == 0) {
                    if(VALVE_FR_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                        //CAN_TX_PRES((int16_t) (VALVE_FR_timer), (int16_t) (6));
                    } else if(VALVE_FR_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                        V_out = VALVE_VOLTAGE_LIMIT;
                        pos_plus_end = pos.sen;
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (7));
                    } else if(VALVE_FR_timer < (int) (2.0 * (double) TMR_FREQ_5k)) {
                        V_out = -VALVE_VOLTAGE_LIMIT;
                    } else if(VALVE_FR_timer == (int) (2.0 * (double) TMR_FREQ_5k)) {
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (8));
                        V_out = -VALVE_VOLTAGE_LIMIT;
                        pos_minus_end = pos.sen;
                        first_check = 1;
                        VALVE_FR_timer = 0;
                        valve_pos.ref = DDV_CENTER;
                        ID_index = 0;
                        max_check = 0;
                        min_check = 0;
                    }
                } else {
                    if(VALVE_FR_timer < (int) (1.0 * (double) TMR_FREQ_5k)) {
                        V_out = (double) P_GAIN_JOINT_POSITION * 0.01* (0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen);
                    } else if(VALVE_FR_timer == (int) (1.0 * (double) TMR_FREQ_5k)) {
                        data_num = 0;
                        valve_pos.ref = 10*(ID_index_array[ID_index]) + DDV_CENTER;

                        VALVE_POS_CONTROL(valve_pos.ref);
                        START_POS = pos.sen;
                    } else if(VALVE_FR_timer < (int) (5.0 * (double) TMR_FREQ_5k)) {
                        valve_pos.ref = 10*(ID_index_array[ID_index]) + DDV_CENTER;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        data_num = data_num + 1;
                        if(abs(0.5 * (double) pos_plus_end + 0.5 * (double) pos_minus_end - (double) pos.sen) > 20000.0) {
                            FINAL_POS = pos.sen;
                            one_period_end = 1;
                        }
                    } else if(VALVE_FR_timer == (int) (5.0 * (double) TMR_FREQ_5k)) {
                        FINAL_POS = pos.sen;
                        one_period_end = 1;
                    }

                    if(one_period_end == 1) {
                        if(valve_pos.ref > VALVE_MAX_POS) {
                            max_check = 1;
                        } else if(valve_pos.ref < VALVE_MIN_POS) {
                            min_check = 1;
                        }
                        JOINT_VEL[ID_index] = (FINAL_POS - START_POS) / data_num * TMR_FREQ_5k;   //  pulse/sec

                        //ROM_RESET_DATA();

                        //spi_eeprom_write(RID_VALVE_POS_VS_FLOWRATE_0 + ID_index, (int16_t) (JOINT_VEL[ID_index] & 0xFFFF));
                        //spi_eeprom_write(RID_VALVE_POS_VS_FLOWRATE_0_1 + ID_index, (int16_t) ((JOINT_VEL[ID_index] >> 16) & 0xFFFF));
                        VALVE_FR_timer = 0;
                        one_period_end = 0;
                        ID_index= ID_index +1;
                        //                    CAN_TX_PRES((int16_t) (valve_pos.ref), (int16_t) (ID_index));
                        V_out = 0.0;
                    }

                    if(max_check == 1 && min_check == 1) {

                        //spi_eeprom_write(RID_VALVE_POS_NUM, (int16_t) (ID_index));
                        VALVE_POS_NUM = ID_index;
                        ROM_RESET_DATA();
                        ID_index = 0;
                        first_check = 0;
                        VALVE_FR_timer = 0;
                        //                    CAN_TX_PRES((int16_t) (123), (int16_t) (123));
                        CONTROL_MODE = MODE_NO_ACT;
                    }
                }
                break;
            }

            default:
                break;
        }

        if (FLAG_VALVE_OUTPUT_CALIB) {
            // Valve Dead Zone (Mechanical dead-zone canceling)
            //    if (CONTROL_MODE != MODE_VALVE_NULLING_AND_DEADZONE_SETTING) {
            //        if (V_out > 0.) {
            //            VALVE_PWM_VALVE_DZ = (int) V_out + VALVE_DEADZONE_PLUS;
            //        } else if (V_out < 0.) {
            //            VALVE_PWM_VALVE_DZ = (int) V_out + VALVE_DEADZONE_MINUS;
            //        } else VALVE_PWM_VALVE_DZ = (int) V_out + VALVE_CENTER;
            //    } else VALVE_PWM_VALVE_DZ = (int) V_out;

            if(V_out>0) V_out = V_out + VALVE_DEADZONE_PLUS;
            else if(V_out<0) V_out = V_out + VALVE_DEADZONE_MINUS;

            VALVE_PWM_VALVE_DZ = V_out + VALVE_CENTER;

            // Output Voltage Linearization and Dead Zone Cancellation (Electrical dead-zone)
            double CUR_PWM_nonlin = VALVE_PWM_VALVE_DZ/5.0*1000.0; // convert PWM duty to mV
            double CUR_PWM_DZ = PWM_duty_byLT(CUR_PWM_nonlin);

            if (CUR_PWM_DZ > 0) V_out = (int)CUR_PWM_DZ + 143;
            else if (CUR_PWM_DZ < 0) V_out = (int)CUR_PWM_DZ - 138;
            else V_out = CUR_PWM_DZ;
        } else {
            V_out = V_out;
        }


        iq = cur.sen*0.001;
        iq_err_sum += i_ref(0,0) - iq;
        X_state(0,0) = iq_err_sum;
        X_state(1,0) = iq;

        for (int i=0; i<10; i++) {
            w0_a(i*2,0) = i_ref(i,0);
            w0_a(i*2+1,0) = 0.0;

            ref_a(i*2,0) = 0.0;
            ref_a(i*2+1,0) = i_ref(i,0);
        }

        Bt = ref_a - Aa*X_state - Ga*w0_a;
        At = Ba;


        H = At.transpose() * Q * At + R;
        F = -At.transpose()*Bt;

        js_qp.setNums(10,0,20);

        js_qp.make_HF(H,F,1);
        js_qp.make_IEQ(Aieq,bieq);



        out = js_qp.solve_QP();
        V_out = out(0,0) * 1000.0;

        /*******************************************************
        ***     PWM
        ********************************************************/
        PWM_out= V_out/SUPPLY_VOLTAGE; // Full duty : 12000.0mV

        // Saturation of output voltage to 5.0V
//        if(PWM_out > 0.41667) PWM_out=0.41667; //5.0/12.0 = 0.41667
//        else if (PWM_out < -0.41667) PWM_out=-0.41667;

        // Saturation of output voltage to 12.0V
        if(PWM_out > 1.0) PWM_out=1.0;
        else if (PWM_out < -1.0) PWM_out=-1.0;

        if (PWM_out>0.0) {
            dtc_v=0.0;
            dtc_w=PWM_out;
        } else {
            dtc_v=-PWM_out;
            dtc_w=0.0;
        }

        //pwm
        TIM4->CCR2 = (PWM_ARR)*(1.0-dtc_v);
        TIM4->CCR1 = (PWM_ARR)*(1.0-dtc_w);



        CAN_TX_POSITION((int32_t) V_out, (int32_t) (cur.sen * 10.0));
    }
    TIM3->SR = 0x0;  // reset the status register

}



//unsigned long CNT_TMR5 = 0;
//double FREQ_TMR5 = (double)FREQ_500;
//double DT_TMR5 = (double)DT_500;
extern "C" void TIM2_IRQHandler(void)
{
    if (TIM2->SR & TIM_SR_UIF ) {

        //CAN ----------------------------------------------------------------------
        if (flag_data_request[0] == HIGH) {
            //position+velocity
            //CAN_TX_POSITION((int32_t) pos.sen, (int32_t) vel.sen);
            CAN_TX_POSITION((int32_t) V_out, (int32_t) cur.sen);
            //CAN_TX_POSITION((int32_t) valve_pos.ref, (int32_t) 0);
            //CAN_TX_POSITION((int32_t) VALVE_PWM_RAW_FF, (int32_t) VALVE_POS_VS_PWM[10]);
            //pc.printf("can good");
            //                                    CAN_TX_POSITION((long) CUR_PRES_A_BAR, (long) CUR_PRES_B_BAR);
        }

        if (flag_data_request[1] == HIGH) {
            //torque
            //CAN_TX_TORQUE((int16_t) (CUR_TORQUE_NM * 100.));
            //CAN_TX_TORQUE((int16_t) (CUR_TORQUE_NM));
            CAN_TX_TORQUE((int16_t) (cur.sen));
            //CAN_TX_TORQUE((int16_t) (Ref_Valve_Pos_FF_CAN));
            //            CAN_TX_TORQUE((int16_t) DZ_temp_cnt);
        }

        if (flag_data_request[2] == HIGH) {
            //pressure A and B
            //CAN_TX_PRES((int16_t) (pres_A.sen), (int16_t) (PRES_A_VREF)); // CUR_PRES_X : 0(0bar)~4096(210bar)
            CAN_TX_PRES((int16_t) (pres_A.sen), (int16_t) (pres_B.sen)); // CUR_PRES_X : 0(0bar)~4096(210bar)
            //                        CAN_TX_PRES((int16_t) (CUR_PRES_A_BAR * 100.), (int16_t) (CUR_PRES_B_BAR * 100.));
            //            CAN_TX_PRES((int16_t) ((DEADZONE_MINUS + 1.)*1000.), (int16_t) ((DEADZONE_PLUS + 1.))*1000.);
            //            CAN_TX_PRES((int16_t) DZ_dir, (int16_t) ((VALVE_DEADZONE_PLUS + 1.))*1000.);

        }

        if (flag_data_request[3] == HIGH) {
            //PWM
            CAN_TX_PWM((int16_t) CUR_PWM);
            //CAN_TX_PWM((int16_t) (Ref_Valve_Pos_FF_CAN));
            //            CAN_TX_PWM((int16_t) cnt_vel_findhome);
            //            CAN_TX_PWM((int16_t) (VALVE_VOLTAGE * 1000.));
            //                        CAN_TX_PWM((int16_t) (VALVE_VOLTAGE_VALVE_DZ * 1000.));

        }

        if (flag_data_request[4] == HIGH) {
            //valve position
            CAN_TX_VALVE_POSITION((int16_t) (value));
            //SPI_ROM_WRITE(RID_VALVE_POS_VS_FLOWRATE_0, (int16_t) (JOINT_VEL[ID_index] & 0xFFFF));
            //SPI_ROM_WRITE(RID_VALVE_POS_VS_FLOWRATE_0_1, (int16_t) ((0xFEF1>>16) & 0xFFFF));


            //CAN_TX_VALVE_POSITION((int16_t) (VALVE_POS_NUM));
            //                        CAN_TX_VALVE_POSITIOfxN((int16_t) (VALVE_FF_VOLTAGE / SUPPLY_VOLTAGE));
            //            CAN_TX_VALVE_POSITION((int16_t) P_GAIN_JOINT_POSITION);
            //            CAN_TX_VALVE_POSITION((int16_t) Ref_Joint_Pos);
            //            CAN_TX_VALVE_POSITION((int16_t) flag_flowrate);
        }

    }
    TIM2->SR = 0x0;  // reset the status register
}


void CurrentControl()
{
    cur.err = cur.ref - cur.sen;
    cur.err_int = cur.err_int + cur.err*DT_TMR4;
    cur.err_diff = (cur.err - cur.err_old)*FREQ_TMR4;
    cur.err_old = cur.err;

    double R_model = 150.0; // ohm
    double L_model = 0.3;
    double w0 = 2.0*3.14*90.0;
    double KP_I = L_model*w0;
    double KI_I = R_model*w0;
    double KD_I = 0.0;

    double FF_gain = 0.0;
    V_out = (int) (KP_I * cur.err + KI_I * cur.err_int + KD_I * cur.err_diff);
    //          V_out = V_out + FF_gain * (R_model*I_REF); // Unit : mV
    V_out = V_out + FF_gain * (R_model*cur.ref + L_model*cur.ref_diff); // Unit : mV

    double Ka = 5.0/KP_I;
    if(V_out > V_MAX) {
        V_rem = V_out-V_MAX;
        V_rem = Ka*V_rem;
        V_out = V_MAX;
        cur.err_int = cur.err_int - V_rem*DT_5k;
    } else if(V_out < -V_MAX) {
        V_rem = V_out-(-V_MAX);
        V_rem = Ka*V_rem;
        V_out = -V_MAX;
        cur.err_int = cur.err_int - V_rem*DT_5k;
    }
}

