#ifndef _FUNCTION_CAN_H_
#define _FUNCTION_CAN_H_

#include "mbed.h"

extern CAN can;
extern CANMessage msg;

// INIT_CID
#define INIT_CID_RX_CMD                   100
#define INIT_CID_RX_REF_POSITION          200
#define INIT_CID_RX_REF_TORQUE            300
#define INIT_CID_RX_REF_PRES_DIFF         400
#define INIT_CID_RX_REF_VOUT              500
#define INIT_CID_RX_REF_VALVE_POSITION    600
#define INIT_CID_RX_REF_CURRENT           700

#define INIT_CID_TX_INFO              1100
#define INIT_CID_TX_POSITION          1200
#define INIT_CID_TX_TORQUE            1300
#define INIT_CID_TX_PRES              1400
#define INIT_CID_TX_VOUT              1500
#define INIT_CID_TX_VALVE_POSITION    1600


// CID_RX_CMD - RX CMD type
#define             CRX_ASK_INFO                    0
#define             CRX_ASK_BNO                     1
#define             CRX_SET_BNO                     101
#define             CRX_ASK_OPERATING_MODE          2
#define             CRX_SET_OPERATING_MODE          102
#define             CRX_SET_ENC_ZERO                103
#define             CRX_SET_FET_ON                  104
#define             CRX_SET_REF_UPDATE_ENABLE       105
#define             CRX_ASK_CAN_FREQ                6
#define             CRX_SET_CAN_FREQ                106
#define             CRX_ASK_CONTROL_MODE            7
#define             CRX_SET_CONTROL_MODE            107
#define             CRX_SET_DATA_REQUEST            108
#define             CRX_ASK_JOINT_ENC_DIR           9
#define             CRX_SET_JOINT_ENC_DIR           109
#define             CRX_ASK_VALVE_DIR               10
#define             CRX_SET_VALVE_DIR               110
#define             CRX_ASK_VALVE_ENC_DIR           11
#define             CRX_SET_VALVE_ENC_DIR           111
#define             CRX_ASK_VOLTAGE_SUPPLY          12
#define             CRX_SET_VOLTAGE_SUPPLY          112
#define             CRX_ASK_VOLTAGE_VALVE           13
#define             CRX_SET_VOLTAGE_VALVE           113
#define             CRX_SET_HOMEPOS                 114      
#define             CRX_ASK_PID_GAIN                20
#define             CRX_SET_PID_GAIN                120
#define             CRX_ASK_VALVE_DEADZONE          21
#define             CRX_SET_VALVE_DEADZONE          121
#define             CRX_ASK_VELOCITY_COMP_GAIN      22
#define             CRX_SET_VELOCITY_COMP_GAIN      122
#define             CRX_ASK_COMPLIANCE_GAIN         23
#define             CRX_SET_COMPLIANCE_GAIN         123
#define             CRX_ASK_VALVE_FF                25
#define             CRX_SET_VALVE_FF                125
#define             CRX_ASK_BULK_MODULUS            26
#define             CRX_SET_BULK_MODULUS            126
#define             CRX_ASK_CHAMBER_VOLUME          27
#define             CRX_SET_CHAMBER_VOLUME          127
#define             CRX_ASK_PISTON_AREA             28
#define             CRX_SET_PISTON_AREA             128
#define             CRX_ASK_PRES                    29
#define             CRX_SET_PRES                    129
#define             CRX_ASK_ENC_LIMIT               30
#define             CRX_SET_ENC_LIMIT               130
#define             CRX_ASK_STROKE                  31
#define             CRX_SET_STROKE                  131
#define             CRX_ASK_VALVE_LIMIT             32
#define             CRX_SET_VALVE_LIMIT             132
#define             CRX_ASK_ENC_PULSE_PER_POSITION     33
#define             CRX_SET_ENC_PULSE_PER_POSITION     133
#define             CRX_ASK_TORQUE_SENSOR_PULSE_PER_TORQUE     34
#define             CRX_SET_TORQUE_SENSOR_PULSE_PER_TORQUE     134
#define             CRX_ASK_PRES_SENSOR_PULSE_PER_PRES      35
#define             CRX_SET_PRES_SENSOR_PULSE_PER_PRES      135
#define             CRX_ASK_FRICTION                36
#define             CRX_SET_FRICTION                136
#define             CRX_ASK_VALVE_GAIN_PLUS         37
#define             CRX_SET_VALVE_GAIN_PLUS         137
#define             CRX_ASK_VALVE_GAIN_MINUS        38
#define             CRX_SET_VALVE_GAIN_MINUS        138
#define             CRX_LOW_REF                     139
#define             CRX_ASK_HOMEPOS_OFFSET          40
#define             CRX_SET_HOMEPOS_OFFSET          140
#define             CRX_ASK_HOMEPOS_VALVE_OPENING   41
#define             CRX_SET_HOMEPOS_VALVE_OPENING   141
#define             CRX_ASK_DDV_VALVE_DEADZONE     42
#define             CRX_SET_DDV_VALVE_DEADZONE     142
#define             CRX_ASK_VALVE_PWM_VS_VALVE_POS  43
#define             CRX_ASK_VALVE_POS_VS_FLOWRATE   44
#define             CRX_ASK_VALVE_POS_NUM           45
#define             CRX_SET_ERR_CLEAR               150
#define             CRX_JUMP_STATUS                 255

// CID_TX_INFO - TX INFO type

#define             CTX_SEND_INFO                               0
#define             CTX_SEND_BNO                                1
#define             CTX_SEND_OPERATING_MODE                     2
#define             CTX_SEND_CAN_FREQ                           6
#define             CTX_SEND_CONTROL_MODE                       7
#define             CTX_SEND_JOINT_ENC_DIR                      9
#define             CTX_SEND_VALVE_DIR                          10
#define             CTX_SEND_VALVE_ENC_DIR                      11
#define             CTX_SEND_VOLTAGE_SUPPLY                     12
#define             CTX_SEND_VOLTAGE_VALVE                      13
#define             CTX_SEND_PID_GAIN                           20
#define             CTX_SEND_VALVE_DEADZONE                     21
#define             CTX_SEND_VELOCITY_COMP_GAIN                 22
#define             CTX_SEND_COMPLIANCE_GAIN                    23
#define             CTX_SEND_VALVE_CNETER                       24
#define             CTX_SEND_VALVE_FF                           25
#define             CTX_SEND_BULK_MODULUS                       26
#define             CTX_SEND_CHAMBER_VOLUME                     27
#define             CTX_SEND_PISTON_AREA                        28
#define             CTX_SEND_PRES                               29
#define             CTX_SEND_ENC_LIMIT                          30
#define             CTX_SEND_STROKE                             31
#define             CTX_SEND_VALVE_LIMIT                        32
#define             CTX_SEND_ENC_PULSE_PER_POSITION             33
#define             CTX_SEND_TORQUE_SENSOR_PULSE_PER_TORQUE     34
#define             CTX_SEND_PRES_SENSOR_PULSE_PER_BAR          35
#define             CTX_SEND_FRICTION                           36
#define             CTX_SEND_VALVE_GAIN_PLUS                    37
#define             CTX_SEND_VALVE_GAIN_MINUS                   38
#define             CTX_SEND_REFENCE_MODE                       39
#define             CTX_SEND_HOMEPOS_OFFSET                     40
#define             CTX_SEND_HOMEPOS_VALVE_OPENING              41
#define             CTX_SEND_DDV_VALVE_DEADZONE                 42
#define             CTX_VALVE_PWM_VS_VALVE_POS                  43
#define             CTX_VALVE_POS_VS_FLOWRATE                   44
#define             CTX_VALVE_POS_NUM                           45

// Sensor & State Transmission
void CAN_TX_POSITION(int32_t t_pos, int32_t t_vel);
void CAN_TX_TORQUE(int16_t t_torque);
void CAN_TX_PRES(int16_t t_pres_a, int16_t t_pres_b);
void CAN_TX_PWM(int16_t t_pwm);
void CAN_TX_VALVE_POSITION(int16_t t_valve_pos);

// Information Transmission
void CAN_TX_INFO(void);
void CAN_TX_BNO(void);
void CAN_TX_OPERATING_MODE(void);
void CAN_TX_CAN_FREQ(void);
void CAN_TX_CONTROL_MODE(void);
void CAN_TX_JOINT_ENC_DIR(void);
void CAN_TX_VALVE_DIR(void);
void CAN_TX_VALVE_ENC_DIR(void);
void CAN_TX_VOLTAGE_SUPPLY(void);
void CAN_TX_VOLTAGE_VALVE(void);
void CAN_TX_PID_GAIN(int t_type);
void CAN_TX_VALVE_DEADZONE(void);
void CAN_TX_VELOCITY_COMP_GAIN(void);
void CAN_TX_COMPLIANCE_GAIN(void);
void CAN_TX_VALVE_FF(void);
void CAN_TX_BULK_MODULUS(void);
void CAN_TX_CHAMBER_VOLUME(void);
void CAN_TX_PISTON_AREA(void);
void CAN_TX_PRES_A_AND_B(void);
void CAN_TX_ENC_LIMIT(void);
void CAN_TX_STROKE(void);
void CAN_TX_VALVE_LIMIT(void);
void CAN_TX_ENC_PULSE_PER_POSITION(void);
void CAN_TX_TORQUE_SENSOR_PULSE_PER_TORQUE(void);
void CAN_TX_PRES_SENSOR_PULSE_PER_PRES(void);
void CAN_TX_FRICTION(void);
void CAN_TX_VALVE_GAIN_PLUS(void);
void CAN_TX_VALVE_GAIN_MINUS(void);
void CAN_TX_REFENCE_MODE(void);
void CAN_TX_HOMEPOS_OFFSET(void);
void CAN_TX_HOMPOS_VALVE_OPENING(void);
void CAN_TX_VALVE_PWM_VS_VALVE_POS(int8_t canindex);
void CAN_TX_DDV_VALVE_DEADZONE(void);
void CAN_TX_VALVE_POS_VS_FLOWRATE(int8_t canindex);
void CAN_TX_VALVE_POS_NUM(void);

class State 
{
    public:
        double sen;
        double ref;
        double ref_old;
        double ref_diff;
        double err;
        double err_int;
        double err_old;
        double err_diff;
        double err_sum;
    public:
        State(){
            sen = 0.0;
            ref = 0.0;
            ref_old = 0.0;
            ref_diff = 0.0;
            err = 0.0;
            err_int = 0.0;
            err_old = 0.0;
            err_diff = 0.0;
        }
};

extern State pos;
extern State vel;
extern State Vout;
extern State torq;
extern State pres_A;
extern State pres_B;
extern State cur;
extern State valve_pos;

extern State INIT_Vout;
extern State INIT_Valve_Pos;
extern State INIT_Pos;
extern State INIT_torq;

// CAN Receive Functions
void ReadCMD();
void CAN_RX_HANDLER();
void CAN_ID_INIT(void);

extern int ID_index_array[50];

#endif

