#include "function_CAN.h"
#include "setting.h"
#include "function_utilities.h"
#include "SPI_EEP_ENC.h"
#include "stm32f4xx_flash.h"
#include "FlashWriter.h"

// CAN ID Setting Variables
int CID_RX_CMD = 100;
int CID_RX_REF_POSITION = 200;
int CID_RX_REF_TORQUE = 300;
int CID_RX_REF_PRES_DIFF = 400;
int CID_RX_REF_VOUT = 500;
int CID_RX_REF_VALVE_POSITION = 600;
int CID_RX_REF_CURRENT = 700;

int CID_TX_INFO = 1100;
int CID_TX_POSITION = 1200;
int CID_TX_TORQUE = 1300;
int CID_TX_PRES = 1400;
int CID_TX_VOUT = 1500;
int CID_TX_VALVE_POSITION = 1600;

// variables
uint8_t can_index = 0;


/*******************************************************************************
 * CAN functions
 ******************************************************************************/
void CAN_ID_INIT(void) {

    CID_RX_CMD = (int) (BNO + INIT_CID_RX_CMD);
    CID_RX_REF_POSITION = (int) (BNO + INIT_CID_RX_REF_POSITION);
    CID_RX_REF_TORQUE = (int) (BNO + INIT_CID_RX_REF_TORQUE);
    CID_RX_REF_PRES_DIFF = (int) (BNO + INIT_CID_RX_REF_PRES_DIFF);
    CID_RX_REF_VOUT = (int) (BNO + INIT_CID_RX_REF_VOUT);
    CID_RX_REF_VALVE_POSITION = (int) (BNO + INIT_CID_RX_REF_VALVE_POSITION);
    CID_RX_REF_CURRENT = (int) (BNO + INIT_CID_RX_REF_CURRENT);

    CID_TX_INFO = (int) (BNO + INIT_CID_TX_INFO);
    CID_TX_POSITION = (int) (BNO + INIT_CID_TX_POSITION);
    CID_TX_TORQUE = (int) (BNO + INIT_CID_TX_TORQUE);
    CID_TX_PRES = (int) (BNO + INIT_CID_TX_PRES);
    CID_TX_VOUT = (int) (BNO + INIT_CID_TX_VOUT);
    CID_TX_VALVE_POSITION = (int) (BNO + INIT_CID_TX_VALVE_POSITION);
}

void ReadCMD(int8_t CMD)
{
    switch(CMD){
        case CRX_ASK_INFO: {
            CAN_TX_INFO();
            break;
        }
        case CRX_ASK_BNO: {
            CAN_TX_BNO();
            break;
        }
        case CRX_SET_BNO: {
            BNO = (int16_t) msg.data[1];
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_BNO, (int16_t) BNO);
            CAN_ID_INIT(); // can id init
            break;
        }
        case CRX_ASK_OPERATING_MODE: {
            CAN_TX_OPERATING_MODE();
            break;
        }
        case CRX_SET_OPERATING_MODE: {
            OPERATING_MODE = (int16_t) msg.data[1];
            
            ROM_RESET_DATA();
            

            break;
        }
        case CRX_SET_ENC_ZERO: {
            ENC_SET_ZERO();

            break;
        }
        case CRX_SET_FET_ON: {

            break;
        }

        case CRX_SET_REF_UPDATE_ENABLE: {
            flag_ref_enable = (int16_t) msg.data[1];

            break;
        }

        case CRX_ASK_CAN_FREQ: {
            CAN_TX_CAN_FREQ();

            break;
        }

        case CRX_SET_CAN_FREQ: {
            CAN_FREQ = (int16_t) (msg.data[1] | msg.data[2] << 8);
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_CAN_FREQ, (int16_t) CAN_FREQ);
            break;
        }

        case CRX_ASK_CONTROL_MODE: {
            CAN_TX_CONTROL_MODE();

            break;
        }

        case CRX_SET_CONTROL_MODE: {
            CONTROL_MODE = (int16_t) (msg.data[1]);
            if (CONTROL_MODE == 22) {    //MODE_FIND_HOME
                FLAG_FIND_HOME = true;
            }
            break;
        }

        case CRX_SET_DATA_REQUEST: {
            int request_type = msg.data[2];
            flag_data_request[request_type] = msg.data[1];
            //pc.printf("can middle %d\n", request_type);

//            if (flag_data_request[1] == HIGH) SPI_VREF_DAC_WRITE(PRES_A_VREF, PRES_B_VREF, TORQUE_VREF, 0); // set DAC
            //if (flag_data_request[1] == HIGH) dac_1 = PRES_A_VREF/3.3;
//            if (flag_data_request[2] == HIGH) SPI_VREF_DAC_WRITE(PRES_A_VREF, PRES_B_VREF, TORQUE_VREF, 0); // set DAC
            //if (flag_data_request[2] == HIGH) dac_2 = PRES_B_VREF/3.3;

            break;
        }

        case CRX_ASK_JOINT_ENC_DIR: {
            CAN_TX_JOINT_ENC_DIR();

            break;
        }

        case CRX_SET_JOINT_ENC_DIR: {
            DIR_JOINT_ENC = (int16_t) (msg.data[1] | msg.data[2] << 8);
            if (DIR_JOINT_ENC >= 0)
                DIR_JOINT_ENC = 1;
            else
                DIR_JOINT_ENC = -1;
                
            ROM_RESET_DATA();   
            
            //spi_eeprom_write(RID_JOINT_ENC_DIR, (int16_t) DIR_JOINT_ENC);

            break;
        }

        case CRX_ASK_VALVE_DIR: {
            CAN_TX_VALVE_DIR();

            break;
        }

        case CRX_SET_VALVE_DIR: {
            DIR_VALVE = (int16_t) (msg.data[1] | msg.data[2] << 8);
            if (DIR_VALVE >= 0)
                DIR_VALVE = 1;
            else
                DIR_VALVE = -1;
                
            ROM_RESET_DATA();    
            
            //spi_eeprom_write(RID_VALVE_DIR, (int16_t) DIR_VALVE);

            break;
        }

        case CRX_ASK_VALVE_ENC_DIR: {
            CAN_TX_VALVE_ENC_DIR();

            break;
        }

        case CRX_SET_VALVE_ENC_DIR: {
            DIR_VALVE_ENC = (int16_t) (msg.data[1] | msg.data[2] << 8);
            if (DIR_VALVE_ENC >= 0)
                DIR_VALVE_ENC = 1;
            else
                DIR_VALVE_ENC = -1;
                
            ROM_RESET_DATA();

            //spi_eeprom_write(RID_VALVE_ENC_DIR, (int16_t) DIR_VALVE_ENC);

            break;
        }

        case CRX_ASK_VOLTAGE_SUPPLY: {
            CAN_TX_VOLTAGE_SUPPLY();

            break;
        }

        case CRX_SET_VOLTAGE_SUPPLY: {
            SUPPLY_VOLTAGE = (double) ((int16_t) (msg.data[1] | msg.data[2] << 8)) / 10.;
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_VOLATGE_SUPPLY, (int16_t) (SUPPLY_VOLTAGE * 10.));

            break;
        }

        case CRX_ASK_VOLTAGE_VALVE: {
            CAN_TX_VOLTAGE_VALVE();

            break;
        }

        case CRX_SET_VOLTAGE_VALVE: {
            VALVE_VOLTAGE_LIMIT = (double) ((int16_t) (msg.data[1] | msg.data[2] << 8)) / 10.0;
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_VOLTAGE_VALVE, (int16_t) (VALVE_VOLTAGE_LIMIT * 10.));


            break;
        }

        case CRX_SET_HOMEPOS: {
            CONTROL_MODE = 22;
            SETTING_SWITCH = (int16_t) (msg.data[1]);
            break;
        }

        case CRX_ASK_PID_GAIN: {
            CAN_TX_PID_GAIN(msg.data[1]);

            break;
        }

        case CRX_SET_PID_GAIN: {
            if (msg.data[1] == 0) {
                P_GAIN_VALVE_POSITION = (int16_t) (msg.data[2] | msg.data[3] << 8);
                I_GAIN_VALVE_POSITION = (int16_t) (msg.data[4] | msg.data[5] << 8);
                D_GAIN_VALVE_POSITION = (int16_t) (msg.data[6] | msg.data[7] << 8);
                
                ROM_RESET_DATA();
                
                //spi_eeprom_write(RID_P_GAIN_VALVE_POSITION, (int16_t) P_GAIN_VALVE_POSITION);
                //spi_eeprom_write(RID_I_GAIN_VALVE_POSITION, (int16_t) I_GAIN_VALVE_POSITION);
                //spi_eeprom_write(RID_D_GAIN_VALVE_POSITION, (int16_t) D_GAIN_VALVE_POSITION);


            } else if (msg.data[1] == 1) {
                P_GAIN_JOINT_POSITION = (int16_t) (msg.data[2] | msg.data[3] << 8);
                I_GAIN_JOINT_POSITION = (int16_t) (msg.data[4] | msg.data[5] << 8);
                D_GAIN_JOINT_POSITION = (int16_t) (msg.data[6] | msg.data[7] << 8);
                
                ROM_RESET_DATA();

                //spi_eeprom_write(RID_P_GAIN_JOINT_POSITION, (int16_t) P_GAIN_JOINT_POSITION);
                //spi_eeprom_write(RID_I_GAIN_JOINT_POSITION, (int16_t) I_GAIN_JOINT_POSITION);
                //spi_eeprom_write(RID_D_GAIN_JOINT_POSITION, (int16_t) D_GAIN_JOINT_POSITION);
            } else if (msg.data[1] == 2) {
                P_GAIN_JOINT_TORQUE = (int16_t) (msg.data[2] | msg.data[3] << 8);
                I_GAIN_JOINT_TORQUE = (int16_t) (msg.data[4] | msg.data[5] << 8);
                D_GAIN_JOINT_TORQUE = (int16_t) (msg.data[6] | msg.data[7] << 8);
                
                ROM_RESET_DATA();
                
                //spi_eeprom_write(RID_P_GAIN_JOINT_TORQUE, (int16_t) P_GAIN_JOINT_TORQUE);
                //spi_eeprom_write(RID_I_GAIN_JOINT_TORQUE, (int16_t) I_GAIN_JOINT_TORQUE);
                //spi_eeprom_write(RID_D_GAIN_JOINT_TORQUE, (int16_t) D_GAIN_JOINT_TORQUE);
            }

            break;
        }

        case CRX_ASK_VALVE_DEADZONE: {
            CAN_TX_VALVE_DEADZONE();

            break;
        }

        case CRX_SET_VALVE_DEADZONE: {
            VALVE_CENTER = (int16_t) (msg.data[1] | msg.data[2] << 8);
            VALVE_DEADZONE_PLUS = (int16_t) (msg.data[3] | msg.data[4] << 8);
            VALVE_DEADZONE_MINUS = (int16_t) (msg.data[5] | msg.data[6] << 8);
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_VALVE_CNETER, (int16_t) (VALVE_CENTER));
            //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, (int16_t) (VALVE_DEADZONE_PLUS));
            //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, (int16_t) (VALVE_DEADZONE_MINUS));

            break;
        }

        case CRX_ASK_VELOCITY_COMP_GAIN: {
            CAN_TX_VELOCITY_COMP_GAIN();

            break;
        }

        case CRX_SET_VELOCITY_COMP_GAIN: {
            VELOCITY_COMP_GAIN = (int16_t) (msg.data[1] | msg.data[2] << 8);
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_VELOCITY_COMP_GAIN, (int16_t) VELOCITY_COMP_GAIN);

            break;
        }

        case CRX_ASK_COMPLIANCE_GAIN: {
            CAN_TX_COMPLIANCE_GAIN();

            break;
        }

        case CRX_SET_COMPLIANCE_GAIN: {
            COMPLIANCE_GAIN = (int16_t) (msg.data[1] | msg.data[2] << 8);

            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_COMPLIANCE_GAIN, (int16_t) COMPLIANCE_GAIN);

            break;
        }

        case CRX_ASK_VALVE_FF: {
            CAN_TX_VALVE_FF();

            break;
        }

        case CRX_SET_VALVE_FF: {
            VALVE_FF = (int16_t) (msg.data[1] | msg.data[2] << 8);
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_VALVE_FF, (int16_t) VALVE_FF);

            break;
        }

        case CRX_ASK_BULK_MODULUS: {
            CAN_TX_BULK_MODULUS();

            break;
        }

        case CRX_SET_BULK_MODULUS: {
            BULK_MODULUS = (int16_t) (msg.data[1] | msg.data[2] << 8);
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_BULK_MODULUS, (int16_t) BULK_MODULUS);

            break;
        }

        case CRX_ASK_CHAMBER_VOLUME: {
            CAN_TX_CHAMBER_VOLUME();

            break;
        }

        case CRX_SET_CHAMBER_VOLUME: {
            CHAMBER_VOLUME_A = (int16_t) (msg.data[1] | msg.data[2] << 8);
            CHAMBER_VOLUME_B = (int16_t) (msg.data[3] | msg.data[4] << 8);

            ROM_RESET_DATA();
    
            //spi_eeprom_write(RID_CHAMBER_VOLUME_A, (int16_t) CHAMBER_VOLUME_A);
            //spi_eeprom_write(RID_CHAMBER_VOLUME_B, (int16_t) CHAMBER_VOLUME_B);

            break;
        }

        case CRX_ASK_PISTON_AREA: {
            CAN_TX_PISTON_AREA();

            break;
        }

        case CRX_SET_PISTON_AREA: {
            PISTON_AREA_A = (int16_t) (msg.data[1] | msg.data[2] << 8);
            PISTON_AREA_B = (int16_t) (msg.data[3] | msg.data[4] << 8);
            PISTON_AREA_alpha = (double)PISTON_AREA_B/(double)PISTON_AREA_A;
            
            ROM_RESET_DATA();
            
            //spi_eeprom_write(RID_PISTON_AREA_A, (int16_t) PISTON_AREA_A);
            //spi_eeprom_write(RID_PISTON_AREA_B, (int16_t) PISTON_AREA_B);
            break;
        }

        case CRX_ASK_PRES: {
            CAN_TX_PRES_A_AND_B();
//            SPI_VREF_DAC_WRITE(PRES_A_VREF, PRES_B_VREF, TORQUE_VREF, 0);
            //dac_1 = PRES_A_VREF;
            //dac_2 = PRES_B_VREF;
            
            break;
        }

        case CRX_SET_PRES: {
            PRES_SUPPLY = (int16_t) (msg.data[1] | msg.data[2] << 8);
            PRES_RETURN = (int16_t) (msg.data[3] | msg.data[4] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_PRES_SUPPLY, (int16_t) PRES_SUPPLY);
            //spi_eeprom_write(RID_PRES_RETURN, (int16_t) PRES_RETURN);


            break;
        }

        case CRX_ASK_ENC_LIMIT: {
            CAN_TX_ENC_LIMIT();

            break;
        }

        case CRX_SET_ENC_LIMIT: {
            ENC_LIMIT_MINUS = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ENC_LIMIT_PLUS = (int16_t) (msg.data[3] | msg.data[4] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_ENC_LIMIT_MINUS, (int16_t) ENC_LIMIT_MINUS);
            //spi_eeprom_write(RID_ENC_LIMIT_PLUS, (int16_t) ENC_LIMIT_PLUS);

            break;
        }

        case CRX_ASK_STROKE: {
            CAN_TX_STROKE();
            break;
        }

        case CRX_SET_STROKE: {
            STROKE = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_STROKE, (int16_t) STROKE);

            break;
        }

        case CRX_ASK_VALVE_LIMIT: {
            CAN_TX_VALVE_LIMIT();

            break;
        }

        case CRX_SET_VALVE_LIMIT: {
            VALVE_LIMIT_MINUS = (int16_t) (msg.data[1] | msg.data[2] << 8);
            VALVE_LIMIT_PLUS = (int16_t) (msg.data[3] | msg.data[4] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_VALVE_LIMIT_MINUS, (int16_t) VALVE_LIMIT_MINUS);
            //spi_eeprom_write(RID_VALVE_LIMIT_PLUS, (int16_t) VALVE_LIMIT_PLUS);

            break;
        }

        case CRX_ASK_ENC_PULSE_PER_POSITION: {
            CAN_TX_ENC_PULSE_PER_POSITION();

            break;
        }

        case CRX_SET_ENC_PULSE_PER_POSITION: {
            ENC_PULSE_PER_POSITION = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_ENC_PULSE_PER_POSITION, (int16_t) ENC_PULSE_PER_POSITION);

            break;
        }

        case CRX_ASK_TORQUE_SENSOR_PULSE_PER_TORQUE: {
            CAN_TX_TORQUE_SENSOR_PULSE_PER_TORQUE();

            break;
        }

        case CRX_SET_TORQUE_SENSOR_PULSE_PER_TORQUE: {
            TORQUE_SENSOR_PULSE_PER_TORQUE = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_TORQUE_SENSOR_PULSE_PER_TORQUE, (int16_t) TORQUE_SENSOR_PULSE_PER_TORQUE);

            break;
        }

        case CRX_ASK_PRES_SENSOR_PULSE_PER_PRES: {
            CAN_TX_PRES_SENSOR_PULSE_PER_PRES();

            break;
        }

        case CRX_SET_PRES_SENSOR_PULSE_PER_PRES: {
            PRES_SENSOR_A_PULSE_PER_BAR = (double) ((int16_t) (msg.data[1] | msg.data[2] << 8)) * 0.01;
            PRES_SENSOR_B_PULSE_PER_BAR = (double) ((int16_t) (msg.data[3] | msg.data[4] << 8)) * 0.01;
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_PRES_SENSOR_A_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_A_PULSE_PER_BAR * 100.));
            //(RID_PRES_SENSOR_B_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_B_PULSE_PER_BAR * 100.));

            break;
        }

        case CRX_ASK_FRICTION: {
            CAN_TX_FRICTION();

            break;
        }

        case CRX_SET_FRICTION: {
            FRICTION = (double) ((int16_t) (msg.data[1] | msg.data[2] << 8)) / 10.;
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_FRICTION, (int16_t) (FRICTION * 10.));

            break;
        }

        case CRX_ASK_VALVE_GAIN_PLUS: {
            CAN_TX_VALVE_GAIN_PLUS();

            break;
        }
        case CRX_SET_VALVE_GAIN_PLUS: {
            VALVE_GAIN_LPM_PER_V[0] = (double) msg.data[1] / 50.0;
            VALVE_GAIN_LPM_PER_V[2] = (double) msg.data[2] / 50.0;
            VALVE_GAIN_LPM_PER_V[4] = (double) msg.data[3] / 50.0;
            VALVE_GAIN_LPM_PER_V[6] = (double) msg.data[4] / 50.0;
            VALVE_GAIN_LPM_PER_V[8] = (double) msg.data[5] / 50.0;
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_VALVE_GAIN_PLUS_1, (int16_t) (VALVE_GAIN_LPM_PER_V[0] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_PLUS_2, (int16_t) (VALVE_GAIN_LPM_PER_V[2] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_PLUS_3, (int16_t) (VALVE_GAIN_LPM_PER_V[4] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_PLUS_4, (int16_t) (VALVE_GAIN_LPM_PER_V[6] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_PLUS_5, (int16_t) (VALVE_GAIN_LPM_PER_V[8] * 100.));

            break;
        }

        case CRX_ASK_VALVE_GAIN_MINUS: {
            CAN_TX_VALVE_GAIN_MINUS();

            break;
        }
        case CRX_SET_VALVE_GAIN_MINUS: {
            VALVE_GAIN_LPM_PER_V[1] = (double) msg.data[1] / 50.0;
            VALVE_GAIN_LPM_PER_V[3] = (double) msg.data[2] / 50.0;
            VALVE_GAIN_LPM_PER_V[5] = (double) msg.data[3] / 50.0;
            VALVE_GAIN_LPM_PER_V[7] = (double) msg.data[4] / 50.0;
            VALVE_GAIN_LPM_PER_V[9] = (double) msg.data[5] / 50.0;
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_VALVE_GAIN_MINUS_1, (int16_t) (VALVE_GAIN_LPM_PER_V[1] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_MINUS_2, (int16_t) (VALVE_GAIN_LPM_PER_V[3] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_MINUS_3, (int16_t) (VALVE_GAIN_LPM_PER_V[5] * 100.));
            //spi_eeprom_write(RID_VALVE_GAIN_MINUS_4, (int16_t) (VALVE_GAIN_LPM_PER_V[7] * 100.));
            //(RID_VALVE_GAIN_MINUS_5, (int16_t) (VALVE_GAIN_LPM_PER_V[9] * 100.));

            break;
        }
        case CRX_ASK_DDV_VALVE_DEADZONE: {
            CAN_TX_DDV_VALVE_DEADZONE();
            break;
        }

        case CRX_LOW_REF: {
            REFERENCE_MODE = msg.data[1];

            REF_NUM = msg.data[2];
            REF_PERIOD = (double) ((int16_t) (msg.data[3] | msg.data[4] << 8)) / 100.;
            if (REF_PERIOD <= 0.) REF_MOVE_TIME_5k = TMR_FREQ_5k / CAN_FREQ;
            else REF_MOVE_TIME_5k = (int) (REF_PERIOD * (double) TMR_FREQ_5k);
            REF_MAG = (double) ((int16_t) (msg.data[5] | msg.data[6] << 8)) / 100.;

            break;
        }

        case CRX_JUMP_STATUS: {
            MODE_JUMP_STATUS = msg.data[1];

            break;
        }

        case CRX_SET_ERR_CLEAR: {

            for (int i = 0; i < num_err; i++) {
                flag_err[i] = FALSE;
                flag_err_old[i] = FALSE;
            }

            flag_err_rt = FALSE;


            break;
        }

        case CRX_ASK_HOMEPOS_OFFSET: {
            CAN_TX_HOMEPOS_OFFSET();
            break;
        }
        case CRX_SET_HOMEPOS_OFFSET: {
            HOMEPOS_OFFSET = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_HOMEPOS_OFFSET, (int16_t) HOMEPOS_OFFSET);
            break;
        }

        case CRX_ASK_HOMEPOS_VALVE_OPENING: {
            CAN_TX_HOMPOS_VALVE_OPENING();
            break;
        }
        case CRX_SET_HOMEPOS_VALVE_OPENING: {
            HOMEPOS_VALVE_OPENING = (int16_t) (msg.data[1] | msg.data[2] << 8);
            ROM_RESET_DATA();
            //spi_eeprom_write(RID_HOMEPOS_VALVE_OPENING, (int16_t) HOMEPOS_VALVE_OPENING);
            break;
        }

        case CRX_ASK_VALVE_PWM_VS_VALVE_POS: {
            can_index = (int16_t) msg.data[1];
            CAN_TX_VALVE_PWM_VS_VALVE_POS(can_index);
            break;
        }
        case CRX_ASK_VALVE_POS_VS_FLOWRATE: {
            can_index = (int16_t) msg.data[1];
            CAN_TX_VALVE_POS_VS_FLOWRATE(can_index);
            break;
        }
        case CRX_ASK_VALVE_POS_NUM: {
            CAN_TX_VALVE_POS_NUM();
            break;
        }
    default:
        break;
    }
}

void CAN_RX_HANDLER()
{
    
    //pc.printf("can received");
    can.read(msg);
//    can.read(msg, h1);
//    can.read(msg, h2);
//    can.read(msg, h3);
//    can.read(msg, h4);
//    can.read(msg, h5);
//    can.read(msg, h6);
    unsigned int address = msg.id;
    //pc.printf("add %d\n",address);
    //pc.printf("cmd %d\n", CID_RX_CMD);
    if(address==CID_RX_CMD){
        unsigned int CMD = msg.data[0];
        ReadCMD(CMD);
        //pc.printf("cmd %d\n ",CMD);
    } else if(address==CID_RX_REF_POSITION) {
        int32_t temp_pos = (int32_t) (msg.data[0] | msg.data[1] << 8 | msg.data[2] << 16 | msg.data[3] << 24);
        int32_t temp_vel = (int32_t) (msg.data[4] | msg.data[5] << 8 | msg.data[6] << 16 | msg.data[7] << 24);
        pos.ref = (double)temp_pos;
        vel.ref = (double)temp_vel;
    } else if(address==CID_RX_REF_TORQUE) {
        int16_t temp_torq = (int16_t) (msg.data[0] | msg.data[1] << 8);
        torq.ref = (double)temp_torq;
    } else if(address==CID_RX_REF_PRES_DIFF) {
        int16_t temp_presdiff = (int16_t) (msg.data[0] | msg.data[1] << 8);
        torq.ref = (double)temp_presdiff;   
    } else if(address==CID_RX_REF_VOUT) {
        int16_t temp_PWM = (int16_t) (msg.data[0] | msg.data[1] << 8);
        Vout.ref = (double)temp_PWM;   
    } else if(address==CID_RX_REF_VALVE_POSITION) {
        int16_t temp_valve_pos = (int16_t) (msg.data[0] | msg.data[1] << 8);
        valve_pos.ref = (double)temp_valve_pos; 
    } else if(address==CID_RX_REF_CURRENT) {
        int16_t temp_cur = (int16_t) (msg.data[0] | msg.data[1] << 8);
        cur.ref = (double)temp_cur; 
    }
        
}

/******************************************************************************
 Information Transmission Functions
*******************************************************************************/

void CAN_TX_INFO(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 7;
    temp_msg.data[0] = (uint8_t) CTX_SEND_INFO;
    temp_msg.data[1] = (uint8_t) BNO;
    temp_msg.data[2] = (uint8_t) CAN_FREQ;
    temp_msg.data[3] = (uint8_t) (CAN_FREQ >> 8);
    temp_msg.data[4] = (uint8_t) (flag_err[7] << 7 | flag_err[6] << 6 | flag_err[5] << 5 | flag_err[4] << 4 | flag_err[3] << 3 | flag_err[2] << 2 | flag_err[1] << 1 | flag_err[0]);
    temp_msg.data[5] = (uint8_t) CONTROL_MODE;
    temp_msg.data[6] = (uint8_t) OPERATING_MODE;

    can.write(temp_msg);
}

void CAN_TX_BNO(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 2;
    temp_msg.data[0] = (uint8_t) CTX_SEND_BNO;
    temp_msg.data[1] = (uint8_t) BNO;

    can.write(temp_msg);
}

void CAN_TX_OPERATING_MODE(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 2;
    temp_msg.data[0] = (uint8_t) CTX_SEND_OPERATING_MODE;
    temp_msg.data[1] = (uint8_t) OPERATING_MODE;

    can.write(temp_msg);
}

void CAN_TX_CAN_FREQ(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_CAN_FREQ;
    temp_msg.data[1] = (uint8_t) CAN_FREQ;
    temp_msg.data[2] = (uint8_t) (CAN_FREQ >> 8);

    can.write(temp_msg);
}

void CAN_TX_CONTROL_MODE(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 2;
    temp_msg.data[0] = (uint8_t) CTX_SEND_CONTROL_MODE;
    temp_msg.data[1] = (uint8_t) CONTROL_MODE;

    can.write(temp_msg);
}

void CAN_TX_JOINT_ENC_DIR(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_JOINT_ENC_DIR;
    temp_msg.data[1] = (uint8_t) DIR_JOINT_ENC;
    temp_msg.data[2] = (uint8_t) (DIR_JOINT_ENC >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_DIR(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_DIR;
    temp_msg.data[1] = (uint8_t) DIR_VALVE;
    temp_msg.data[2] = (uint8_t) (DIR_VALVE >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_ENC_DIR(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_ENC_DIR;
    temp_msg.data[1] = (uint8_t) DIR_VALVE_ENC;
    temp_msg.data[2] = (uint8_t) (DIR_VALVE_ENC >> 8);

    can.write(temp_msg);
}

void CAN_TX_VOLTAGE_SUPPLY(void) {
    int16_t send_voltage_supply = (int16_t) (SUPPLY_VOLTAGE * 10);

    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VOLTAGE_SUPPLY;
    temp_msg.data[1] = (uint8_t) (send_voltage_supply);
    temp_msg.data[2] = (uint8_t) (send_voltage_supply >> 8);

    can.write(temp_msg);
}

void CAN_TX_VOLTAGE_VALVE(void) {
    int16_t send_voltage_valve = (int16_t) (VALVE_VOLTAGE_LIMIT * 10);

    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VOLTAGE_VALVE;
    temp_msg.data[1] = (uint8_t) send_voltage_valve;
    temp_msg.data[2] = (uint8_t) (send_voltage_valve >> 8);

    can.write(temp_msg);
}


void CAN_TX_PID_GAIN(int t_type) {
    // t_type = 0 : valve position control gain
    // t_type = 1 : joint position control gain
    // t_type = 2 : joint torque control gain

    int16_t sendPgain=0, sendIgain=0, sendDgain=0;
    if (t_type == 0) {
//        sendPgain = (int16_t) (P_GAIN_VALVE_POSITION);
//        sendIgain = (int16_t) (I_GAIN_VALVE_POSITION);
//        sendDgain = (int16_t) (D_GAIN_VALVE_POSITION);
    } else if (t_type == 1) {
        sendPgain = (int16_t) (P_GAIN_JOINT_POSITION);
        sendIgain = (int16_t) (I_GAIN_JOINT_POSITION);
        sendDgain = (int16_t) (D_GAIN_JOINT_POSITION);
    } else if (t_type == 2) {
        sendPgain = (int16_t) (P_GAIN_JOINT_TORQUE);
        sendIgain = (int16_t) (I_GAIN_JOINT_TORQUE);
        sendDgain = (int16_t) (D_GAIN_JOINT_TORQUE);
    }

    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 8;
    temp_msg.data[0] = (uint8_t) CTX_SEND_PID_GAIN;
    temp_msg.data[1] = (uint8_t) t_type;
    temp_msg.data[2] = (uint8_t) sendPgain;
    temp_msg.data[3] = (uint8_t) (sendPgain >> 8);
    temp_msg.data[4] = (uint8_t) sendIgain;
    temp_msg.data[5] = (uint8_t) (sendIgain >> 8);
    temp_msg.data[6] = (uint8_t) sendDgain;
    temp_msg.data[7] = (uint8_t) (sendDgain >> 8);

    can.write(temp_msg);
}


void CAN_TX_VALVE_DEADZONE(void) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 7;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_DEADZONE;
    temp_msg.data[1] = (uint8_t) (int) (VALVE_CENTER);
    temp_msg.data[2] = (uint8_t) ((int) (VALVE_CENTER) >> 8);
    temp_msg.data[3] = (uint8_t) (int) (VALVE_DEADZONE_PLUS);
    temp_msg.data[4] = (uint8_t) ((int) (VALVE_DEADZONE_PLUS) >> 8);
    temp_msg.data[5] = (uint8_t) (int) (VALVE_DEADZONE_MINUS);
    temp_msg.data[6] = (uint8_t) ((int) (VALVE_DEADZONE_MINUS) >> 8);

    can.write(temp_msg);
}

void CAN_TX_VELOCITY_COMP_GAIN(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VELOCITY_COMP_GAIN;
    temp_msg.data[1] = (uint8_t) VELOCITY_COMP_GAIN;
    temp_msg.data[2] = (uint8_t) (VELOCITY_COMP_GAIN >> 8);

    can.write(temp_msg);
}

void CAN_TX_COMPLIANCE_GAIN(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_COMPLIANCE_GAIN;
    temp_msg.data[1] = (uint8_t) COMPLIANCE_GAIN;
    temp_msg.data[2] = (uint8_t) (COMPLIANCE_GAIN >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_FF(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_FF;
    temp_msg.data[1] = (uint8_t) VALVE_FF;
    temp_msg.data[2] = (uint8_t) (VALVE_FF >> 8);

    can.write(temp_msg);
}

void CAN_TX_BULK_MODULUS(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_BULK_MODULUS;
    temp_msg.data[1] = (uint8_t) BULK_MODULUS;
    temp_msg.data[2] = (uint8_t) (BULK_MODULUS >> 8);

    can.write(temp_msg);
}

void CAN_TX_CHAMBER_VOLUME(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_CHAMBER_VOLUME;
    temp_msg.data[1] = (uint8_t) CHAMBER_VOLUME_A;
    temp_msg.data[2] = (uint8_t) (CHAMBER_VOLUME_A >> 8);
    temp_msg.data[3] = (uint8_t) CHAMBER_VOLUME_B;
    temp_msg.data[4] = (uint8_t) (CHAMBER_VOLUME_B >> 8);

    can.write(temp_msg);
}

void CAN_TX_PISTON_AREA(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_PISTON_AREA;
    temp_msg.data[1] = (uint8_t) PISTON_AREA_A;
    temp_msg.data[2] = (uint8_t) (PISTON_AREA_A >> 8);
    temp_msg.data[3] = (uint8_t) PISTON_AREA_B;
    temp_msg.data[4] = (uint8_t) (PISTON_AREA_B >> 8);

    can.write(temp_msg);
}

void CAN_TX_PRES_A_AND_B(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_PRES;
    temp_msg.data[1] = (uint8_t) PRES_SUPPLY;
    temp_msg.data[2] = (uint8_t) (PRES_SUPPLY >> 8);
    temp_msg.data[3] = (uint8_t) PRES_RETURN;
    temp_msg.data[4] = (uint8_t) (PRES_RETURN >> 8);

    can.write(temp_msg);
}

void CAN_TX_ENC_LIMIT(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_ENC_LIMIT;
    temp_msg.data[1] = (uint8_t) ENC_LIMIT_MINUS;
    temp_msg.data[2] = (uint8_t) (ENC_LIMIT_MINUS >> 8);
    temp_msg.data[3] = (uint8_t) ENC_LIMIT_PLUS;
    temp_msg.data[4] = (uint8_t) (ENC_LIMIT_PLUS >> 8);

    can.write(temp_msg);
}

void CAN_TX_STROKE(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_STROKE;
    temp_msg.data[1] = (uint8_t) STROKE;
    temp_msg.data[2] = (uint8_t) (STROKE >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_LIMIT(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_LIMIT;
    temp_msg.data[1] = (uint8_t) VALVE_LIMIT_MINUS;
    temp_msg.data[2] = (uint8_t) (VALVE_LIMIT_MINUS >> 8);
    temp_msg.data[3] = (uint8_t) VALVE_LIMIT_PLUS;
    temp_msg.data[4] = (uint8_t) (VALVE_LIMIT_PLUS >> 8);

    can.write(temp_msg);
}

void CAN_TX_ENC_PULSE_PER_POSITION(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_ENC_PULSE_PER_POSITION;
    temp_msg.data[1] = (uint8_t) ENC_PULSE_PER_POSITION;
    temp_msg.data[2] = (uint8_t) (ENC_PULSE_PER_POSITION >> 8);

    can.write(temp_msg);
}

void CAN_TX_TORQUE_SENSOR_PULSE_PER_TORQUE(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_TORQUE_SENSOR_PULSE_PER_TORQUE;
    temp_msg.data[1] = (uint8_t) TORQUE_SENSOR_PULSE_PER_TORQUE;
    temp_msg.data[2] = (uint8_t) (TORQUE_SENSOR_PULSE_PER_TORQUE >> 8);

    can.write(temp_msg);
}

void CAN_TX_PRES_SENSOR_PULSE_PER_PRES(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_SEND_PRES_SENSOR_PULSE_PER_BAR;
    temp_msg.data[1] = (uint8_t) (int) (PRES_SENSOR_A_PULSE_PER_BAR * 100.);
    temp_msg.data[2] = (uint8_t) ((int) (PRES_SENSOR_A_PULSE_PER_BAR * 100.) >> 8);
    temp_msg.data[3] = (uint8_t) (int) (PRES_SENSOR_B_PULSE_PER_BAR * 100.);
    temp_msg.data[4] = (uint8_t) ((int) (PRES_SENSOR_B_PULSE_PER_BAR * 100.) >> 8);

    can.write(temp_msg);
}

void CAN_TX_FRICTION(void) {
    CANMessage temp_msg;
    int16_t send_friction;
    send_friction = (int16_t) (FRICTION * 10.);
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_FRICTION;
    temp_msg.data[1] = (uint8_t) send_friction;
    temp_msg.data[2] = (uint8_t) (send_friction >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_GAIN_PLUS(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 6;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_GAIN_PLUS;
    temp_msg.data[1] = (uint8_t) (VALVE_GAIN_LPM_PER_V[0] * 50.);
    temp_msg.data[2] = (uint8_t) (VALVE_GAIN_LPM_PER_V[2] * 50.);
    temp_msg.data[3] = (uint8_t) (VALVE_GAIN_LPM_PER_V[4] * 50.);
    temp_msg.data[4] = (uint8_t) (VALVE_GAIN_LPM_PER_V[6] * 50.);
    temp_msg.data[5] = (uint8_t) (VALVE_GAIN_LPM_PER_V[8] * 50.);

    can.write(temp_msg);
}

void CAN_TX_DDV_VALVE_DEADZONE(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 7;
    temp_msg.data[0] = (uint8_t) CTX_SEND_DDV_VALVE_DEADZONE;
    temp_msg.data[1] = (uint8_t) VALVE_DEADZONE_MINUS;
    temp_msg.data[2] = (uint8_t) ((int) (VALVE_DEADZONE_MINUS) >> 8);
    temp_msg.data[3] = (uint8_t) (VALVE_DEADZONE_PLUS);
    temp_msg.data[4] = (uint8_t) ((int) (VALVE_DEADZONE_PLUS) >> 8);
    temp_msg.data[5] = (uint8_t) (DDV_CENTER);
    temp_msg.data[6] = (uint8_t) ((int) (DDV_CENTER) >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_GAIN_MINUS(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 6;
    temp_msg.data[0] = (uint8_t) CTX_SEND_VALVE_GAIN_MINUS;
    temp_msg.data[1] = (uint8_t) (VALVE_GAIN_LPM_PER_V[1] * 50.);
    temp_msg.data[2] = (uint8_t) (VALVE_GAIN_LPM_PER_V[3] * 50.);
    temp_msg.data[3] = (uint8_t) (VALVE_GAIN_LPM_PER_V[5] * 50.);
    temp_msg.data[4] = (uint8_t) (VALVE_GAIN_LPM_PER_V[7] * 50.);
    temp_msg.data[5] = (uint8_t) (VALVE_GAIN_LPM_PER_V[9] * 50.);

    can.write(temp_msg);
}

void CAN_TX_REFENCE_MODE(void) {
    CANMessage temp_msg;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 6;
    temp_msg.data[0] = (uint8_t) CTX_SEND_REFENCE_MODE;
    temp_msg.data[1] = (uint8_t) REFERENCE_MODE;
    temp_msg.data[2] = (uint8_t) (int) (REFERENCE_FREQ * 100.);
    temp_msg.data[3] = (uint8_t) ((int) (REFERENCE_FREQ * 100.) >> 8);
    temp_msg.data[4] = (uint8_t) (int) (REFERENCE_MAG * 100.);
    temp_msg.data[5] = (uint8_t) ((int) (REFERENCE_MAG * 100.) >> 8);

    can.write(temp_msg);
}

void CAN_TX_HOMEPOS_OFFSET(void) {
    CANMessage temp_msg;
    int16_t send_homepos_offset;
    send_homepos_offset = (int16_t) (HOMEPOS_OFFSET);
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_HOMEPOS_OFFSET;
    temp_msg.data[1] = (uint8_t) send_homepos_offset;
    temp_msg.data[2] = (uint8_t) (send_homepos_offset >> 8);

    can.write(temp_msg);
}

void CAN_TX_HOMPOS_VALVE_OPENING(void) {
    CANMessage temp_msg;
    int16_t send_homepos_valve_opening;
    send_homepos_valve_opening = (int16_t) (HOMEPOS_VALVE_OPENING);
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_SEND_HOMEPOS_VALVE_OPENING;
    temp_msg.data[1] = (uint8_t) send_homepos_valve_opening;
    temp_msg.data[2] = (uint8_t) (send_homepos_valve_opening >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_PWM_VS_VALVE_POS(int8_t canindex) {
    CANMessage temp_msg;
    int16_t valve_pos_vs_pwm;
    valve_pos_vs_pwm = (int16_t) (VALVE_POS_VS_PWM[canindex]);
    
    int16_t PWM_VALVE_ID;
    PWM_VALVE_ID = ID_index_array[canindex] * 1000;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 5;
    temp_msg.data[0] = (uint8_t) CTX_VALVE_PWM_VS_VALVE_POS;
    temp_msg.data[1] = (uint8_t) PWM_VALVE_ID;
    temp_msg.data[2] = (uint8_t) (PWM_VALVE_ID >> 8);
    temp_msg.data[3] = (uint8_t) valve_pos_vs_pwm;
    temp_msg.data[4] = (uint8_t) (valve_pos_vs_pwm >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_POS_VS_FLOWRATE(int8_t canindex) {
    CANMessage temp_msg;
    int32_t valve_pos_vs_flowrate;
    valve_pos_vs_flowrate = (int32_t) (JOINT_VEL[canindex]);

    int16_t VALVE_POS_VALVE_ID = ID_index_array[canindex] * 10 + DDV_CENTER;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 7;
    temp_msg.data[0] = (uint8_t) CTX_VALVE_POS_VS_FLOWRATE;
    temp_msg.data[1] = (uint8_t) VALVE_POS_VALVE_ID;
    temp_msg.data[2] = (uint8_t) (VALVE_POS_VALVE_ID >> 8);
    temp_msg.data[3] = (uint8_t) valve_pos_vs_flowrate;
    temp_msg.data[4] = (uint8_t) (valve_pos_vs_flowrate >> 8);
    temp_msg.data[5] = (uint8_t) (valve_pos_vs_flowrate >> 16);
    temp_msg.data[6] = (uint8_t) (valve_pos_vs_flowrate >> 24);

    can.write(temp_msg);
}

void CAN_TX_VALVE_POS_NUM(void) {
    CANMessage temp_msg;
    int32_t valve_pos_num;
    valve_pos_num = (int16_t) VALVE_POS_NUM;
    
    temp_msg.id = CID_TX_INFO;
    temp_msg.len = 3;
    temp_msg.data[0] = (uint8_t) CTX_VALVE_POS_NUM;
    temp_msg.data[1] = (uint8_t) valve_pos_num;
    temp_msg.data[2] = (uint8_t) (valve_pos_num >> 8);

    can.write(temp_msg);
}

/******************************************************************************
 Sensor & State Transmission Functions
*******************************************************************************/

void CAN_TX_POSITION(int32_t t_pos, int32_t t_vel) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_POSITION;
    temp_msg.len = 8;
    temp_msg.data[0] = (uint8_t) t_pos;
    temp_msg.data[1] = (uint8_t) (t_pos >> 8);
    temp_msg.data[2] = (uint8_t) (t_pos >> 16);
    temp_msg.data[3] = (uint8_t) (t_pos >> 24);
    temp_msg.data[4] = (uint8_t) t_vel;
    temp_msg.data[5] = (uint8_t) (t_vel >> 8);
    temp_msg.data[6] = (uint8_t) (t_vel >> 16);
    temp_msg.data[7] = (uint8_t) (t_vel >> 24);

    can.write(temp_msg);
}

void CAN_TX_TORQUE(int16_t t_torque) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_TORQUE;
    temp_msg.len = 2;
    temp_msg.data[0] = (uint8_t) t_torque;
    temp_msg.data[1] = (uint8_t) (t_torque >> 8);

    can.write(temp_msg);
}

void CAN_TX_PRES(int16_t t_pres_a, int16_t t_pres_b) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_PRES;
    temp_msg.len = 8;
    temp_msg.data[0] = (uint8_t) t_pres_a;
    temp_msg.data[1] = (uint8_t) (t_pres_a >> 8);
    temp_msg.data[2] = (uint8_t) t_pres_b;
    temp_msg.data[3] = (uint8_t) (t_pres_b >> 8);

    can.write(temp_msg);
}

void CAN_TX_PWM(int16_t t_pwm) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_POSITION;
    temp_msg.len = 8;
    temp_msg.data[0] = (uint8_t) t_pwm;
    temp_msg.data[1] = (uint8_t) (t_pwm >> 8);

    can.write(temp_msg);
}

void CAN_TX_VALVE_POSITION(int16_t t_valve_pos) {
    CANMessage temp_msg;

    temp_msg.id = CID_TX_VALVE_POSITION;
    temp_msg.len = 8;
    temp_msg.data[0] = (uint8_t) t_valve_pos;
    temp_msg.data[1] = (uint8_t) (t_valve_pos >> 8);

    can.write(temp_msg);
}


