#ifndef EIGEN_JACOBI_MODULE_H
#define EIGEN_JACOBI_MODULE_H

#include "Core.h"

#include "src/Core/util/DisableStupidWarnings.h"

/** \defgroup Jacobi_Module Jacobi module
  * This module provides Jacobi and Givens rotations.
  *
  * \code
  * #include <Eigen/Jacobi>
  * \endcode
  *
  * In addition to listed classes, it defines the two following MatrixBase methods to apply a Jacobi or Givens rotation:
  *  - MatrixBase::applyOnTheLeft()
  *  - MatrixBase::applyOnTheRight().
  */

#include "src/Jacobi/Jacobi.h"

#include "src/Core/util/ReenableStupidWarnings.h"

#endif // EIGEN_JACOBI_MODULE_H
/* vim: set filetype=cpp et sw=2 ts=2 ai: */
