#include "mbed.h"
#include "hmac_md5.h"
#include <stdio.h>
#include <string.h>

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

DigitalIn pb(p20);
Serial rf(p9,p10);


int main() {
    pb.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    
    rf.baud(1200);
    int old_pb=0;
    int new_pb;
    
    /*const char * key = "Dhruvin";
    const char * text = "open";
    char output[26];
    char output2[3];
    */
    
    int i = 0;
    /*HMAC_MD5(key, text, output);
    output2[0] = output[0];
    output2[1] = output[1];
    output2[2] = output[2];
    */
    char key[4] = "Dhr";
    for (i = 0; i < 4; i++) {
        key[i] = (key[i] + 5); 
    }
    while (1) {
        new_pb = pb;
        if( (new_pb==0) && (old_pb==1) ) {
            //Send out the real data whenever the button is pressed
            rf.putc(key[0]);
            rf.putc(key[1]);
            rf.putc(key[2]);
            
            //HMAC_MD5(output2, text, output2);
            for (i = 0; i < 4; i++) {
                key[i] = (key[i] + 5); 
            }
            
        }
         
        else {
            //RF Transmit Code
            myled1 = 0;
            //Send 10101010 pattern when idle to keep receivers AGC gain locked to transmitters signal
            //When receiver loses the signal lock (Around 10-30MS with no data change seen) it starts sending out noise
            rf.putc(0xAA);
            myled1 = 0;
            
        }
        old_pb = new_pb; 
        
    }
}
