#include "mbed.h"
#include "Servo.h"
#include "hmac_md5.h"
#include "Camera_LS_Y201.h"
#include "Speaker.h"
AnalogIn ir(p20);
DigitalOut myled2(LED2);
Serial pc(USBTX,USBRX);
Serial rf(p9,p10);
Servo myservo(p23);
Speaker mySpeaker(p18);
Timer t;
int takepic(int);
int camInit(void);

int main() {
    pc.baud(1200);
    rf.baud(1200);
    char code = 0;
    char codebuf[32];
    int cnt = 0;
    int unlocked = 0;
    int matching = 0;
    
    int i =0;
     char key[4] = "Dhr";
    for (i = 0; i < 4; i++) {
        key[i] = (key[i] + 5); 
    }
    char key2[4] = {0};
    key2[0] = key[0];
    key2[1] = key[1];
    key2[2] = key[2];
    for (i = 0; i < 4; i++) {
        key2[i] = (key2[i] + 5); 
    }
    char key3[4] = {0};
    key3[0] = key2[0];
    key3[1] = key2[1];
    key3[2] = key2[2];
    for (i = 0; i < 4; i++) {
        key3[i] = (key3[i] + 5); 
    }

    char received[3] = {0};
    
    camInit(); 
    
    while(1) {
        if (rf.readable()) {
            myled2 = 1;
            matching = 0;
            
            //Ignore Sync pattern and do not pass on to PC
                int i = 0;
                
                //Clear the buffer
                for(i = 0; i < 32; i++) {
                    codebuf[i] = 0;
                }
                
                for(i = 0; i < 32; i++) {
                    code = rf.getc(); 
                    if(code != 0xAA) {
                        codebuf[i] = code;
                        pc.printf("codebuf[%d] = %c\r\n", i, codebuf[i]);
                    }
                }
                
                for(i = 0; i < 30; i++) {
                    if(codebuf[i] == key[0]) {
                        if(codebuf[i+1] == key[1]) {
                            if(codebuf[i+2] == key[2]) {
                                received[0] = codebuf[i];
                                received[1] = codebuf[i+1];
                                received[2] = codebuf[i+2];
                                matching = 1;
                                break;
                            }
                        }
                    }
                    if(codebuf[i] == key2[0]) {
                        if(codebuf[i+1] == key2[1]) {
                            if(codebuf[i+2] == key2[2]) {
                                received[0] = codebuf[i];
                                received[1] = codebuf[i+1];
                                received[2] = codebuf[i+2];
                                matching = 2;
                                break;
                            }
                        }
                    }
                    if(codebuf[i] == key3[0]) {
                        if(codebuf[i+1] == key3[1]) {
                            if(codebuf[i+2] == key3[2]) {
                                received[0] = codebuf[i];
                                received[1] = codebuf[i+1];
                                received[2] = codebuf[i+2];
                                matching = 3;
                                break;
                            }
                        }
                    }
                }
             
                myled2 = 0;
            if(matching) {

                pc.printf("Unlocking door\r\n");
                mySpeaker.PlayNote(800.0, 0.5, 1.0);
                // Turn servo
                myservo = unlocked;
                wait(1);
                unlocked = !unlocked;
                
                if (matching  == 1) {
                    for (i = 0; i < 4; i++) {
                        key[i] = (key[i] + 5); 
                    }
                }
                if (matching  == 2) {
                    for (i = 0; i < 4; i++) {
                        key[i] = (key2[i] + 5); 
                    }
                }
                if (matching  == 3) {
                    for (i = 0; i < 4; i++) {
                        key[i] = (key3[i] + 5); 
                    }
                }
                
                    key2[0] = key[0];
                    key2[1] = key[1];
                    key2[2] = key[2];
                    
                    for (i = 0; i < 4; i++) {
                        key2[i] = (key2[i] + 5); 
                    }
                    
                    
                    key3[0] = key2[0];
                    key3[1] = key2[1];
                    key3[2] = key2[2];
                    for (i = 0; i < 4; i++) {
                        key3[i] = (key3[i] + 5); 
                    }

                takepic(cnt);

                cnt++;
            }
            
            
            
          
        }
    } 
}
