#include "mbed.h"
#include "rtos.h"
#include <string>
#include <stdlib.h>
#include "SongPlayer.h"
#include "Speaker.h"
#include "EthernetInterface.h"

// mbed LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// door lock (led)
DigitalOut doorlock(p21);

//IR sensor
AnalogIn IrSensor(p16);

//speaker
SongPlayer mySpeaker(p22);
Speaker NotePlayer(p22);

// serial PC communication
Serial pc(USBTX, USBRX);

// ethernet connection
EthernetInterface eth;
    

// ** STATE MACHINE ** //
volatile enum Statetype { Armed = 0, IR_sensed = 1, Second_Step = 2, Cleared = 3, Alarm_ON = 4};
Statetype state = Armed;
Statetype mbed0_state;


// ** GLOBAL VARIABLES ** //
volatile float IrVoltage = 0.0;
float note[18]= {1568.0,1396.9};
float duration[18]= {0.48,0.24};

Semaphore Consul_Access(5);
Mutex mbed2_state_change;

//thread prototypes
void IR_thread(void const *args);
void Speaker_thread(void const *args);
void Door_thread(void const *args);
//function prototypes
void Ethernet_update_server();
void reset_server();


int main() {
    pc.baud(9600);
    pc.printf("MBED 2 is Starting....**********************************************************************************************************************************\r\n");
    wait(3);
    //pc.printf("Getting IP....\n\rIP Address is: %s\n\r", eth.getIPAddress());
    
    Thread IRthread(IR_thread);
    Thread Speakerthread(Speaker_thread);
    Thread DoorUnlocker(Door_thread);
    wait(3);
    
    //ethernet thread runs in main
    char buffer[300];
    char http_cmd[100] = "GET http://www.dreamphysix.com/alarm/readstatus.php?mbedID=0 HTTP/1.0\n\n";
    int ret,found,dummy;
    eth.init(); //Use DHCP
    eth.connect();
    TCPSocketConnection sock;
    

    reset_server();
    
    while(1){
        Thread::wait(1000);
        sock.connect("dreamphysix.com", 80);
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            Consul_Access.wait();
            pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
            Consul_Access.release();
        }
        sock.close();
        string str(buffer);
        found = str.find("Status=");
        dummy = (buffer[found+7])-48;
        mbed0_state = (Statetype)dummy;
        mbed2_state_change.lock();
        if(state != mbed0_state)
            state = mbed0_state;
        mbed2_state_change.unlock();
        pc.printf("mbed0 state: %i\n\r",mbed0_state);
        pc.printf("mbed2 state: %i\n\r",state);
    }
    
}

///////////////////
// ** THREADS ** //
///////////////////

void IR_thread(void const *args) {
    
    Timer t;
    t.start(); 
    
    while(1) {
        
        if (state == Armed) {
            IrVoltage=IrSensor.read();
            if (IrVoltage <= 0.1) { //if value just nois reset timer
                t.reset();
                state = Armed;
            }
            if (t.read() >= 5) { //wait 5 seconds to make sure that sense someone 
                mbed2_state_change.lock();
                state = Alarm_ON;
                Ethernet_update_server();
                mbed2_state_change.unlock();
            }
            Thread::wait(1000);
        }
        else {
            //nothing to do for this thread make space for others
            Thread::wait(1000);
        }
    }
}

void Speaker_thread(void const *args) {
    while (1) {
    if (state == Alarm_ON) {
        mySpeaker.PlaySong(note,duration);
        Thread::wait(1000); 
        }
    }
}

void Door_thread(void const *args){
    while(1){
        if(state == Cleared){
            doorlock = 1;
            wait(5);
            doorlock = 0;
        }
        else
            Thread::wait(1000);
    }
}


///////////////////////////////
//      ** FUNCTIONS  **     //
///////////////////////////////

void Ethernet_update_server(){
    char buffer[300];
    int ret;
    
    TCPSocketConnection sock;
    sock.connect("dreamphysix.com", 80);
    
    
    char tempStatus[2];
    snprintf(tempStatus, sizeof(tempStatus), "%i", state);
    char http_cmd[100] = "GET http://www.dreamphysix.com/alarm/updatestatus.php?mbedID=2";
    strcat(http_cmd, "&status=");
    strcat(http_cmd, tempStatus);
    strcat(http_cmd, " HTTP/1.0\n\n");
    pc.printf("%s",http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        Consul_Access.wait();
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
        Consul_Access.release();
    }
    sock.close();
    snprintf(buffer, ret, "%c",buffer);
}

void reset_server(){
    pc.printf("I was called");
    char buffer[300];
    int ret;
    TCPSocketConnection sock;
    sock.connect("dreamphysix.com", 80);
    char http_cmd[100] = "GET http://www.dreamphysix.com/alarm/updatestatus.php?mbedID=0&status=0 HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        Consul_Access.wait();
        pc.printf("Received %d chars from server ABSDDJAJDJAJSJD:\n%s\n", ret, buffer);
        Consul_Access.release();
    }
    sock.close();
}