#ifndef _TILE_H_
#define _TILE_H_

#include "uLCD_4DGL.h"


#define TILE_OFF 0xFF0000
#define TILE_ON  0x00FF00

class Tile
{
public:
    // constructors
    Tile (PinName, PinName, PinName);
    
    // member functions
    void TilePattern3(int); // changes tile colors depending on input
    void TilePattern4(int);
    void setNumberOfTiles(bool);
    int getScore();
    void reset();
    void pause();
    void unpause();
    bool drawCursor(int);
    
    //members
    bool win;
    
    
private:
    void TilePatternSetup();
    void resetScore();
    bool setup;
    bool number_of_tiles; // true = 3x3, false = 4x4
    int score;
    uLCD_4DGL *LCD_ptr;
    
    // 3x3 squares
    void square0();
    void square1();
    void square2();
    void square3();
    void square4();
    void square5();
    void square6();
    void square7();
    void square8();
    bool squares[9]; //false = red/off, true = green/on
    // 4x4 squares
    void smallSquare0();
    void smallSquare1();
    void smallSquare2();
    void smallSquare3();
    void smallSquare4();
    void smallSquare5();
    void smallSquare6();
    void smallSquare7();
    void smallSquare8();
    void smallSquare9();
    void smallSquare10();
    void smallSquare11();
    void smallSquare12();
    void smallSquare13();
    void smallSquare14();
    void smallSquare15();
    bool smallSquares[16]; // false = red/off, true = green/on
    
};  
#endif  