#include "tile.h"

// constructors

Tile::Tile(PinName pin1, PinName pin2, PinName pin3){
    LCD_ptr = new uLCD_4DGL(pin1, pin2, pin3);
    setup = false;
    score = 0;
    win = false;
}

// member functions
void Tile::TilePattern3(int square){
    int i = 0;
    int j = 0;
    switch(square){
        case 0:
            square0();
            square1();
            square3();
            break;
        case 1:
            square0();
            square1();
            square2();
            square4();
            break;
        case 2:
            square1();
            square2();
            square5();
            break;
        case 3:
            square0();
            square3();
            square4();
            square6();
            break;
        case 4:
            square1();
            square3();
            square4();
            square5();
            square7();
            break;
        case 5:
            square2();
            square4();
            square5();
            square8();
            break;
        case 6:
            square3();
            square6();
            square7();
            break;
        case 7:
            square4();
            square6();
            square7();
            square8();
            break;
        case 8:
            square5();
            square7();
            square8();
            break;
        default:
            break;
    }    
    score++;
    for(i = 0; i < 9; i++){
        if(squares[i] == true)
            j++;
    }
    if(j == 9){
        win = true;
    }
}

void Tile::TilePattern4(int square){
    int i = 0;
    int j = 0;
    switch(square){
        case 0:
            smallSquare0();
            smallSquare1();
            smallSquare4();
            break;
        case 1:
            smallSquare0();
            smallSquare1();
            smallSquare2();
            smallSquare5();
            break;
        case 2:
            smallSquare1();
            smallSquare2();
            smallSquare3();
            smallSquare6();
            break;
        case 3:
            smallSquare2();
            smallSquare3();
            smallSquare7();
            break;
        case 4:
            smallSquare0();
            smallSquare4();
            smallSquare5();
            smallSquare8();
            break;
        case 5:
            smallSquare1();
            smallSquare4();
            smallSquare5();
            smallSquare6();
            smallSquare9();
            break;
        case 6:
            smallSquare2();
            smallSquare5();
            smallSquare6();
            smallSquare7();
            smallSquare10();
            break;
        case 7:
            smallSquare3();
            smallSquare6();
            smallSquare7();
            smallSquare11();
            break;
        case 8:
            smallSquare4();
            smallSquare8();
            smallSquare9();
            smallSquare12();
            break;
        case 9:
            smallSquare5();
            smallSquare8();
            smallSquare9();
            smallSquare10();
            smallSquare13();
            break;
        case 10:
            smallSquare6();
            smallSquare9();
            smallSquare10();
            smallSquare11();
            smallSquare14();
            break;
        case 11:
            smallSquare7();
            smallSquare10();
            smallSquare11();
            smallSquare15();
            break;
        case 12:
            smallSquare8();
            smallSquare12();
            smallSquare13();
            break;
        case 13:
            smallSquare9();
            smallSquare12();
            smallSquare13();
            smallSquare14();
            break;
        case 14:
            smallSquare10();
            smallSquare13();
            smallSquare14();
            smallSquare15();
            break;
        case 15:
            smallSquare11();
            smallSquare14();
            smallSquare15();
            break;
        default:
            break;
    }
    score++;
    for(i = 0; i < 16; i++){
        if(smallSquares[i] == true)
            j++;
    }
    if(j == 16){
        win = true;
    }
}

void Tile::TilePatternSetup(){
    if(number_of_tiles == true){ // 3x3
        square0();
        square1();
        square2();
        square3();
        square4();
        square5();
        square6();
        square7();
        square8();
    }
    if(number_of_tiles == false){ // 4x4
        smallSquare0();
        smallSquare1();
        smallSquare2();
        smallSquare3();
        smallSquare4();
        smallSquare5();
        smallSquare6();
        smallSquare7();
        smallSquare8();
        smallSquare9();
        smallSquare10();
        smallSquare11();
        smallSquare12();
        smallSquare13();
        smallSquare14();
        smallSquare15();
    }
    setup = true;
}

void Tile::setNumberOfTiles(bool size){
    number_of_tiles = size;
}

int Tile::getScore(){
    return(score);
}

void Tile::resetScore(){
    score = 0;
}

void Tile::reset(){
    resetScore();
    win = false;
    setup = false;
    TilePatternSetup();
}

void Tile::pause(){
    int i = 0;
    if(number_of_tiles == true){    // 3x3
        for(i = 0; i < 9; i++)
            squares[i] = !squares[i];
    }
    else{
        for(i = 0; i < 16; i++)
            smallSquares[i] = !smallSquares[i];
    }
}

void Tile::unpause(){
    if(number_of_tiles == true){
        square0();
        square1();
        square2();
        square3();
        square4();
        square5();
        square6();
        square7();
        square8();
    }
    else{
        smallSquare0();
        smallSquare1();
        smallSquare2();
        smallSquare3();
        smallSquare4();
        smallSquare5();
        smallSquare6();
        smallSquare7();
        smallSquare8();
        smallSquare9();
        smallSquare10();
        smallSquare11();
        smallSquare12();
        smallSquare13();
        smallSquare14();
        smallSquare15();
    }
}

bool Tile::drawCursor(int position){
    if(number_of_tiles == true)
        return(squares[position]);
    else
        return(smallSquares[position]);
} //return false for red, true for green

// *************************************** //
//              3x3 SQUARES
// *************************************** //

// SQUARE 0
void Tile::square0(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(87, 0, 127, 41, TILE_OFF);
            squares[0] = false;
            break;
        case true:
            squares[0] = !squares[0];
            if(squares[0] == true)
                LCD_ptr->filled_rectangle(87, 0, 127, 41, TILE_ON);
            else
                LCD_ptr->filled_rectangle(87, 0, 127, 41, TILE_OFF);
            break;
    }
}

// SQUARE 1
void Tile::square1(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(87, 44, 127, 85, TILE_OFF);
            squares[1] = false;
            break;
        case true:
            squares[1] = !squares[1];
            if(squares[1] == true)
                LCD_ptr->filled_rectangle(87, 44, 127, 85, TILE_ON);
            else
                LCD_ptr->filled_rectangle(87, 44, 127, 85, TILE_OFF);
            break;
    }
}

//SQUARE 2
void Tile::square2(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(87, 88, 127, 127, TILE_OFF);
            squares[2] = false;
            break;
        case true:
            squares[2] = !squares[2];
            if(squares[2] == true)
                LCD_ptr->filled_rectangle(87, 88, 127, 127, TILE_ON);
            else
                LCD_ptr->filled_rectangle(87, 88, 127, 127, TILE_OFF);
            break;
    }
}

// SQUARE 3
void Tile::square3(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(44, 0, 85, 41, TILE_OFF);
            squares[3] = false;
            break;
        case true:
            squares[3] = !squares[3];
            if(squares[3] == true)
                LCD_ptr->filled_rectangle(44, 0, 85, 41, TILE_ON);
            else
                LCD_ptr->filled_rectangle(44, 0, 85, 41, TILE_OFF);
            break;
    }
}

// SQUARE 4
void Tile::square4(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(44, 44, 85, 85, TILE_OFF);
            squares[4] = false;
            break;
        case true:
            squares[4] = !squares[4];
            if(squares[4] == true)
                LCD_ptr->filled_rectangle(44, 44, 85, 85, TILE_ON);
            else
                LCD_ptr->filled_rectangle(44, 44, 85, 85, TILE_OFF);
            break;
    }
}

// SQUARE 5
void Tile::square5(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(44, 88, 85, 127, TILE_OFF);
            squares[5] = false;
            break;
        case true:
            squares[5] = !squares[5];
            if(squares[5] == true)
                LCD_ptr->filled_rectangle(44, 88, 85, 127, TILE_ON);
            else
                LCD_ptr->filled_rectangle(44, 88, 85, 127, TILE_OFF);
            break;
    }
}

// SQUARE 6
void Tile::square6(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 0, 41, 41, TILE_OFF);
            squares[6] = false;
            break;
        case true:
            squares[6] = !squares[6];
            if(squares[6] == true)
                LCD_ptr->filled_rectangle(0, 0, 41, 41, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 0, 41, 41, TILE_OFF);
            break;
    }
}

// SQUARE 7
void Tile::square7(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 44, 41, 85, TILE_OFF);
            squares[7] = false;
            break;
        case true:
            squares[7] = !squares[7];
            if(squares[7] == true)
                LCD_ptr->filled_rectangle(0, 44, 41, 85, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 44, 41, 85, TILE_OFF);
            break;
    }
}

// SQUARE 8
void Tile::square8(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 88, 41, 127, TILE_OFF);
            squares[8] = false;
            break;
        case true:
            squares[8] = !squares[8];
            if(squares[8] == true)
                LCD_ptr->filled_rectangle(0, 88, 41, 127, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 88, 41, 127, TILE_OFF);
            break;
    }
}


// *************************************** //
//              4x4 SQUARES
// *************************************** //

// SQUARE 0
void Tile::smallSquare0(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(96, 0, 126, 29, TILE_OFF);
            smallSquares[0] = false;
            break;
        case true:
            smallSquares[0] = !smallSquares[0];
            if(smallSquares[0] == true)
                LCD_ptr->filled_rectangle(96, 0, 126, 29, TILE_ON);
            else
                LCD_ptr->filled_rectangle(96, 0, 126, 29, TILE_OFF);
            break;
    }
}

// SQUARE 1
void Tile::smallSquare1(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(96, 32, 126, 61, TILE_OFF);
            smallSquares[1] = false;
            break;
        case true:
            smallSquares[1] = !smallSquares[1];
            if(smallSquares[1] == true)
                LCD_ptr->filled_rectangle(96, 32, 126, 61, TILE_ON);
            else
                LCD_ptr->filled_rectangle(96, 32, 126, 61, TILE_OFF);
            break;
    }
}

// SQUARE 2
void Tile::smallSquare2(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(96, 64, 126, 93, TILE_OFF);
            smallSquares[2] = false;
            break;
        case true:
            smallSquares[2] = !smallSquares[2];
            if(smallSquares[2] == true)
                LCD_ptr->filled_rectangle(96, 64, 126, 93, TILE_ON);
            else
                LCD_ptr->filled_rectangle(96, 64, 126, 93, TILE_OFF);
            break;
    }
}

// SQUARE 3
void Tile::smallSquare3(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(96, 96, 126, 126, TILE_OFF);
            smallSquares[3] = false;
            break;
        case true:
            smallSquares[3] = !smallSquares[3];
            if(smallSquares[3] == true)
                LCD_ptr->filled_rectangle(96, 96, 126, 126, TILE_ON);
            else
                LCD_ptr->filled_rectangle(96, 96, 126, 126, TILE_OFF);
            break;
    }
}

// SQUARE 4
void Tile::smallSquare4(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(64, 0, 93, 29, TILE_OFF);
            smallSquares[4] = false;
            break;
        case true:
            smallSquares[4] = !smallSquares[4];
            if(smallSquares[4] == true)
                LCD_ptr->filled_rectangle(64, 0, 93, 29, TILE_ON);
            else
                LCD_ptr->filled_rectangle(64, 0, 93, 29, TILE_OFF);
            break;
    }
}

// SQUARE 5
void Tile::smallSquare5(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(64, 32, 93, 61, TILE_OFF);
            smallSquares[5] = false;
            break;
        case true:
            smallSquares[5] = !smallSquares[5];
            if(smallSquares[5] == true)
                LCD_ptr->filled_rectangle(64, 32, 93, 61, TILE_ON);
            else
                LCD_ptr->filled_rectangle(64, 32, 93, 61, TILE_OFF);
            break;
    }
}

// SQUARE 6
void Tile::smallSquare6(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(64, 64, 93, 93, TILE_OFF);
            smallSquares[6] = false;
            break;
        case true:
            smallSquares[6] = !smallSquares[6];
            if(smallSquares[6] == true)
                LCD_ptr->filled_rectangle(64, 64, 93, 93, TILE_ON);
            else
                LCD_ptr->filled_rectangle(64, 64, 93, 93, TILE_OFF);
            break;
    }
}

// SQUARE 7
void Tile::smallSquare7(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(64, 96, 93, 126, TILE_OFF);
            smallSquares[7] = false;
            break;
        case true:
            smallSquares[7] = !smallSquares[7];
            if(smallSquares[7] == true)
                LCD_ptr->filled_rectangle(64, 96, 93, 126, TILE_ON);
            else
                LCD_ptr->filled_rectangle(64, 96, 93, 126, TILE_OFF);
            break;
    }
}

// SQUARE 8
void Tile::smallSquare8(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(32, 0, 61, 29, TILE_OFF);
            smallSquares[8] = false;
            break;
        case true:
            smallSquares[8] = !smallSquares[8];
            if(smallSquares[8] == true)
                LCD_ptr->filled_rectangle(32, 0, 61, 29, TILE_ON);
            else
                LCD_ptr->filled_rectangle(32, 0, 61, 29, TILE_OFF);
            break;
    }
}

// SQUARE 9
void Tile::smallSquare9(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(32, 32, 61, 61, TILE_OFF);
            smallSquares[9] = false;
            break;
        case true:
            smallSquares[9] = !smallSquares[9];
            if(smallSquares[9] == true)
                LCD_ptr->filled_rectangle(32, 32, 61, 61, TILE_ON);
            else
                LCD_ptr->filled_rectangle(32, 32, 61, 61, TILE_OFF);
            break;
    }
}

// SQUARE 10
void Tile::smallSquare10(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(32, 64, 61, 93, TILE_OFF);
            smallSquares[10] = false;
            break;
        case true:
            smallSquares[10] = !smallSquares[10];
            if(smallSquares[10] == true)
                LCD_ptr->filled_rectangle(32, 64, 61, 93, TILE_ON);
            else
                LCD_ptr->filled_rectangle(32, 64, 61, 93, TILE_OFF);
            break;
    }
}

// SQUARE 11
void Tile::smallSquare11(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(32, 96, 61, 126, TILE_OFF);
            smallSquares[11] = false;
            break;
        case true:
            smallSquares[11] = !smallSquares[11];
            if(smallSquares[11] == true)
                LCD_ptr->filled_rectangle(32, 96, 61, 126, TILE_ON);
            else
                LCD_ptr->filled_rectangle(32, 96, 61, 126, TILE_OFF);
            break;
    }
}

// SQUARE 12
void Tile::smallSquare12(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 0, 29, 29, TILE_OFF);
            smallSquares[12] = false;
            break;
        case true:
            smallSquares[12] = !smallSquares[12];
            if(smallSquares[12] == true)
                LCD_ptr->filled_rectangle(0, 0, 29, 29, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 0, 29, 29, TILE_OFF);
            break;
    }
}

// SQUARE 13
void Tile::smallSquare13(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 32, 29, 61, TILE_OFF);
            smallSquares[13] = false;
            break;
        case true:
            smallSquares[13] = !smallSquares[13];
            if(smallSquares[13] == true)
                LCD_ptr->filled_rectangle(0, 32, 29, 61, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 32, 29, 61, TILE_OFF);
            break;
    }
}

// SQUARE 14
void Tile::smallSquare14(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 64, 29, 93, TILE_OFF);
            smallSquares[14] = false;
            break;
        case true:
            smallSquares[14] = !smallSquares[14];
            if(smallSquares[14] == true)
                LCD_ptr->filled_rectangle(0, 64, 29, 93, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 64, 29, 93, TILE_OFF);
            break;
    }
}

// SQUARE 15
void Tile::smallSquare15(){
    switch(setup){
        case false:
            LCD_ptr->filled_rectangle(0, 96, 29, 126, TILE_OFF);
            smallSquares[15] = false;
            break;
        case true:
            smallSquares[15] = !smallSquares[15];
            if(smallSquares[15] == true)
                LCD_ptr->filled_rectangle(0, 96, 29, 126, TILE_ON);
            else
                LCD_ptr->filled_rectangle(0, 96, 29, 126, TILE_OFF);
            break;
    }
}