
#include "mbed.h"
#include "WIZnetInterface.h"
#include "GY80.h"
#include "tsi_sensor.h"
#include "main.h"


int main()                                              /// Main Function:
{

    
    pc.attach(&SerialInterHandler, Serial::RxIrq);      ///     - configures serial port interrupts & choose handler
    menu_prop();                                        ///     - shows 5 sec menu
    pc.attach(NULL, Serial::RxIrq);                     ///     - disables serial port interrupts after 5s
    tick1.attach_us(&read_data, 10000);                 ///     - reads data from sensors in 10ms intervals
    if(init_eth() == 1) {                               ///     - initializes ethernet communication
            wait(0.001);                                // wait
            eth_comm();                                 ///     - and tcp/ip server if no error occured
    } else {                                            //
        return -1;                                      ///     - or returns an error
    }                                                   ///
    while(1);                                           // infinit loop
}

int init_eth()
{
    /**
    * Initializes ethernet communication by configuring WIZ550io via SPI interface.
    * DHCP or Static IP configuration could be used.
    * Use of them is user configurable via serial port.
    */
    int ret;                                            // error code variable
    
    // MAC Adress setting:
    mac[0] = 0x00;
    mac[1] = 0x08;
    mac[2] = 0xDC;
    mac[3] = 0x1D;
    mac[4] = 0x2E;
    mac[5] = 0x74;

    pc.printf("\r \n Ethernet Initialization \n");
    
    if (USE_DHCP){
        ret = eth.init(mac);                                   // Use DHCP
    }
    else{
        ret = eth.init(mac, IP_Addr, IP_Subnet, IP_Gateway);    // static configuration
    }
    if (!ret) {                                                 // if error don't happen
        pc.printf("\r \n Initialized, MAC: %s\n", eth.getMACAddress());
    } else {                                                    // else show error code
        pc.printf("\r \n Error eth.init() - ret = %d\n", ret);
        return -1;
    }

    ret = eth.connect();
    if (!ret) {
        pc.printf("\r \nIP: %s, MASK: %s, GW: %s\n",
                  eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        pc.printf("\r \n Error eth.connect() - ret = %d\n", ret);
        return -1;
    }
    return 1;

}

void eth_comm()
{
    /**
    * Creates server and waits for client to connect.
    * Sends reveiced buffer with commands to comm_handler.
    * And sends reply created by comm_handler to client.
    */
    TCPSocketServer server;                                             // TCP/IP server object
    server.bind(ECHO_SERVER_PORT);                                      // binding listen port
    server.listen();                                                    // start listening

    while (true) {                                                      // infinit loop
        pc.printf("\n \r Wait for new connection...\n");                // pc info
        TCPSocketConnection client;                                     // TCP/IP client object
        server.accept(client);                                          // accept connection
        client.set_blocking(false, 4000);                               // no blocking connections, timeout after (1.5)s
        pc.printf("\n \r Connection from: %s\n", client.get_address()); // pc info
        char buffer[256];                                               // Data buffer
        while (true) {                                                  // loop
            for(int i =0; i < 256; i++) buffer[i] = '\0';               // clear buffer
            int n = client.receive(buffer, sizeof(buffer));             // receive data & save it to buffer
            if (n <= 0) break;                                          // break if buffer is empty or error occured
            comm_handler(buffer);                                       // send received command to communication handler
            n = strlen(buffer);                                         // check buffer length
            pc.printf("\n \r BUFF: %s, strlen: %d, size: %d, n: %d", buffer, strlen(buffer), sizeof(buffer), n);    // pc info, just for debug
            client.send(buffer, n);                                     // send reply
            for(int i =0; i < 256; i++) buffer[i] = '\0';               // clear buffer  
            if (n <= 0) break;                                          // if error occured send break
        }                                                               //
        client.close();                                                 // close connection
    }                                                                   //
}

void read_data()
{
    /**
    * Reads sensor data in 10ms intervals.
    * And saves them.
    */
    sensor.Read_Magn(magn);                                             // read magnitude
    sensor.Read_Accel(accel);                                           // read acceleration
    sensor.Read_Gyro(gyro);                                             // read gyroscope
    TSI_pos = tsi.readPercentage();                                     // read percentage position of touch sensor
    //double pitch = (atan2(-accel[1], accel[2]) * 180.0) / 3.14;  
    //double roll = (atan2(accel[0], sqrt(accel[1]*[accel[1] + accel[2] * accel[2])) * 180.0) / 3.14;
    //pc.printf("roll: %f pitch: %f ,roll", pitch);
}

void comm_handler(char* command)
{
    /** This function gets data buffer with command 
    * and prepares answer to be sent.  
    */
                                                                        
    pc.printf("\n \r %s \n \r", command);                               // send received command to pc (DEBUG)
    if(strcmp(command,"read_sensor")==0) {                              // data read from sensor
       sprintf(command, "{\"magnX\":%10f,\"magnY\":%10f,\"magnZ\":%10f,\"accelX\":%10f,\"accelY\":%10f,\"accelZ\":%10f,\"gyroX\":%10f,\"gyroY\":%10f,\"gyroZ\":%10f,\"TSIpos\":%10f}", magn[0], magn[1], magn[2], accel[0], accel[1], accel[2], gyro[0], gyro[1], gyro[2], TSI_pos);         // enter data to buffer
        wait(0.001);                                                    // wait
        pc.printf("\n \r sending sensor data! %s", command);            // pc info (debug)
    } else if (strcmp(command,"check_ports")==0) {                      // check I/O ports current values 
        sprintf(command, "{\"P1\":%d,\"P2\":%d,\"P3\":%d,\"P4\":%d,\"P5\":%d,\"P6\":%d}", P1.read(), P2.read(), P3.read(), P4.read(), P5.read(), P6.read());
    } else if (strcmp(command,"get_P1")==0) {                           // get P1 value
        sprintf(command, "{\"P1\":%d}", P1.read());                         //
    } else if(strcmp(command,"set_P1_o")==0) {                          // set P1 as output
        P1.output();                                                    //
        sprintf(command, "P1 is now set as output");                    //
    } else if (strcmp(command,"set_P1_i")==0) {                         // set P1 as input
        P1.input();                                                     //
        sprintf(command, "P1 is now set as input");                     //
    } else if (strcmp(command,"set_P1_1")==0) {                         // set P1 as 1
        P1.output();                                                    // set to output
        P1.write(1);                                                    // write 1 to P1
        sprintf(command, "{\"P1\":%d}", P1.read());                         // reply with current value to check
    } else if (strcmp(command,"set_P1_0")==0) {                         // set P1 as 0
        P1.output();                                                    //
        P1.write(0);
        sprintf(command, "{\"P1\":%d}", P1.read());
    } else if (strcmp(command,"get_P2")==0) {
        sprintf(command, "{\"P2\":%d}", P2.read());
    } else if (strcmp(command,"set_P2_o")==0) {
        P2.output();
        sprintf(command, "P2 is now set as output");
    } else if (strcmp(command,"set_P2_i")==0) {
        P2.input();
        sprintf (command, "P2 is now set as input");
    } else if (strcmp(command,"set_P2_1")==0) {
        P2.output();
        P2.write(1);
        sprintf(command, "P2 value is now: %d ", P2.read());
    } else if (strcmp(command,"set_P2_0")==0) {
        P2.output();
        P2.write(0);
        sprintf(command, "{\"P2\":%d}", P2.read());
    } else if (strcmp(command,"get_P3")==0) {
        sprintf(command, "{\"P3\":%d}", P3.read());
    } else if (strcmp(command,"set_P3_o")==0) {
        P3.output();
        sprintf(command, "P3 is now set as output");
    } else if (strcmp(command,"set_P3_i")==0) {
        P3.input();
        sprintf (command, "P3 is now set as input");
    } else if (strcmp(command,"set_P3_1")==0) {
        P3.output();
        P3.write(1);
        sprintf(command, "{\"P3\":%d}", P3.read());
    } else if (strcmp(command,"set_P3_0")==0) {
        P3.output();
        P3.write(0);
        sprintf(command, "P3 value is now: %d ", P3.read());
    } else if (strcmp(command,"get_P4")==0) {
        sprintf(command, "{\"P4\":%d}", P4.read());
    } else if (strcmp(command,"set_P4_o")==0) {
        P4.output();
        sprintf(command, "P4 is now set as output");
    } else if (strcmp(command,"set_P4_i")==0) {
        P4.input();
        sprintf (command, "P4 is now set as input");
    } else if (strcmp(command,"set_P4_1")==0) {
        P4.output();
        P4.write(1);
        sprintf(command, "{\"P4\":%d}", P4.read());
    } else if (strcmp(command,"set_P4_0")==0) {
        P4.output();
        P4.write(0);
        sprintf(command, "{\"P4\":%d}", P4.read());
    } else if (strcmp(command,"get_P5")==0) {
        sprintf(command, "{\"P5:\"%d}", P5.read());
    } else if (strcmp(command,"set_P5_o")==0) {
        P5.output();
        sprintf(command, "P5 is now set as output");
    } else if (strcmp(command,"set_P5_i")==0) {
        P5.input();
        sprintf (command, "P5 is now set as input");
    } else if (strcmp(command,"set_P5_1")==0) {
        P5.output();
        P5.write(1);
        sprintf(command, "{\"P5\":%d}", P5.read());
    } else if (strcmp(command,"set_P5_0")==0) {
        P5.output();
        P5.write(0);
        sprintf(command, "{\"P5\":%d}", P5.read());
    } else if (strcmp(command,"get_P6")==0) {
        sprintf(command, "{\"P6\":%d}", P6.read());
    } else if (strcmp(command,"set_P6_o")==0) {
        P6.output();
        sprintf(command, "P6 is now set as output");
    } else if (strcmp(command,"set_P6_i")==0) {
        P6.input();
        sprintf (command, "P6 is now set as input");
    } else if (strcmp(command,"set_P6_1")==0) {
        P6.output();
        P6.write(1);
        sprintf(command, "{\"P6\":%d}", P6.read());
    } else if (strcmp(command,"set_P6_0")==0) {
        P6.output();
        P6.write(0);
        sprintf(command, "{\"P6\":%d}", P6.read());
    } else sprintf(command, "Unknown Command!");
}

void SerialInterHandler()
{
    /**
    Enables to configure Ethernet card via serial port in first 5 seconds from KL25Z startup.
    */
    pc.getc();                                  // gets 1 char from buffer and clears it
    pc.printf("\n \rUse DHCP? \n \ry-yes ");
    char from_serial;
     while (true) {       
        if (pc.readable()) {
            from_serial= pc.getc();            
            break;
        }
    }
    pc.printf("\n \r%c", from_serial);
    if (from_serial=='y') { 
        USE_DHCP = true;
        pc.printf("\n \rUsing DHCP ");
        return;
        }
    else if (from_serial=='n') { 
        USE_DHCP = false;
        pc.printf("\n \rStatic IP configuration ");
        pc.printf("\n \rCurrent config:");
        pc.printf("\r \nIP: %s, MASK: %s, GW: %s\n", IP_Addr, IP_Subnet, IP_Gateway);
        pc.printf("\n \rDo you want to change it?");
            if(pc.getc()=='y'){
                    pc.printf("\n \rIP: \n \r Press 'enter and then backspace' to end and save \r \n Remember to Enter all 15 characters!\n \r");
                    pc.scanf("%s" ,IP_Addr);
                    pc.printf("new IP: %s", IP_Addr);
                    pc.printf("\n \r Enter Subnet Mask:");
                    pc.scanf("%s", IP_Subnet);
                    pc.printf("\n \r new Mask: %s", IP_Subnet);
                    pc.printf("\n \r Enter Gateway:");
                    pc.scanf("%s", IP_Gateway);
                    pc.printf("\r \n IP: %s, MASK: %s, GW: %s\n", IP_Addr, IP_Subnet, IP_Gateway);
                }
            else return;
        return;
    }
    else pc.printf("\n \rWrong key! Nothing to do");
}

void menu_prop()
{
    /**
    Counting down time left to enter menu.
    */
    pc.printf("\n \r Press any key to enter menu \n \r 5");
    wait(1);
    pc.printf("\n \r 4");
     wait(1);
    pc.printf("\n \r 3");
     wait(1);
    pc.printf("\n \r 2");
     wait(1);
    pc.printf("\n \r 1");
     wait(1);
    pc.printf("\n \r 0 \n \r Starting!");
        
}