#include "Temperature.h"
I2C i2cTemp(p9, p10);
volatile short rawTemp;
    
float tempFar(float temp) { // converts temperature to farenheit
    float far;
    far = (((0.0625 * rawTemp)*(9/5))+32);
    return far;
}

float tempRan(float temp) { // converts temperature to rankine
    float ran;
    ran = (((0.0625 * rawTemp)*(9/5))+491.67);
    return ran;
}

float tempKel(float temp){ // cocnverts temperature to kelvin
    float kel;
    kel = ((0.0625 * rawTemp)+273);
    return kel;
}

void tempConfig(void) { // configures the correct settings for the temperature sensor when the program starts
    char buff[3];
    const int tempAddr = 0x90;
    buff[0] = 0x01;
    buff[1] = 0x60;
    buff[2] = 0xA0;
    i2cTemp.write(tempAddr, buff, 3);
    buff[0] = 0x00;
    i2cTemp.write(tempAddr, buff, 1);    
}

float readTemp() { // converts rawTemp (the raw data from the temperature sensor) to degrees celsius
    float temp;
    char buff[2];
    const int tempAddr = 0x90;
    i2cTemp.read(tempAddr, buff, 2);
    rawTemp = (buff[0] <<8) + buff[1];
    rawTemp = rawTemp >> 4;
    temp = 0.0625 * rawTemp;
    return temp;
}