#include "Tap.h"

I2C tapI2C(p9, p10);
InterruptIn tapInterrupt(p5);
char buff[2];
const int accelAddr = 0x53 << 1;
volatile int i;

void tapsConfig(void) {  //configures the settings for the accelerometer (same settings as mini project 6 converted to I2C)
    buff[0] = 0x1D;
    buff[1] = 80;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x21;  
    buff[1] = 0x10;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x22;
    buff[1] = 0x05;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x23;
    buff[1] = 0xFF;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x2A;
    buff[1] = 0x07;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x2E;
    buff[1] = 0x60;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[1] = 0x2F;
    buff[0] = 0x60;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    buff[0] = 0x2D;
    buff[1] = 0x08;
    tapI2C.write(accelAddr, buff, 2);
    wait(0.02);
    tapInterrupt.rise(&tapsHappened);
    tapsHappened(); // resets the interrupt, same as mini project 6
}

void tapsHappened(void) {
    char tapByte;
    bool absol = true;
    bool unit = true;
    buff[0]=0x30;
    tapI2C.write(accelAddr,buff,1);
    tapI2C.read(accelAddr,buff,1);
    tapByte = buff[0]; // gets a value for tapByte
    if (tapByte & 0x40) { //based on the value of tapByte, determines if there was a single or double tap
        unit = !unit; // changes the value of unit and absol based on the number of taps
    }
    if (tapByte & 0x20) { 
        absol = !absol;
    }
    if (unit == 1 && absol == 1) { /* based on the values of unit and absol, determines the value of i,
    which is used to determine the units of the temperature displayed */
        i = 0;
    }
    if (unit == 1 && absol == 0) {
        i = 1;
    }
    if (unit == 0 && absol == 1) {
        i = 2;
    }
    if (unit == 0 && absol == 0) {
        i = 3;
    }
}
int getSetting(int i){ /* the value of i is set in a void function (which must be void because it is an interrupt)
This function is an int function that returns the value of i, allowing us to call it for the value of i from main.cpp */
    return i;
}