#include "mbed.h"
#include "Temperature.h"
#include "TextLCD.h"
#include "Tap.h"

TextLCD lcd(p19, p20, p21, p22, p23, p24);

int main() {
    tempConfig();
    tapsConfig();
    float temp;
    int i;
    while(1) {
        i = getSetting(i); // gets new value of i when an interrupt (tapping) changes it
        switch(i) { // converts to correct units based on the value of i
            case 0: temp = readTemp();
            break;
            case 1: temp = tempKel(temp);
            break;
            case 2: temp = tempFar(temp);
            break;
            case 3: temp = tempRan(temp);
            break;
        }
        lcd.printf("%1.2f",temp); // display temperature on the lcd
        wait(1); // updates the temperature every one second
        lcd.cls();
    }
}