/* Jason Schilling
jschilling22@my.whitworth.edu
1/15/18
Mini Project 6
This program senses one or two taps in sucession and turns on an led if it was one or two taps.
*/
#include <mbed.h>

DigitalOut ss(p14);
SPI acc(p11, p12, p13);  //MOSI, MISO, and SCK
void tapsHappened(void);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);
InterruptIn tapInterrupt(p5);
Timeout singleTimeout;
Timeout doubleTimeout;
void singleOff(void);
void doubleOff(void);

int main() {
    ss = 1; // turns off the accelerometer(ADXL345) while setting format and frequency
    acc.format(8,3); // 8 bit words, mode 3
    acc.frequency(2000000); // 2 MHz clock
    // the ADXL345 is turned on for each transmission (and off after each transmission) to adjust its settings
    /* for all of the setting adjustments, the first line is the address of the register.
    The second line adjusts the setting to the desired value */
    ss = 0; 
    acc.write(0x1D); // sets tap threshold to 5g
    acc.write(80);
    ss = 1;
    
    ss = 0;
    acc.write(0x21); // sets tap duration to
    acc.write(0x10);    // 10 ms
    ss = 1;

    ss = 0;
    acc.write(0x22); // sets double tap gap to
    acc.write(0x05);    // 6 ms
    ss = 1;

    ss = 0;
    acc.write(0x23); // sets double tap window to 
    acc.write(0xFF);    // 318.75 ms
    ss = 1;

    ss = 0;
    acc.write(0x2A); // sets tap axes to enable the 
    acc.write(0x07); // x, y, and z axes for tap detection
    ss = 1;

    ss = 0;
    acc.write(0x2E); // sets interrupt enable just to
    acc.write(0x60); // single/double taps
    ss = 1;

    ss = 0;
    acc.write(0x2F); // sets interrupt map to set INT2 high if either a 
    acc.write(0x60); // single or double tap interrupt is detected
    ss = 1;

    ss = 0;
    acc.write(0x2D); // sets power control to
    acc.write(0x08); // measure mode
    ss = 1;

    wait(0.5);
    tapInterrupt.rise(&tapsHappened);
    tapsHappened(); // the interrupt is high before getting to this line and will remain high before it is read again, 
                    // this line reads it and sets it back to low allowing the program to continue working
    while (true) {
        led4 = !led4; // led4 flashes to show prgram is running
        wait(0.3);
    }
}

void tapsHappened(void) {
    char tapByte;
    ss = 0;
    acc.write(0x30 | 0x80); // 0x30 is the address, 0x80 means we are reading it
    tapByte = acc.write(0); // write zero to get a read response (could send anything). tapByte is set equal to this response
    ss = 1;

    if (tapByte & 0x40) { 
        /* 0x40 converted to binary is a single tap. If there is a single tap, 
        it turns on LED 1 and activates the singleOff function one second later */
        led1 = 1;
        singleTimeout.attach(&singleOff, 1.0);
    }
    if (tapByte & 0x20) { /* 0x20 converted to binary is a double tap. If there is a double tap, 
        it turns on LED 2 and activates the doubleOff function one second later. 
        This will turn on LED 1 and 2 because every double tap starts with a single tap */
        led2 = 1;
        doubleTimeout.attach(&doubleOff, 1.0);
    }
}
void singleOff(void) {
    // first LED off when this function is called by the timeout
    led1 = 0;
}
void doubleOff(void) {
    // first LED off when this function is called by the timeout
    led2 = 0;
}