//L6470 libraly maked by Brid
//Modified to Daisy Chain Mode by Lvh - March 2015

#ifndef MBED_L6470
#define MBED_L6470

#include "mbed.h"

#define LEN_ABS_POS      22
#define LEN_EL_POS       9
#define LEN_MARK         22
#define LEN_SPEED        20
#define LEN_ACC          12
#define LEN_DEC          12
#define LEN_MAX_SPEED    10
#define LEN_MIN_SPEED    13
#define LEN_KVAL_HOLD    8
#define LEN_KVAL_RUN     8
#define LEN_KVAL_ACC     8
#define LEN_KVAL_DEC     8
#define LEN_INT_SPD      14
#define LEN_ST_SLP       8
#define LEN_FN_SLP_ACC   8
#define LEN_FN_SLP_DEC   8
#define LEN_K_THERA      4
#define LEN_ADC_OUT      5
#define LEN_OCR_TH       4
#define LEN_STALL_TH     7
#define LEN_FS_SPD       10
#define LEN_STEP_MODE    8
#define LEN_ARARM_FN     8
#define LEN_CONFIG       16
#define LEN_STATUS       16


#define ADD_ABS_POS      0x01
#define ADD_EL_POS       0x02
#define ADD_MARK         0x03
#define ADD_SPEED        0x04
#define ADD_ACC          0x05
#define ADD_DEC          0x06
#define ADD_MAX_SPEED    0x07
#define ADD_MIN_SPEED    0x08
#define ADD_KVAL_HOLD    0x09
#define ADD_KVAL_RUN     0x0A
#define ADD_KVAL_ACC     0x0B
#define ADD_KVAL_DEC     0x0C
#define ADD_INT_SPD      0x0D
#define ADD_ST_SLP       0x0E
#define ADD_FN_SLP_ACC   0x0F
#define ADD_FN_SLP_DEC   0x10
#define ADD_K_THERA      0x11
#define ADD_ADC_OUT      0x12
#define ADD_OCR_TH       0x13
#define ADD_STALL_TH     0x14
#define ADD_FS_SPD       0x15
#define ADD_STEP_MODE    0x16
#define ADD_ARARM_FN     0x17
#define ADD_CONFIG       0x18
#define ADD_STATUS       0x19

#define L6470_MAX_POSITION          (0x1FFFFF)          //!< Max position
#define L6470_MIN_POSITION          (-(0x200000))       //!< Min position
#define L6470_POSITION_RANGE        ((uint32_t)(L6470_MAX_POSITION - L6470_MIN_POSITION))   //!< Position range
#define L6470_MAX_SPEED             (0xFFFFF)           //!< max value of SPEED
#define L6470_MAX_ACC               (0xFFF)             //!< max value of ACC
#define L6470_MAX_DEC               (0xFFF)             //!< max value of DEC
#define L6470_MAX_MAX_SPEED         (0x3FF)             //!< max value of MAX_SPEED
#define L6470_MAX_MIN_SPEED         (0xFFF)             //!< max value of MIN_SPEED
#define L6470_MAX_FS_SPD            (0x3FF)             //!< max value of FS_SPD
#define L6470_MAX_INT_SPEED         (0x3FFF)            //!< max value of INT_SPEED
#define L6470_MAX_ST_SLP            (0xFF)              //!< max value of ST_SLP
#define L6470_MAX_FN_SLP_ACC        (0xFF)              //!< max value of FN_SLP_ACC
#define L6470_MAX_FN_SLP_DEC        (0xFF)              //!< max value of FN_SLP_DEC
#define L6470_MAX_OCD_TH            (0xF)               //!< max value of OCD_TH
#define L6470_MAX_STALL_TH          (0x7F)              //!< max value of STALL_TH

#define L6470_MAX_SPEED_VALUE   ((float)15610)      //!< max value for the speed in step/s
#define L6470_MAX_ACC_VALUE     ((float)59590)      //!< max value for the acceleration in step/s^2
#define L6470_MAX_DEC_VALUE     ((float)59590)      //!< max value for the acceleration in step/s^2
#define L6470_MAX_DEC_VALUE     ((float)59590)      //!< max value for the acceleration in step/s^2

#define OCD_TH_STEP             ((float)375)      //!< Minimum step for OCD_TH register in mAmpere
#define STALL_TH_STEP           ((float)31.25)    //!< Minimum step for STALL_TH register in mAmpere

#define L6470_ACC_CONV          ((float)0.068719)   //!< Conversion factor for acceleration value from step/s^2 to the right value
#define L6470_DEC_CONV          ((float)0.068719)   //!< Conversion factor for deceleration value from step/s^2 to the right value
#define L6470_MAXSPEED_CONV     ((float)0.065536)   //!< Conversion factor for max speed value from step/s to the right value
#define L6470_MINSPEED_CONV     ((float)4.194304)   //!< Conversion factor for min speed value from step/s to the right value
#define L6470_SPEED_CONV        ((float)67.108864)  //!< Conversion factor for speed value from step/s to the right value

typedef enum {
    FULL_STEP       = 0x00,   //!< Full-step
    HALF_STEP       = 0x01,   //!< Half-step
    MICROSTEP_1_4   = 0x02,   //!< 1/4 microstep
    MICROSTEP_1_8   = 0x03,   //!< 1/8 microstep
    MICROSTEP_1_16  = 0x04,   //!< 1/16 microstep
    MICROSTEP_1_32  = 0x05,   //!< 1/32 microstep
    MICROSTEP_1_64  = 0x06,   //!< 1/64 microstep
    MICROSTEP_1_128 = 0x07    //!< 1/128 microstep
} L6470_StepMode;

typedef struct {
    float       motorvoltage;           //!< motor supply voltage in V
    int         fullstepsperrevolution; //!< min number of steps per revolution for the motor
    int         position;
    int         target;                  //!< target [steps]  
    float       speed;                  //!< motor initial speed [step/s]
    float       acc;                    //!< motor acceleration [step/s^2] (comment for infinite acceleration mode)
    float       dec;                    //!< motor deceleration [step/s^2] (comment for infinite deceleration mode)
    float       maxspeed;               //!< motor maximum speed [step/s]
    float       minspeed;               //!< motor minimum speed [step/s]
    float       fsspd;                  //!< motor full-step speed threshold [step/s]
    float       kvalhold;               //!< holding kval [V]
    float       kvalrun;                //!< constant speed kval [V]
    float       kvalacc;                //!< acceleration starting kval [V]
    float       kvaldec;                //!< deceleration starting kval [V]
    float       intspeed;               //!< intersect speed for bemf compensation curve slope changing [step/s]
    float       stslp;                  //!< start slope [s/step]
    float       fnslpacc;               //!< acceleration final slope [s/step]
    float       fnslpdec;               //!< deceleration final slope [s/step]
    uint8_t     kterm;                  //!< thermal compensation factor (range [0, 15])
    float       ocdth;                  //!< ocd threshold [ma] (range [375 ma, 6000 ma])
    float       stallth;                //!< stall threshold [ma] (range [31.25 ma, 4000 ma])
    uint8_t     step_sel;               //!< step mode selection
    uint8_t     alarmen;                //!< alarm conditions enable
    uint16_t    config;                 //!< ic configuration
}  L6470_MotorConf;

enum L6470_Register {
    ABS_POS = 0x01,     //!< Current position
    EL_POS,             //!< Electrical position
    MARK,               //!< Mark position
    SPEED,              //!< Current speed
    ACC,                //!< Acceleration
    DEC,                //!< Deceleration
    MAX_SPEED,          //!< Maximum speed
    MIN_SPEED,          //!< Minimum speed
    KVAL_HOLD,          //!< Holding KVAL
    KVAL_RUN,           //!< Constant speed KVAL
    KVAL_ACC,           //!< Acceleration starting KVAL
    KVAL_DEC,           //!< Deceleration starting KVAL
    INT_SPD,            //!< Intersect speed
    ST_SLP,             //!< Start slope
    FN_SLP_ACC,         //!< Acceleration final slope
    FN_SLP_DEC,         //!< Deceleration final slope
    K_THERA,            //!< Thermal compensation factor
    ADC_OUT,            //!< ADC output, (the reset value is according to startup conditions)
    OCR_TH,             //!< OCD threshold
    STALL_TH,           //!< STALL threshold
    FS_SPD,             //!< Full-step speed
    STEP_MODE,          //!< Step mode
    ARARM_FN,           //!< Alarm enable
    CONFIG,             //!< IC configuration
    STATUS              //!< Status, (the reset value is according to startup conditions)
};

typedef struct {
    uint32_t  ABS_POS;                //!< CurrentPosition Register
    uint16_t  EL_POS;                 //!< ElectricalPosition Register
    uint32_t  MARK;                   //!< MarkPosition Register
    uint32_t  SPEED;                  //!< CurrentSpeed Register
    uint16_t  ACC;                    //!< Acceleration Register
    uint16_t  DEC;                    //!< Deceleration Register
    uint16_t  MAX_SPEED;              //!< MaximumSpeed Register
    uint16_t  MIN_SPEED;              //!< MinimumSpeed Register
    uint16_t  FS_SPD;                 //!< FullStepSpeed Register
    uint8_t   KVAL_HOLD;              //!< HoldingKval Register
    uint8_t   KVAL_RUN;               //!< ConstantSpeedKval Register
    uint8_t   KVAL_ACC;               //!< AccelerationStartingKval Register
    uint8_t   KVAL_DEC;               //!< DecelerationStartingKval Register
    uint16_t  INT_SPEED;              //!< IntersectSpeed Register
    uint8_t   ST_SLP;                 //!< StartSlope Register
    uint8_t   FN_SLP_ACC;             //!< AccelerationFinalSlope Register
    uint8_t   FN_SLP_DEC;             //!< DecelerationFinalSlope Register
    uint8_t   K_THERM;                //!< ThermalCompensationFactor Register
    uint8_t   ADC_OUT;                //!< AdcOutput Register
    uint8_t   OCD_TH;                 //!< OcdThreshold Register
    uint8_t   STALL_TH;               //!< StallThreshold Register
    uint8_t   STEP_MODE;              //!< StepMode Register
    uint8_t   ALARM_EN;               //!< AlarmEnable Register
    uint16_t  CONFIG;                 //!< Config Register
    uint16_t  STATUS;                 //!< Status Register
} StepperMotorRegister;

typedef enum {
    HiZ_ID = 0,                       //!< HiZ flag identifier inside the L6470 Status Register
    BUSY_ID,                          //!< BUSY flag identifier inside the L6470 Status Register
    SW_F_ID,                          //!< SW_F flag identifier inside the L6470 Status Register
    SW_EVN_ID,                        //!< SW_EVN flag identifier inside the L6470 Status Register
    DIR_ID,                           //!< DIR flag identifier inside the L6470 Status Register
    MOT_STATUS_ID,                    //!< MOT_STATUS flag identifier inside the L6470 Status Register
    NOTPERF_CMD_ID,                   //!< NOTPERF_CMD flag identifier inside the L6470 Status Register
    WRONG_CMD_ID,                     //!< WRONG_CMD flag identifier inside the L6470 Status Register
    UVLO_ID,                          //!< UVLO flag identifier inside the L6470 Status Register
    TH_WRN_ID,                        //!< TH_WRN flag identifier inside the L6470 Status Register
    TH_SD_ID,                         //!< TH_SD flag identifier inside the L6470 Status Register
    OCD_ID,                           //!< OCD flag identifier inside the L6470 Status Register
    STEP_LOSS_A_ID,                   //!< STEP_LOSS_A flag identifier inside the L6470 Status Register
    STEP_LOSS_B_ID,                   //!< STEP_LOSS_B flag identifier inside the L6470 Status Register
    SCK_MOD_ID                        //!< SCK_MOD flag identifier inside the L6470 Status Register
} FlagId_t;

class L6470DC
{
public:
    //L6470(PinName mosi, PinName miso, PinName sclk, PinName cs);
    L6470DC(int nMax, PinName mosi, PinName miso, PinName sclk, PinName cs);  //Lvh

    unsigned char send(unsigned char nMOT,unsigned char temp);
    void send_bytes(unsigned char nMOT,unsigned char temp[],int i);
    void NOP(unsigned char nMOT);
    void SetParam(unsigned char nMOT,L6470_Register param,int value);
    int  GetParam(unsigned char nMOT,L6470_Register param);
    void Run(unsigned char nMOT,unsigned char dir,float spd);
    void StepClock(unsigned char nMOT,unsigned char dir);
    void Move(unsigned char nMOT,unsigned char dir,int n_step);
    void GoTo(unsigned char nMOT,int abs_pos);
    void GoTo_DIR(unsigned char nMOT,unsigned char dir,int abs_pos);
    void GoUntil(unsigned char nMOT,unsigned char act,unsigned char dir,int spd);
    void ReleaseSW(unsigned char nMOT,unsigned char act,unsigned char dir);
    void GoHome(unsigned char nMOT);
    void GoMark(unsigned char nMOT);
    void ResetPos(unsigned char nMOT);
    void ResetDevice(unsigned char nMOT);
    void SoftStop(unsigned char nMOT);
    void HardStop(unsigned char nMOT);
    void SoftHiZ(unsigned char nMOT);
    void HardHiZ(unsigned char nMOT);
    void Resets(unsigned char nMOT);
    ////////////////////////////////////////////////////////////////////////////
    void Config(unsigned char nMOT, L6470_MotorConf *conf);
    int GetPosition(int nMOT);
    int GetMark(int nMOT);
    int GetSpeed(int nMOT);
    int GetStatus(int nMOT, FlagId_t FlagId);
    void SetHome(int nMOT);
    void SetMaxSpeed(int nMOT, int speed);
    void SetMark(int nMOT, int mark);

private:
    SPI m_spi;
    DigitalOut m_cs;
    int nMotMax;


    int32_t  L6470_AbsPos_2_Position(uint32_t AbsPos);
    uint32_t L6470_Position_2_AbsPos(int32_t Postion);
    float    L6470_Speed_2_Step_s(uint32_t Speed);
    uint32_t L6470_Step_s_2_Speed(float Step_s);
    float    L6470_Acc_2_Step_s2(uint16_t Acc);
    uint16_t L6470_Step_s2_2_Acc(float Step_s2);
    float    L6470_Dec_2_Step_s2(uint16_t Dec);
    uint16_t L6470_Step_s2_2_Dec(float Step_s2);
    float    L6470_MaxSpeed_2_Step_s(uint16_t MaxSpeed);
    uint16_t L6470_Step_s_2_MaxSpeed(float Step_s);
    float    L6470_MinSpeed_2_Step_s(uint16_t MinSpeed);
    uint16_t L6470_Step_s_2_MinSpeed(float Step_s);
    float    L6470_FsSpd_2_Step_s(uint16_t FsSpd);
    uint16_t L6470_Step_s_2_FsSpd(float Step_s);
    float    L6470_IntSpeed_2_Step_s(uint16_t IntSpeed);
    uint16_t L6470_Step_s_2_IntSpeed(float Step_s);
    float    L6470_StSlp_2_s_Step(uint8_t StSlp);
    uint8_t  L6470_s_Step_2_StSlp(float s_Step);
    float    L6470_FnSlpAcc_2_s_Step(uint8_t FnSlpAcc);
    uint8_t  L6470_s_Step_2_FnSlpAcc(float s_Step);
    float    L6470_FnSlpDec_2_s_Step(uint8_t FnSlpDec);
    uint8_t  L6470_s_Step_2_FnSlpDec(float s_Step);
    float    L6470_OcdTh_2_mA(uint8_t OcdTh);
    uint8_t  L6470_mA_2_OcdTh(float mA);
    float    L6470_StallTh_2_mA(uint8_t StallTh);
    uint8_t  L6470_mA_2_StallTh(float mA);


};


#endif