/** SEN0169 Class
*
* @purpose       MbedOs library for Gravity : Analog pH Sensor / Meter Kit V2, SKU: SEN0161-V2
*
* Example:
* @code
*
* #include "mbed.h"
* #include "lib_SEN0169.h"
*
* Serial pc(USBTX, USBRX, 230400);
* SEN0169 sensor_0(A0);
*
* int main()
* {
*    pc.printf("2022_TEST_SEN0169\n\r");
*    pc.printf("pH = (voltage - intercept) / slope\n\r");
*    while (true) {
*        ThisThread::sleep_for(1000);
*        pc.printf("voltage = %.03f ; pH = %.01f\n\r", sensor_0.read_voltage(), sensor_0.read_ph());
*        float* parameters = sensor_0.get_parameters();
*        pc.printf("ph4_voltage = %.03f ; pH7_voltage = %.03f ; pH10_voltage = %.03f ; slope = %f ; intercept = %f\n\r", parameters[0], parameters[1], parameters[2], parameters[3], parameters[4]);
*    }
* }
* 
* @endcode
*
* @file          lib_SEN0169.h 
* @date          Jan 2022
* @author        Jérémie SANCHEZ
*/

#ifndef _SEN0169_H_
#define _SEN0169_H_

#include "mbed.h"

class SEN0169
{
public:
    SEN0169(PinName data_pin);
    ~SEN0169();
    void    calibration(uint8_t ph_tampon);
    float*  get_parameters(void);
    float   read_voltage(void);
    float   read_ph(void);         

private:
    AnalogIn        _datapin;
    float           _phValue;
    float           _voltage;
    typedef enum    {ACIDE, NEUTRE, BASIC, SLOPE, INTERCEPT} enum_params;
    float           _params[5] = {2032.44f,1500.0f,967.56f,-177.48f,2742.36f};
};

#endif
