#include "lib_SEN0169.h"


SEN0169::SEN0169(PinName data_pin) : _datapin(data_pin)
{
    this->_phValue  = 7.0f;
    this->_voltage  = 1500.0f;
}

void SEN0169::calibration(uint8_t ph_tampon)
{
    float avg_voltage, buf_[20], temp_;

    for(int i=0; i<20; i++) {
        buf_[i]=_datapin.read();
        ThisThread::sleep_for(10ms);
    }
    for(int i=0; i<19; i++) {
        for(int j=i+1; j<20; j++) {
            if(buf_[i]>buf_[j]) {
                temp_=buf_[i];
                buf_[i]=buf_[j];
                buf_[j]=temp_;
            }
        }
    }
    avg_voltage = 0.0f;
    for(int i=5; i<15; i++) avg_voltage += buf_[i];
    avg_voltage = avg_voltage*3.3/10.0f;


    switch (ph_tampon) {
        case 4 :
            this->_params[ACIDE] = avg_voltage;
            break;

        case 7 :
            this->_params[NEUTRE] = avg_voltage;
            break;

        case 10 :
            this->_params[BASIC] = avg_voltage;
            break;

        default :
            break;
    }
}

float*   SEN0169::get_parameters(void)
{
    return _params;
}

float SEN0169::read_voltage(void)
{
    this->_voltage = _datapin.read()*3.3;
    return _voltage;
}

float SEN0169::read_ph(void)
{
    float avg_voltage, buf_[10], temp_;

    for(int i=0; i<10; i++) {           // take 10 samples of voltage
        buf_[i]=_datapin.read();
        ThisThread::sleep_for(10ms);
    }
    for(int i=0; i<9; i++) {            // sort the voltages from small to large
        for(int j=i+1; j<10; j++) {
            if(buf_[i]>buf_[j]) {
                temp_=buf_[i];
                buf_[i]=buf_[j];
                buf_[j]=temp_;
            }
        }
    }
    avg_voltage = 0.0f;
    for(int i=2; i<8; i++) avg_voltage += buf_[i];      // supress the 2 smallest and 2 largest samples
    avg_voltage = avg_voltage*3.3/6.0f;

    this->_voltage = avg_voltage;
    this->_params[SLOPE] = ((3.0f*(4.0f*_params[ACIDE]+7.0f*_params[NEUTRE]+10.0f*_params[BASIC]))-(21.0f*(_params[ACIDE]+_params[NEUTRE]+_params[BASIC])))/54.0f;
    // Slope = [3*sum(xy)-sum(x)*sum(y)]/[3*sum(x²)-sum(x)²]
    this->_params[INTERCEPT] =  ((_params[ACIDE] + _params[NEUTRE] + _params[BASIC])/3.0f) - (_params[SLOPE] * 7.0f);
    this->_phValue = (avg_voltage*1000.0 - _params[INTERCEPT]) / _params[SLOPE];

    return _phValue;
}