#include "main.h"

int main(void)
{
    if (T_anode.begin()&&T_cathode.begin()) {
        transmission.send(processing("*IDN?"),com);
        while(1) {
            T_anode.startConversion();
            T_cathode.startConversion();
            ThisThread::sleep_for(1s);
            T_anode.read(temperature_anode);
            T_cathode.read(temperature_cathode);
            ph_anode = PH_anode.read_ph();
            ph_cathode = PH_cathode.read_ph();
        }
    }
}

string processing(string cmd)
{
    ostringstream ssend;
    ssend << fixed;
    ssend.precision(2);
    if(cmd.empty());
    else if(cmd == "*IDN?") {
        ssend << MBED_PROJECT << ", Mbed OS " << MBED_VERSION << ", Version dated, " << __DATE__ << ", " << __TIME__;
    } else if(cmd == "MESURES?") {
        ssend << temperature_anode << " ; " << temperature_cathode << " ; " << ph_anode << " ; " << ph_cathode;

    } else if(cmd == "ANODE:INFOS?") {
        float* parameters = PH_anode.get_parameters();
        ssend << parameters[0] << " ; " << parameters[1] << " ; " << parameters[2] << " ; " << parameters[3] << " ; " << parameters[4];

    } else if(cmd == "CATHODE:INFOS?") {
        float* parameters = PH_anode.get_parameters();
        ssend << parameters[0] << " ; " << parameters[1] << " ; " << parameters[2] << " ; " << parameters[3] << " ; " << parameters[4];

    } else if(cmd.find("ANODE:CALIB: ") != string::npos) {
        stringstream param(cmd.substr(cmd.find(' ')+1));
        int tampon;
        param >> tampon;
        PH_anode.calibration(tampon);

    } else if(cmd.find("CATHODE:CALIB: ") != string::npos) {
        stringstream param(cmd.substr(cmd.find(' ')+1));
        int tampon;
        param >> tampon;
        PH_cathode.calibration(tampon);

    } else if(cmd[cmd.size()-1] == '?')
        ssend << "incorrect requeste [" << cmd << "]";

    return ssend.str();
}