#ifndef MAIN_H
#define MAIN_H
#define MBED_PROJECT    "2022_TICE_Electrolyse"
#define com Transmission::enum_trans_delivery::SERIAL_DELIVERY
 
#include "mbed.h"

#include "lib_Transmission.h"
#include "lib_SEN0169.h"
#include "DS1820.h"

UnbufferedSerial    pc(USBTX, USBRX, 230400);

SEN0169             PH_anode(A0);
DS1820              T_anode(A1);
SEN0169             PH_cathode(A2);
DS1820              T_cathode(A3);

string              processing(string);
Transmission        transmission(&pc, &processing);

// Prototypes __________________________________________________________________

void initialisations(void);
string processing(string);

// Variables ___________________________________________________________________

float       temperature_anode = 0.0f, temperature_cathode = 0.0f;
float       ph_anode = 0.0f, ph_cathode = 0.0f;
#endif