/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include "MicroBit.h"
#include "SparkFunDS3234RTC.h"

MicroBit uBit;
DS3234 rtcDS3234;

int mode = 0;
bool displaying = false;
bool interruptLoop = false;
uint8_t sec, minute, hour, day, date, month, year;

void displayTime(){
    rtcDS3234.update();
    uBit.display.scroll(rtcDS3234.hour());
    uBit.display.scroll(":");
    uBit.display.scroll(rtcDS3234.minute());
    uBit.display.scroll(":");
    uBit.display.scroll(rtcDS3234.second());
}

void displayLoop(){
    if (!displaying) {
        while (!interruptLoop) {
            displaying = true;
            displayTime();
            uBit.sleep(60000);
        }
        interruptLoop = false;
    }
}
 
void onButtonB(MicroBitEvent e)
{
    switch(mode) {
        case 0:
            displayTime();
            break;
        case 1:
            ++year;
            break;
        case 2:
            ++month;
            break;
        case 3:
            ++date;
            break;
        case 4:
            ++day;
            break;
        case 5:
            ++hour;
            break;
        case 6:
            ++minute;
            break;
    }
}

void onButtonA(MicroBitEvent e)
{
    switch(mode) {
        case 0:
            displayLoop();
            break;
        case 1:
            --year;
            break;
        case 2:
            --month;
            break;
        case 3:
            --date;
            break;
        case 4:
            --day;
            break;
        case 5:
            --hour;
            break;
        case 6:
            --minute;
            break;
    }
}

void onButtonAB(MicroBitEvent e)
{
    switch(++mode) {
        case 1:
            rtcDS3234.update();
            uBit.display.scroll("y");
            year = rtcDS3234.year();
            uBit.display.scroll(year);
            break;
        case 2:
            uBit.display.scroll("m");
            month = rtcDS3234.month();
            uBit.display.scroll(month);
            break;
        case 3:
            uBit.display.scroll("d");
            date = rtcDS3234.date();
            uBit.display.scroll(date);
            break;
        case 4:
            uBit.display.scroll("wd");
            day = rtcDS3234.day();
            uBit.display.scroll(day);
            break;
        case 5:
            uBit.display.scroll("h");
            hour = rtcDS3234.hour();
            uBit.display.scroll(hour);
            break;
        case 6:
            uBit.display.scroll("m");
            minute = rtcDS3234.minute();
            uBit.display.scroll(minute);
            break;
        default:
            mode = 0;
            sec = 0;
            rtcDS3234.setTime(sec, minute, hour, day, date, month, year);
            uBit.display.scroll(date);
            uBit.display.scroll(".");
            uBit.display.scroll(month);
            uBit.display.scroll(".");
            uBit.display.scroll(year);
            uBit.display.scroll(" ");
            displayTime();
    }
}

int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();

    // Insert your code here!
    uBit.display.scroll("init");
    
    rtcDS3234.begin(&uBit.io.P16, &uBit);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButtonA);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onButtonB);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_AB, MICROBIT_BUTTON_EVT_CLICK, onButtonAB);
    
    displayTime();

    release_fiber();
}

