#include "RangeTransform.h"

int RangeTransform::exponentialTransform(const int value, const int max, const int targetRangeMax) {
    float factor = nThRoot(max, targetRangeMax);
    float tmp=factor;
    float fVal=(float)(max-value);;
    int transformed=0;
    while (transformed<targetRangeMax && tmp<=fVal) {
        tmp *= factor;
        ++transformed;
    }
    
    return transformed;
}

float RangeTransform::nThRoot(const int radikant, const int wurzelpotenz)  {
    return pow(radikant, 1.0 / wurzelpotenz );
}