#include "MovingAverage.h"

MovingAverage::MovingAverage(const unsigned int maxElements) {
    _maxElements = maxElements;
    currentAverage = INVALID;
    _currentIndex = 0;
    _values = new uint32_t[_maxElements];
    for (int i=0 ; i<_maxElements ; ++ i) {
        _values[i] = uint32_t(0);
        }
    }
    
MovingAverage::~MovingAverage() {
    if (_values!=NULL) delete [] _values;
    }
    
uint32_t MovingAverage::average() {
    return currentAverage;
    }
    
void MovingAverage::add(const uint32_t value) {
    if (_maxElements==0) return;
    
    _values[_currentIndex] = value;
    if (++_currentIndex >= _maxElements) {
        _currentIndex = 0;
        }
    calcAverage();
    }
    
void MovingAverage::calcAverage() {
    uint32_t sum = 0;
    
    for (int i = 0 ; i < _maxElements ; ++i) {
        if (_values[i] != INVALID) {
            sum += _values[i];
            } else {
                currentAverage = INVALID;
                return;
            }
        }
        
    currentAverage = sum / _maxElements;
    }
    
const uint32_t* MovingAverage::debugInfo() {
    return _values;
    }