#include "mbed.h"
#include "MicroBit.h"

#ifndef I2C_CALLBACKS_H
#define I2C_CALLBACKS_H

class I2cCallbacks {
    public:
        I2cCallbacks(MicroBit* uBit);
        int read(const uint8_t dev_id, const uint8_t reg_addr, uint8_t *data, const uint16_t len);
        int read(const uint8_t dev_id, uint8_t *data, const uint16_t len);
        int write(const uint8_t dev_id, const uint8_t reg_addr, const uint8_t *data, const uint16_t len);
        int write(const uint8_t dev_id, const uint8_t *data, const uint16_t len);
        void delay_ms_relaxed(const uint32_t period);
        void delay_ms_strict(const uint32_t period);
        
    private:
        MicroBit* _uBit;
};

#endif // I2C_CALLBACKS_H