#include "MovingAverageTests.h"
#include "MovingAverage.h"

MovingAverageTests::MovingAverageTests() {
    lastFourValuesAverage = new MovingAverage(4);
    }
    
MovingAverageTests::~MovingAverageTests() {
    if (lastFourValuesAverage != NULL) delete lastFourValuesAverage;
    }
    
const char* MovingAverageTests::test() {
    if (lastFourValuesAverage->average() != MovingAverage::INVALID) return "mav initF";
    
    lastFourValuesAverage->add(1);
    if (lastFourValuesAverage->average() != MovingAverage::INVALID) return "mav ninVal1";
    
    lastFourValuesAverage->add(1);
    lastFourValuesAverage->add(2);
    
    if (lastFourValuesAverage->average() != MovingAverage::INVALID) return "mav ninVal2";
    
    lastFourValuesAverage->add(4);
    
    if (lastFourValuesAverage->average() != 2) return "mav av1F";
    
    lastFourValuesAverage->add(5);
    
    if (lastFourValuesAverage->average() != 3) return "mav av2F";
    
    lastFourValuesAverage->add(1);
    lastFourValuesAverage->add(1);
    lastFourValuesAverage->add(1);
    lastFourValuesAverage->add(1);
    
    if (lastFourValuesAverage->average() != 1) return "mav av3F";
    
    lastFourValuesAverage->add(MovingAverage::INVALID);
    
    if (lastFourValuesAverage->average() != MovingAverage::INVALID) return "mav av3F";
    
    delete lastFourValuesAverage;
    
    const int maxVals = 10;
    const uint32_t highValue = 2123123;
    lastFourValuesAverage = new MovingAverage(maxVals);
    for (int i=0 ; i < maxVals ; ++i) {
        lastFourValuesAverage->add(highValue);
        }
    if (lastFourValuesAverage->average() != highValue) return "mav highF";
    
    return TEST_OK_MESSAGE;
    }
    
