#include "i2c_callbacks.h"

I2cCallbacks::I2cCallbacks(MicroBit* uBit){
    _uBit = uBit;
}

int I2cCallbacks::read(const uint8_t address, const uint8_t reg, uint8_t *buffer, const uint16_t length){
    if (buffer == NULL || length <= 0)
        return MICROBIT_INVALID_PARAMETER;
        
    int result = _uBit->i2c.write(address, (const char *)&reg, 1, true);
    if (result == 0)
        result = _uBit->i2c.read(address, (char *)buffer, length);
    
    return result != 0 ? MICROBIT_I2C_ERROR : MICROBIT_OK;
}

int I2cCallbacks::read(const uint8_t address, uint8_t *buffer, const uint16_t length){
    if (buffer == NULL || length <= 0)
        return MICROBIT_INVALID_PARAMETER;
        
    int result = _uBit->i2c.read(address, (char *)buffer, length);
    
    if (result !=0)
        return MICROBIT_I2C_ERROR;

    return MICROBIT_OK;
}

int I2cCallbacks::write(const uint8_t dev_id, const uint8_t reg_addr, const uint8_t *data, const uint16_t length){
    char tmpBuf[length+1];
    tmpBuf[0] = reg_addr;
    for (int i=0,j=1; i <length ; ++i,++j){
        tmpBuf[j] = data[i];
    }
    
    return _uBit->i2c.write(dev_id, tmpBuf, length+1);
}

int I2cCallbacks::write(const uint8_t dev_id, const uint8_t *data, const uint16_t length){
    return _uBit->i2c.write(dev_id, (char*)data, length);
}

void I2cCallbacks::delay_ms_relaxed(const uint32_t period) {
    _uBit->sleep(period);
}

void I2cCallbacks::delay_ms_strict(const uint32_t period) {
    delay_ms_relaxed(period);
}