#include "mbed.h"
#include "MicroBit.h"

#include "i2c_callbacks.h"

#ifndef SGP30_H
#define SGP30_H

/*
the code has been taken from https://github.com/adafruit/Adafruit_SGP30

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing products from Adafruit!

The original code has been written by Limor Fried for Adafruit Industries

and only been slightly adjusted by me for mbed MicroBit compatibility
*/


class Sgp30 {
    public:
        Sgp30(I2cCallbacks *callbacks);
        bool begin();
        bool IAQmeasure();
        bool IAQmeasureRaw();
        bool test();
        bool setHumidity(const uint32_t rel_humidity, const uint32_t temperature);
        
        bool getIAQBaseline(uint16_t *eco2_base, uint16_t *tvoc_base);
        bool setIAQBaseline(uint16_t eco2_base, uint16_t tvoc_base);
        
        uint16_t TVOC;
        uint16_t eCO2;
        uint16_t rawH2;
        uint16_t rawEthanol;
        
        uint16_t serialnumber[3];
        
    private:
        I2cCallbacks *_callbacks;
        uint8_t _i2caddr;
        uint32_t _absolute_humidity;

        bool IAQinit();
        bool setHumidity(const uint32_t absolute_humidity);
        //void write(uint8_t address, uint8_t *data, uint8_t n);
        //void read(uint8_t address, uint8_t *data, uint8_t n);
        bool readWordFromCommand(const uint8_t command[], const uint8_t commandLength, const uint16_t delay, uint16_t *readdata = NULL, const uint8_t readlen = 0);
        uint8_t generateCRC(const uint8_t data[], const uint8_t datalen);

};

#endif // SGP30_H