#include "writeReadTests.h"

WriteReadTests:: WriteReadTests(MicroBit* uBit) : store(uBit){
}

const char* WriteReadTests::test(){
    
    uint16_t firstIn = 0xa7;
    uint16_t secondIn = 0x7a;
    uint16_t firstOut = 0x7a;
    uint16_t secondOut = 0xa7;
    uint16_t initial1 = 0, initial2 = 0;
    
    bool hadInitialValues = store.getIAQBaseline(&initial1, &initial2);
    
    store.storeIAQBaseline(firstIn, secondIn);
    
    if (!store.getIAQBaseline(&firstOut, &secondOut)){
        return "nvs read fail";
    }
    
    if (firstOut != firstIn || secondOut != secondIn) {
        return ManagedString("nvs ne " + ManagedString(firstOut) + " " + ManagedString(firstIn)).toCharArray();
    }
    
    if (hadInitialValues){
        store.storeIAQBaseline(initial1, initial2);
    } else {
        store.clearIQQBaseline();
    }
    
    return TEST_OK_MESSAGE;
}