#ifndef MovingAverage_H
#define MovingAverage_H

#include "mbed.h"

class MovingAverage {
    public:
        static const uint32_t INVALID = 0;
        
        MovingAverage(const unsigned int maxElements);
        ~MovingAverage();
        uint32_t average();
        void add(const uint32_t value);
        const uint32_t* debugInfo();
        
    private:
        int _maxElements;
        int _currentIndex;
        uint32_t* _values;
        uint32_t currentAverage;
        int maxVals;
        
        void calcAverage();
};

#endif // MovingAverage_H