#include <string.h>

#include "Testrunner.h"

Testrunner::Testrunner() {
    }
    
Testrunner::~Testrunner() {
    for (std::list<Testable*>::iterator testable = _testables.begin(); testable != _testables.end(); testable++) {
        delete *testable;
        }
    }

void Testrunner::addTestable(Testable* testable) {
    _testables.push_back (testable);
    }
    
const char* Testrunner::runAll() {
    for (std::list<Testable*>::iterator testable = _testables.begin(); testable != _testables.end(); testable++) {
        const char* testResult = (*testable)->test();
        if (! messageOK(testResult)) {
            return testResult;
            }
        }
    return Testable::TEST_OK_MESSAGE;
    }
    
bool Testrunner::messageOK(const char* message) {
    return strcmp (message, Testable::TEST_OK_MESSAGE) == 0;
    }