#include "physics.h"

int Physics::absHumidity(const int relHumidity, const int temperature){
    const float tmpFloat = (float)temperature;
    return (int)((relHumidity * saettigung(tmpFloat))/1000000);
}

float Physics::saettigung(const float tmpFloat) {
    float dd = saettigungsdampfdruck(tmpFloat);
    return dd/(4.6152*(273.15+tmpFloat));
}

float Physics::saettigungsdampfdruck(const float tmpFloat){
    const float t1 = 16.62 * tmpFloat;
    const float t2 = 243.12 + tmpFloat;
    const float factor1 = expf(t1 / t2);
    return 6112 * factor1;
}