#include "JavaScriptRadio.h"

#define JSCRIPT_MSG_TYPE_STRING 2

JavaScriptRadio::JavaScriptRadio(MicroBit* uBit, int group) {
    uBit->radio.enable();
    uBit->radio.setGroup(group);
    uBit->radio.setTransmitPower(7);
    _datagramm = &(uBit->radio).datagram;
}

int JavaScriptRadio::sendToMakeCodeDevices(ManagedString input){
    ManagedString content(input.substring(0, min(input.length(), 19))); 
    uint8_t buffer[32];
    buffer[0] = 2;
    buffer[9] = content.length();
    memcpy(&buffer[10], content.toCharArray(), buffer[9]);
    return _datagramm->send(buffer, 32);
}

ManagedString JavaScriptRadio::received(){
    PacketBuffer p = _datagramm->recv();
    uint8_t *buf = p.getBytes();
    if (buf[0] == JSCRIPT_MSG_TYPE_STRING) {
        return ManagedString((const char*)&(buf[10]), buf[9]);
    } else {
        return"";
    }
}